/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.descriptor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import org.crsh.cli.descriptor.ArgumentDescriptor;
import org.crsh.cli.descriptor.CommandDescriptor;
import org.crsh.cli.descriptor.OptionDescriptor;
import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.impl.lang.Util;

public abstract class Format {
    public static final Describe DESCRIBE = new Describe();
    public static final Usage USAGE = new Usage();
    public static final Man MAN = new Man();

    public abstract void print(CommandDescriptor<?> var1, Appendable var2) throws IOException;

    protected void printFQN(CommandDescriptor<?> command, Appendable stream) throws IOException {
        CommandDescriptor<?> owner = command.getOwner();
        if (owner != null) {
            this.printFQN(owner, stream);
            stream.append(' ');
        }
        stream.append(command.getName());
    }

    protected void printFQNWithOptions(CommandDescriptor<?> command, Appendable stream) throws IOException {
        CommandDescriptor<?> owner = command.getOwner();
        if (owner != null) {
            this.printFQNWithOptions(owner, stream);
            stream.append(' ');
        }
        stream.append(command.getName());
        for (OptionDescriptor option : command.getOptions()) {
            stream.append(' ');
            option.printUsage(stream);
        }
    }

    public static class Usage
    extends Format {
        @Override
        public void print(CommandDescriptor<?> command, Appendable stream) throws IOException {
            this.printUsageSection(command, stream);
            this.printDetailsSection(command, stream);
        }

        public void printUsageSection(CommandDescriptor<?> command, Appendable stream) throws IOException {
            stream.append("usage: ");
            this.printFQNWithOptions(command, stream);
            if (command.getSubordinates().size() > 0) {
                stream.append(" COMMAND [ARGS]");
            } else {
                for (ArgumentDescriptor argument : command.getArguments()) {
                    stream.append(' ');
                    argument.printUsage(stream);
                }
            }
            stream.append("\n\n");
        }

        private List<String[]> collectParametersTuples(CommandDescriptor<?> command) throws IOException {
            Collection<OptionDescriptor> parameters;
            List<String[]> tuples;
            CommandDescriptor<?> owner = command.getOwner();
            if (owner != null) {
                tuples = this.collectParametersTuples(owner);
                parameters = command.getOptions();
            } else {
                tuples = new ArrayList<String[]>();
                parameters = command.getParameters();
            }
            for (ParameterDescriptor parameterDescriptor : parameters) {
                StringBuilder sb = new StringBuilder();
                parameterDescriptor.printUsage(sb);
                String usage = sb.toString();
                tuples.add(new String[]{usage, parameterDescriptor.getUsage()});
            }
            return tuples;
        }

        public void printDetailsSection(CommandDescriptor<?> command, Appendable stream) throws IOException {
            if (command.getSubordinates().isEmpty()) {
                List<String[]> tt = this.collectParametersTuples(command);
                int length = 0;
                for (String[] stringArray : tt) {
                    length = Math.max(stringArray[0].length(), length);
                }
                String format = "   %1$-" + length + "s %2$s\n";
                for (String[] tuple : tt) {
                    Formatter formatter = new Formatter(stream);
                    formatter.format(format, tuple[0], tuple[1]);
                }
            } else {
                stream.append("The most commonly used ").append(command.getName()).append(" commands are:\n");
                String format = "   %1$-16s %2$s\n";
                for (CommandDescriptor<?> subordinate : command.getSubordinates().values()) {
                    Formatter formatter = new Formatter(stream);
                    formatter.format(format, subordinate.getName(), subordinate.getUsage());
                }
            }
            stream.append("\n\n");
        }
    }

    public static class Man
    extends Format {
        @Override
        public void print(CommandDescriptor<?> command, Appendable stream) throws IOException {
            this.printNameSection(command, stream);
            this.printSynopsisSection(command, stream);
            this.printDescriptionSection(command, stream);
            this.printParametersSection(command, stream);
        }

        public void printNameSection(CommandDescriptor<?> command, Appendable stream) throws IOException {
            stream.append("NAME\n");
            stream.append(Util.MAN_TAB);
            this.printFQN(command, stream);
            String usage = command.getUsage();
            if (usage.length() > 0) {
                stream.append(" - ").append(usage);
            }
            stream.append("\n\n");
        }

        public void printSynopsisSection(CommandDescriptor<?> command, Appendable stream) throws IOException {
            stream.append("SYNOPSIS\n");
            stream.append(Util.MAN_TAB);
            this.printFQNWithOptions(command, stream);
            if (command.getSubordinates().size() > 0) {
                stream.append(" COMMAND [ARGS]");
            } else {
                for (ArgumentDescriptor argument : command.getArguments()) {
                    stream.append(' ');
                    argument.printUsage(stream);
                }
            }
            stream.append("\n\n");
        }

        public void printDescriptionSection(CommandDescriptor<?> command, Appendable stream) throws IOException {
            String man = command.getDescription().getMan();
            if (man.length() > 0) {
                stream.append("DESCRIPTION\n");
                Util.indent(Util.MAN_TAB, (CharSequence)man, stream);
                stream.append("\n\n");
            }
        }

        public void printParametersSection(CommandDescriptor<?> command, Appendable stream) throws IOException {
            boolean printed = this.printOptions(false, command, stream);
            if (command.getSubordinates().size() > 0) {
                stream.append("COMMANDS\n");
                this.printSubordinates(command, stream);
            } else {
                this.printParameters(printed, command, stream);
            }
        }

        protected void printSubordinates(CommandDescriptor<?> command, Appendable stream) throws IOException {
            for (CommandDescriptor<?> subordinate : command.getSubordinates().values()) {
                stream.append(Util.MAN_TAB).append(subordinate.getName());
                String methodText = subordinate.getDescription().getBestEffortMan();
                if (methodText.length() > 0) {
                    stream.append("\n");
                    Util.indent(Util.MAN_TAB_EXTRA, (CharSequence)methodText, stream);
                }
                stream.append("\n\n");
            }
        }

        protected boolean printOptions(boolean printed, CommandDescriptor<?> command, Appendable stream) throws IOException {
            CommandDescriptor<?> owner = command.getOwner();
            if (owner != null) {
                printed = this.printOptions(printed, owner, stream);
            }
            for (OptionDescriptor option : command.getOptions()) {
                printed = this.printParameter(printed, option, stream);
            }
            return printed;
        }

        protected boolean printParameters(boolean printed, CommandDescriptor<?> command, Appendable stream) throws IOException {
            for (ArgumentDescriptor argument : command.getArguments()) {
                printed = this.printParameter(printed, argument, stream);
            }
            return printed;
        }

        protected boolean printParameter(boolean printed, ParameterDescriptor parameter, Appendable stream) throws IOException {
            if (!printed) {
                stream.append("PARAMETERS\n");
            }
            stream.append(Util.MAN_TAB);
            parameter.printUsage(stream);
            String parameterText = parameter.getDescription().getBestEffortMan();
            if (parameterText.length() > 0) {
                stream.append("\n");
                Util.indent(Util.MAN_TAB_EXTRA, (CharSequence)parameterText, stream);
            }
            stream.append("\n\n");
            return true;
        }
    }

    public static class Describe
    extends Format {
        @Override
        public void print(CommandDescriptor<?> command, Appendable stream) throws IOException {
            stream.append(command.getUsage());
        }
    }
}

