/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.rich.html;

import com.contentful.java.cda.rich.CDARichDocument;
import com.contentful.java.cda.rich.CDARichHeading;
import com.contentful.java.cda.rich.CDARichHorizontalRule;
import com.contentful.java.cda.rich.CDARichHyperLink;
import com.contentful.java.cda.rich.CDARichListItem;
import com.contentful.java.cda.rich.CDARichOrderedList;
import com.contentful.java.cda.rich.CDARichParagraph;
import com.contentful.java.cda.rich.CDARichQuote;
import com.contentful.java.cda.rich.CDARichText;
import com.contentful.java.cda.rich.CDARichUnorderedList;
import com.contentful.rich.core.Processor;
import com.contentful.rich.core.Renderer;
import com.contentful.rich.html.HtmlContext;
import com.contentful.rich.html.renderer.DynamicTagRenderer;
import com.contentful.rich.html.renderer.TagRenderer;
import com.contentful.rich.html.renderer.TagWithArgumentsRenderer;
import com.contentful.rich.html.renderer.TextRenderer;
import javax.annotation.Nonnull;

class HtmlRendererProvider {
    HtmlRendererProvider() {
    }

    void provide(@Nonnull Processor<HtmlContext, String> processor) {
        processor.addRenderer((context, node) -> node instanceof CDARichText, (Renderer)new TextRenderer());
        processor.addRenderer((context, node) -> node instanceof CDARichHorizontalRule, (context, node) -> "<hr/>");
        processor.addRenderer((context, node) -> node instanceof CDARichDocument, (Renderer)new TagRenderer(processor, "div"));
        processor.addRenderer((context, node) -> node instanceof CDARichHyperLink && ((CDARichHyperLink)node).getData() instanceof String, (Renderer)new TagWithArgumentsRenderer(processor, "a", node -> TagWithArgumentsRenderer.mapifyArguments("href", (String)((CDARichHyperLink)node).getData())));
        processor.addRenderer((context, node) -> node instanceof CDARichQuote, (Renderer)new TagRenderer(processor, "blockquote"));
        processor.addRenderer((context, node) -> node instanceof CDARichHeading && ((CDARichHeading)node).getLevel() >= 1 && ((CDARichHeading)node).getLevel() <= 6, (Renderer)new DynamicTagRenderer(processor, node -> "h" + ((CDARichHeading)node).getLevel()));
        processor.addRenderer((context, node) -> node instanceof CDARichOrderedList, (Renderer)new TagRenderer(processor, "ol"));
        processor.addRenderer((context, node) -> node instanceof CDARichListItem, (Renderer)new TagRenderer(processor, "li"));
        processor.addRenderer((context, node) -> node instanceof CDARichUnorderedList, (Renderer)new TagRenderer(processor, "ul"));
        processor.addRenderer((context, node) -> node instanceof CDARichParagraph, (Renderer)new TagRenderer(processor, "p"));
    }
}

