/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.AbsQuery;
import com.contentful.java.cda.CDACallback;
import com.contentful.java.cda.CDAClient;
import com.contentful.java.cda.CDAEntry;
import com.contentful.java.cda.CDAResourceNotFoundException;
import com.contentful.java.cda.Callbacks;
import com.contentful.java.cda.ObserveQuery;
import io.reactivex.Flowable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class TransformQuery<Transformed>
extends AbsQuery<Transformed, TransformQuery<Transformed>> {
    private final String contentTypeId;
    private final Map<String, Transformed> instanceCache = new HashMap<String, Transformed>();

    TransformQuery(Class<Transformed> type, CDAClient client) {
        super(type, client);
        ContentfulEntryModel model = type.getAnnotation(ContentfulEntryModel.class);
        if (model == null) {
            throw new IllegalArgumentException("Cannot transform a class without ContentfulEntryModel annotation.");
        }
        try {
            type.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot create new instance of custom model.", e);
        }
        this.contentTypeId = model.value();
        this.withContentType(this.contentTypeId);
        for (Field field : type.getDeclaredFields()) {
            ContentfulField annotation = field.getAnnotation(ContentfulField.class);
            if (annotation != null) {
                this.parseFieldAnnotation(field, annotation);
                continue;
            }
            ContentfulSystemField systemField = field.getAnnotation(ContentfulSystemField.class);
            if (systemField == null) continue;
            this.parseSystemFieldAnnotation(field, systemField);
        }
    }

    private void parseFieldAnnotation(Field field, ContentfulField annotation) {
        String name = annotation.value().isEmpty() ? field.getName() : annotation.value();
        this.select("fields." + name);
    }

    private void parseSystemFieldAnnotation(Field field, ContentfulSystemField annotation) {
        String name = annotation.value().isEmpty() ? field.getName() : annotation.value();
        this.select("sys." + name);
    }

    public Flowable<Transformed> one(String id) {
        try {
            return this.baseQuery().one(id).filter(entry -> entry.contentType().id().equals(this.contentTypeId)).map(this::transform);
        }
        catch (NullPointerException e) {
            throw new CDAResourceNotFoundException(CDAEntry.class, id);
        }
    }

    public CDACallback<Transformed> one(String id, CDACallback<Transformed> callback) {
        return Callbacks.subscribeAsync(this.baseQuery().one(id).filter(entry -> entry.contentType().id().equals(this.contentTypeId)).map(this::transform), callback, this.client);
    }

    public Flowable<Collection<Transformed>> all() {
        return this.baseQuery().all().map(array -> array.items.stream().filter(entry -> entry instanceof CDAEntry && ((CDAEntry)entry).contentType().id().equals(this.contentTypeId)).map(item -> this.transform((CDAEntry)item)).collect(Collectors.toList()));
    }

    public CDACallback<Collection<Transformed>> all(CDACallback<Collection<Transformed>> callback) {
        return Callbacks.subscribeAsync(this.baseQuery().all().map(array -> array.items.stream().filter(entry -> entry instanceof CDAEntry && ((CDAEntry)entry).contentType().id().equals(this.contentTypeId)).map(item -> this.transform((CDAEntry)item)).collect(Collectors.toList())), callback, this.client);
    }

    private ObserveQuery<CDAEntry> baseQuery() {
        return (ObserveQuery)this.client.observe(CDAEntry.class).where(this.params);
    }

    private Transformed transform(CDAEntry entry) {
        Object result;
        if (this.instanceCache.containsKey(entry.id())) {
            result = this.instanceCache.get(entry.id());
        } else {
            try {
                result = this.type.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot transform entry " + entry + "  to type " + this.type.getCanonicalName());
            }
            this.instanceCache.put(entry.id(), result);
            for (Field field : this.type.getDeclaredFields()) {
                ContentfulField annotation = field.getAnnotation(ContentfulField.class);
                if (annotation != null) {
                    this.transformFieldAnnotation(entry, result, field, annotation);
                    continue;
                }
                ContentfulSystemField systemField = field.getAnnotation(ContentfulSystemField.class);
                if (systemField == null) continue;
                this.transformSystemFieldAnnotation(entry, result, field, systemField);
            }
        }
        return (Transformed)result;
    }

    private void transformFieldAnnotation(CDAEntry entry, Transformed result, Field field, ContentfulField annotation) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        String key = annotation.value().isEmpty() ? field.getName() : annotation.value();
        String locale = annotation.locale().isEmpty() ? entry.defaultLocale : annotation.locale();
        try {
            Object value = entry.getField(locale, key);
            if (value instanceof CDAEntry && ((CDAEntry)value).contentType().id().equals(this.contentTypeId)) {
                CDAEntry fieldEntry = (CDAEntry)value;
                if (!this.instanceCache.containsKey(fieldEntry.id())) {
                    this.transform(fieldEntry);
                }
                field.set(result, this.instanceCache.get(fieldEntry.id()));
            } else {
                field.set(result, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot set custom field " + key + ".");
        }
    }

    private void transformSystemFieldAnnotation(CDAEntry entry, Transformed result, Field field, ContentfulSystemField annotation) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        String key = annotation.value().isEmpty() ? field.getName() : annotation.value();
        try {
            field.set(result, entry.getAttribute(key));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot set custom system field " + key + ".");
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ContentfulSystemField {
        public String value() default "";
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ContentfulField {
        public String value() default "";

        public String locale() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ContentfulEntryModel {
        public String value();
    }
}

