/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.ArrayResource;
import com.contentful.java.cda.CDAAsset;
import com.contentful.java.cda.CDAClient;
import com.contentful.java.cda.CDAContentType;
import com.contentful.java.cda.CDAContentTypeNotFoundException;
import com.contentful.java.cda.CDAEntry;
import com.contentful.java.cda.CDAField;
import com.contentful.java.cda.CDALocale;
import com.contentful.java.cda.CDAResource;
import com.contentful.java.cda.CDAResourceNotFoundException;
import com.contentful.java.cda.CDAType;
import com.contentful.java.cda.Cache;
import com.contentful.java.cda.Constants;
import com.contentful.java.cda.LocalizedResource;
import com.contentful.java.cda.ResourceFactory;
import com.contentful.java.cda.SynchronizedSpace;
import com.contentful.java.cda.Util;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import retrofit2.Response;

public final class ResourceUtils {
    private ResourceUtils() {
        throw new AssertionError();
    }

    static SynchronizedSpace iterate(Response<SynchronizedSpace> spaceResponse, CDAClient client) {
        SynchronizedSpace nextSpace;
        SynchronizedSpace space = ResourceFactory.fromResponse(spaceResponse);
        List items = space.items;
        while ((nextSpace = ResourceUtils.nextSpace(space, client)) != null) {
            items.addAll(nextSpace.items());
            space = nextSpace;
        }
        space.items = items;
        ResourceUtils.localizeResources(space.items(), client.cache);
        return space;
    }

    static SynchronizedSpace nextSpace(SynchronizedSpace space, CDAClient client) {
        String nextPageUrl = space.nextPageUrl();
        if (nextPageUrl == null) {
            return null;
        }
        Response synchronizedSpace = (Response)client.service.sync(client.spaceId, client.environmentId, null, Util.queryParam(nextPageUrl, "sync_token"), null, null).blockingFirst();
        return (SynchronizedSpace)synchronizedSpace.body();
    }

    static void resolveLinks(ArrayResource array, CDAClient client) {
        for (CDAEntry entry : array.entries().values()) {
            ResourceUtils.ensureContentType(entry, client);
            for (CDAField field : entry.contentType().fields()) {
                if (field.linkType() != null) {
                    ResourceUtils.resolveSingleLink(entry, field, array);
                    continue;
                }
                if (!"Array".equals(field.type) || !"Link".equals(field.items().get("type"))) continue;
                ResourceUtils.resolveArrayOfLinks(entry, field, array);
            }
        }
    }

    public static void ensureContentType(CDAEntry entry, CDAClient client) {
        CDAContentType contentType = entry.contentType();
        if (contentType != null) {
            return;
        }
        String contentTypeId = (String)Util.extractNested(entry.attrs(), "contentType", "sys", "id");
        try {
            contentType = (CDAContentType)client.cacheTypeWithId(contentTypeId).blockingFirst();
        }
        catch (CDAResourceNotFoundException e) {
            throw new CDAContentTypeNotFoundException(entry.id(), CDAEntry.class, contentTypeId, e);
        }
        entry.setContentType(contentType);
    }

    static void resolveArrayOfLinks(CDAEntry entry, CDAField field, ArrayResource array) {
        CDAType linkType = CDAType.valueOf(((String)field.items().get("linkType")).toUpperCase(Constants.LOCALE));
        Map value = (Map)entry.fields.get(field.id());
        if (value == null) {
            return;
        }
        for (String locale : value.keySet()) {
            List links = (List)value.get(locale);
            if (links == null) continue;
            ArrayList<CDAResource> resolved = new ArrayList<CDAResource>();
            for (Object link : links) {
                CDAResource resource;
                String linkId = ResourceUtils.getLinkId(link);
                if (linkId == null || (resource = ResourceUtils.findLinkedResource(array, linkType, linkId)) == null) continue;
                resolved.add(resource);
            }
            value.put(locale, resolved);
        }
    }

    static void resolveSingleLink(CDAEntry entry, CDAField field, ArrayResource array) {
        CDAType linkType = CDAType.valueOf(field.linkType().toUpperCase(Constants.LOCALE));
        Map value = (Map)entry.fields.get(field.id());
        if (value == null) {
            return;
        }
        HashSet<String> toRemove = new HashSet<String>();
        for (String locale : value.keySet()) {
            String linkId = ResourceUtils.getLinkId(value.get(locale));
            if (linkId == null) continue;
            CDAResource resource = ResourceUtils.findLinkedResource(array, linkType, linkId);
            if (resource == null) {
                toRemove.add(locale);
                continue;
            }
            value.put(locale, resource);
        }
        for (String locale : toRemove) {
            value.remove(locale);
        }
    }

    static String getLinkId(Object link) {
        if (link == null) {
            return null;
        }
        if (link instanceof CDAResource) {
            return ((CDAResource)link).id();
        }
        return (String)Util.extractNested((Map)link, "sys", "id");
    }

    static CDAResource findLinkedResource(ArrayResource array, CDAType linkType, String id) {
        if (CDAType.ASSET.equals((Object)linkType)) {
            return array.assets().get(id);
        }
        if (CDAType.ENTRY.equals((Object)linkType)) {
            return array.entries().get(id);
        }
        return null;
    }

    static void mapResources(Collection<? extends CDAResource> resources, Map<String, CDAAsset> assets, Map<String, CDAEntry> entries) {
        for (CDAResource cDAResource : resources) {
            CDAType type = cDAResource.type();
            String id = cDAResource.id();
            if (CDAType.ASSET.equals((Object)type)) {
                assets.put(id, (CDAAsset)cDAResource);
                continue;
            }
            if (CDAType.DELETEDASSET.equals((Object)type)) {
                assets.remove(id);
                continue;
            }
            if (CDAType.DELETEDENTRY.equals((Object)type)) {
                entries.remove(id);
                continue;
            }
            if (!CDAType.ENTRY.equals((Object)type)) continue;
            entries.put(id, (CDAEntry)cDAResource);
        }
    }

    static void mapDeletedResources(SynchronizedSpace space) {
        HashSet<Object> assets = space.deletedAssets == null ? new HashSet() : new HashSet<String>(space.deletedAssets);
        HashSet<Object> entries = space.deletedEntries == null ? new HashSet() : new HashSet<String>(space.deletedEntries);
        Flowable.fromIterable(space.items()).filter(resource -> {
            CDAType type = resource.type();
            return CDAType.DELETEDASSET.equals((Object)type) || CDAType.DELETEDENTRY.equals((Object)type);
        }).subscribe(resource -> {
            if (CDAType.DELETEDASSET.equals((Object)resource.type())) {
                assets.add(resource.id());
            } else {
                entries.add(resource.id());
            }
        });
        space.deletedAssets = assets;
        space.deletedEntries = entries;
    }

    static void localizeResources(Collection<? extends CDAResource> resources, Cache cache) {
        for (CDAResource cDAResource : resources) {
            CDAType type = cDAResource.type();
            if (!CDAType.ASSET.equals((Object)type) && !CDAType.ENTRY.equals((Object)type)) continue;
            ResourceUtils.localize((LocalizedResource)cDAResource, cache);
        }
    }

    static void localize(LocalizedResource resource, Cache cache) {
        resource.defaultLocale = cache.defaultLocale().code();
        resource.fallbackLocaleMap = ResourceUtils.getFallbackLocaleMap(cache);
        String resourceLocale = (String)resource.getAttribute("locale");
        if (resourceLocale != null) {
            resource.defaultLocale = resourceLocale;
            ResourceUtils.normalizeFields(resource);
        }
    }

    private static Map<String, String> getFallbackLocaleMap(Cache cache) {
        HashMap<String, String> fallbackLocales = new HashMap<String, String>(cache.locales().size());
        for (CDALocale locale : cache.locales()) {
            String fallback = locale.fallbackLocaleCode();
            if (fallback == null || "".equals(fallback)) continue;
            fallbackLocales.put(locale.code, fallback);
        }
        return fallbackLocales;
    }

    static void normalizeFields(LocalizedResource resource) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (String key : resource.fields.keySet()) {
            Object value = resource.fields.get(key);
            if (value == null) continue;
            if (ResourceUtils.resourceContainsLocaleMap(resource, value)) {
                fields.put(key, value);
                continue;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(resource.defaultLocale, value);
            fields.put(key, map);
        }
        resource.fields = fields;
    }

    private static boolean resourceContainsLocaleMap(LocalizedResource resource, Object value) {
        return value instanceof Map && ((Map)value).containsKey(resource.defaultLocale);
    }

    static void setRawFields(ArrayResource array) {
        for (CDAAsset asset : array.assets().values()) {
            ResourceUtils.setRawFields(asset);
        }
        for (CDAEntry entry : array.entries().values()) {
            ResourceUtils.setRawFields(entry);
        }
    }

    private static void setRawFields(LocalizedResource resource) {
        HashMap<String, Object> rawFields = new HashMap<String, Object>();
        for (String key : resource.fields.keySet()) {
            HashMap map = new HashMap((Map)resource.fields.get(key));
            rawFields.put(key, map);
        }
        resource.rawFields = rawFields;
    }
}

