/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.tools;

import org.cojen.tupl.Database;
import org.cojen.tupl.DatabaseConfig;
import org.cojen.tupl.Index;
import org.cojen.tupl.VerificationObserver;

public class Verify
extends VerificationObserver {
    private int failed;
    private long totalNodeCount;
    private long totalEntryCount;
    private long totalFreeBytes;
    private long totalLargeValues;

    public static void main(String[] args) throws Exception {
        Database db = Database.open(new DatabaseConfig().baseFilePath(args[0]));
        System.out.println(db.stats());
        Verify v = new Verify();
        db.verify(v);
        System.out.println(v);
        System.exit(v.failed);
    }

    @Override
    public boolean indexBegin(Index ix, int height) {
        System.out.println("Index: " + ix.getNameString() + ", height: " + height);
        return super.indexBegin(ix, height);
    }

    @Override
    public boolean indexNodePassed(long id, int level, int entryCount, int freeBytes, int largeValueCount) {
        this.totalEntryCount += (long)entryCount;
        this.totalFreeBytes += (long)freeBytes;
        this.totalLargeValues += (long)largeValueCount;
        if (++this.totalNodeCount % 10000L == 0L) {
            System.out.println(this);
        }
        return true;
    }

    @Override
    public boolean indexNodeFailed(long id, int level, String message) {
        this.failed = 1;
        return super.indexNodeFailed(id, level, message);
    }

    public String toString() {
        return "totalNodeCount: " + this.totalNodeCount + ", totalEntryCount: " + this.totalEntryCount + ", totalFreeBytes: " + this.totalFreeBytes + ", totalLargeValues: " + this.totalLargeValues;
    }
}

