/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.cojen.tupl.io.NamedThreadFactory;
import org.cojen.tupl.io.PageArray;
import org.cojen.tupl.io.Utils;

public class StripedPageArray
extends PageArray {
    private final PageArray[] mArrays;
    private final boolean mReadOnly;
    private final ExecutorService mSyncService;
    private final Syncer[] mSyncers;

    public StripedPageArray(PageArray ... arrays) {
        super(StripedPageArray.pageSize(arrays));
        this.mArrays = arrays;
        boolean readOnly = false;
        for (PageArray pa : arrays) {
            readOnly |= pa.isReadOnly();
        }
        this.mReadOnly = readOnly;
        this.mSyncService = Executors.newCachedThreadPool(new NamedThreadFactory("Syncer"));
        this.mSyncers = new Syncer[arrays.length - 1];
        for (int i = 0; i < this.mSyncers.length; ++i) {
            this.mSyncers[i] = new Syncer(arrays[i]);
        }
    }

    private static int pageSize(PageArray ... arrays) {
        int pageSize = arrays[0].pageSize();
        for (int i = 1; i < arrays.length; ++i) {
            if (arrays[i].pageSize() == pageSize) continue;
            throw new IllegalArgumentException("Inconsistent page sizes");
        }
        return pageSize;
    }

    @Override
    public boolean isReadOnly() {
        return this.mReadOnly;
    }

    @Override
    public boolean isEmpty() throws IOException {
        for (PageArray pa : this.mArrays) {
            if (pa.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getPageCount() throws IOException {
        long count = 0L;
        for (PageArray pa : this.mArrays) {
            if ((count += pa.getPageCount()) >= 0L) continue;
            return Long.MAX_VALUE;
        }
        return count;
    }

    @Override
    public void setPageCount(long count) throws IOException {
        int stripes = this.mArrays.length;
        count = (count + (long)stripes - 1L) / (long)stripes;
        for (PageArray pa : this.mArrays) {
            pa.setPageCount(count);
        }
    }

    @Override
    public long getPageCountLimit() throws IOException {
        long limit = -1L;
        for (PageArray pa : this.mArrays) {
            long subLimit = pa.getPageCountLimit();
            if (subLimit < 0L) continue;
            limit = limit < 0L ? subLimit : Math.min(limit, subLimit);
        }
        return limit < 0L ? limit : limit * (long)this.mArrays.length;
    }

    @Override
    public void readPage(long index, byte[] dst, int offset, int length) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        arrays[(int)(index % (long)stripes)].readPage(index / (long)stripes, dst, offset, length);
    }

    @Override
    public void readPage(long index, long dstPtr, int offset, int length) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        arrays[(int)(index % (long)stripes)].readPage(index / (long)stripes, dstPtr, offset, length);
    }

    @Override
    public void writePage(long index, byte[] src, int offset) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        arrays[(int)(index % (long)stripes)].writePage(index / (long)stripes, src, offset);
    }

    @Override
    public void writePage(long index, long srcPtr, int offset) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        arrays[(int)(index % (long)stripes)].writePage(index / (long)stripes, srcPtr, offset);
    }

    @Override
    public byte[] evictPage(long index, byte[] buf) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        return arrays[(int)(index % (long)stripes)].evictPage(index / (long)stripes, buf);
    }

    @Override
    public long evictPage(long index, long bufPtr) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        return arrays[(int)(index % (long)stripes)].evictPage(index / (long)stripes, bufPtr);
    }

    @Override
    public long directPagePointer(long index) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        return arrays[(int)(index % (long)stripes)].directPagePointer(index / (long)stripes);
    }

    @Override
    public long copyPage(long srcIndex, long dstIndex) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        PageArray src = arrays[(int)(srcIndex % (long)stripes)];
        srcIndex /= (long)stripes;
        PageArray dst = arrays[(int)(dstIndex % (long)stripes)];
        dstIndex /= (long)stripes;
        if (src == dst) {
            return dst.copyPage(srcIndex, dstIndex);
        }
        return dst.copyPageFromPointer(src.directPagePointer(srcIndex), dstIndex);
    }

    @Override
    public long copyPageFromPointer(long srcPointer, long dstIndex) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        return arrays[(int)(dstIndex % (long)stripes)].copyPageFromPointer(srcPointer, dstIndex / (long)stripes);
    }

    @Override
    public void sync(boolean metadata) throws IOException {
        int i;
        Syncer[] syncers = this.mSyncers;
        for (i = 0; i < syncers.length; ++i) {
            Syncer syncer = syncers[i];
            syncer.reset(metadata);
            try {
                this.mSyncService.execute(syncer);
                continue;
            }
            catch (RejectedExecutionException e) {
                if (this.mSyncService.isShutdown()) {
                    return;
                }
                throw new IOException(e);
            }
        }
        this.mArrays[i].sync(metadata);
        for (Syncer syncer : syncers) {
            syncer.check();
        }
    }

    @Override
    public void syncPage(long index) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        arrays[(int)(index % (long)stripes)].syncPage(index / (long)stripes);
    }

    @Override
    public void close(Throwable cause) throws IOException {
        this.mSyncService.shutdown();
        IOException ex = null;
        for (PageArray pa : this.mArrays) {
            ex = Utils.closeQuietly(ex, pa, cause);
        }
        if (ex != null) {
            throw ex;
        }
    }

    @Override
    public StripedPageArray open() throws IOException {
        if (!this.mSyncService.isShutdown()) {
            return this;
        }
        for (int i = 0; i < this.mArrays.length; ++i) {
            this.mArrays[i] = this.mArrays[i].open();
        }
        return new StripedPageArray(this.mArrays);
    }

    private static class Syncer
    implements Runnable {
        private final PageArray mArray;
        private boolean mMetadata;
        private boolean mFinished;
        private Throwable mException;

        Syncer(PageArray pa) {
            this.mArray = pa;
        }

        @Override
        public synchronized void run() {
            try {
                this.mArray.sync(this.mMetadata);
            }
            catch (Throwable e) {
                this.mException = e;
            }
            finally {
                this.mFinished = true;
                this.notify();
            }
        }

        synchronized void reset(boolean metadata) {
            this.mMetadata = metadata;
            this.mFinished = false;
            this.mException = null;
        }

        synchronized void check() throws IOException {
            try {
                while (!this.mFinished) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            Throwable e = this.mException;
            if (e != null) {
                throw new IOException(e.toString(), e);
            }
        }
    }
}

