/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.cojen.tupl.io.Mapping;
import org.cojen.tupl.io.Utils;

final class NioMapping
extends Mapping {
    private final RandomAccessFile mRaf;
    private final FileChannel mChannel;
    private final MappedByteBuffer mBuffer;

    NioMapping(File file, boolean readOnly, long position, int size) throws IOException {
        this.mRaf = new RandomAccessFile(file, readOnly ? "r" : "rw");
        this.mChannel = this.mRaf.getChannel();
        this.mBuffer = this.mChannel.map(readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, position, size);
    }

    @Override
    void read(int start, byte[] b, int off, int len) {
        ByteBuffer src = this.mBuffer.slice();
        src.position(start);
        src.get(b, off, len);
    }

    @Override
    void read(int start, ByteBuffer dst) {
        ByteBuffer src = this.mBuffer.slice();
        src.limit(start + dst.remaining());
        src.position(start);
        dst.put(src);
    }

    @Override
    void write(int start, byte[] b, int off, int len) {
        ByteBuffer dst = this.mBuffer.slice();
        dst.position(start);
        dst.put(b, off, len);
    }

    @Override
    void write(int start, ByteBuffer src) {
        ByteBuffer dst = this.mBuffer.slice();
        dst.position(start);
        dst.put(src);
    }

    @Override
    void sync(boolean metadata) throws IOException {
        this.mBuffer.force();
        this.mChannel.force(metadata);
    }

    @Override
    public void close() throws IOException {
        Utils.delete(this.mBuffer);
        this.mRaf.close();
    }
}

