/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import org.cojen.tupl.io.FileFactory;
import org.cojen.tupl.io.FileIO;
import org.cojen.tupl.io.JavaFileIO;
import org.cojen.tupl.io.OpenOption;
import org.cojen.tupl.io.PageArray;
import org.cojen.tupl.io.Utils;

public class FilePageArray
extends PageArray {
    final FileIO mFio;

    public FilePageArray(int pageSize, File file, EnumSet<OpenOption> options) throws IOException {
        this(pageSize, file, null, options);
    }

    public FilePageArray(int pageSize, File file, FileFactory factory, EnumSet<OpenOption> options) throws IOException {
        super(pageSize);
        if (factory != null && options.contains((Object)OpenOption.CREATE) && !options.contains((Object)OpenOption.NON_DURABLE) && !options.contains((Object)OpenOption.READ_ONLY)) {
            factory.createFile(file);
        }
        this.mFio = JavaFileIO.open(file, options);
    }

    @Override
    public boolean isReadOnly() {
        return this.mFio.isReadOnly();
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.mFio.length() == 0L;
    }

    @Override
    public long getPageCount() throws IOException {
        return this.mFio.length() / (long)this.mPageSize;
    }

    @Override
    public void setPageCount(long count) throws IOException {
        if (count < 0L) {
            throw new IllegalArgumentException(String.valueOf(count));
        }
        if (this.isReadOnly()) {
            return;
        }
        this.mFio.setLength(count * (long)this.mPageSize);
    }

    @Override
    public void readPage(long index, byte[] dst, int offset, int length) throws IOException {
        if (index < 0L) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        this.mFio.read(index * (long)this.mPageSize, dst, offset, length);
    }

    @Override
    public void readPage(long index, long dstPtr, int offset, int length) throws IOException {
        if (index < 0L) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        this.mFio.read(index * (long)this.mPageSize, dstPtr, offset, length);
    }

    @Override
    public void writePage(long index, byte[] src, int offset) throws IOException {
        int pageSize = this.mPageSize;
        this.mFio.write(index * (long)pageSize, src, offset, pageSize);
    }

    @Override
    public void writePage(long index, long srcPtr, int offset) throws IOException {
        int pageSize = this.mPageSize;
        this.mFio.write(index * (long)pageSize, srcPtr, offset, pageSize);
    }

    @Override
    public void sync(boolean metadata) throws IOException {
        this.mFio.sync(metadata);
        this.mFio.remap();
    }

    @Override
    public void close(Throwable cause) throws IOException {
        Utils.close(this.mFio, cause);
    }
}

