/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.EnumSet;
import org.cojen.tupl.io.CauseCloseable;
import org.cojen.tupl.io.DirectAccess;
import org.cojen.tupl.io.JavaFileIO;
import org.cojen.tupl.io.OpenOption;
import org.cojen.tupl.io.PosixFileIO;

public abstract class FileIO
implements CauseCloseable {
    private static final String USE_JNA;
    private static final int IO_TYPE;
    private static final boolean NEEDS_DIR_SYNC;

    public static FileIO open(File file, EnumSet<OpenOption> options) throws IOException {
        return FileIO.open(file, options, 32);
    }

    public static FileIO open(File file, EnumSet<OpenOption> options, int openFileCount) throws IOException {
        if (options == null) {
            options = EnumSet.noneOf(OpenOption.class);
        }
        if (IO_TYPE == 1 && (!options.contains((Object)OpenOption.MAPPED) || DirectAccess.isSupported())) {
            return new PosixFileIO(file, options);
        }
        return new JavaFileIO(file, options, openFileCount);
    }

    public abstract boolean isReadOnly();

    public abstract long length() throws IOException;

    public abstract void setLength(long var1) throws IOException;

    public abstract void read(long var1, byte[] var3, int var4, int var5) throws IOException;

    public void read(long pos, long ptr, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract void write(long var1, byte[] var3, int var4, int var5) throws IOException;

    public void write(long pos, long ptr, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract void map() throws IOException;

    public abstract void remap() throws IOException;

    public abstract void unmap() throws IOException;

    public abstract void sync(boolean var1) throws IOException;

    public static void dirSync(File file) throws IOException {
        if (!NEEDS_DIR_SYNC) {
            return;
        }
        while (!file.isDirectory()) {
            if ((file = file.getParentFile()) != null) continue;
            return;
        }
        if (IO_TYPE == 1) {
            int fd = PosixFileIO.openFd(file, EnumSet.of(OpenOption.READ_ONLY));
            try {
                PosixFileIO.fsyncFd(fd);
            }
            finally {
                PosixFileIO.closeFd(fd);
            }
        }
        try (FileChannel fc = FileChannel.open(file.toPath(), StandardOpenOption.READ);){
            fc.force(true);
        }
    }

    static {
        int type;
        block4: {
            USE_JNA = FileIO.class.getName() + ".useJNA";
            type = 0;
            String jnaProp = System.getProperty(USE_JNA, null);
            if (jnaProp == null || Boolean.parseBoolean(jnaProp)) {
                try {
                    if (Native.SIZE_T_SIZE >= 8 && !Platform.isWindows()) {
                        type = 1;
                    }
                }
                catch (Throwable e) {
                    if (jnaProp == null) break block4;
                    throw e;
                }
            }
        }
        IO_TYPE = type;
        NEEDS_DIR_SYNC = !System.getProperty("os.name").startsWith("Windows");
    }
}

