/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import org.cojen.tupl.io.FileFactory;

public class AttributedFileFactory
implements FileFactory {
    private final FileAttribute<?>[] mFileAttrs;
    private final FileAttribute<?>[] mDirAttrs;

    public AttributedFileFactory(String posixFilePerms, String posixDirPerms) {
        this.mFileAttrs = AttributedFileFactory.toAttrs(posixFilePerms);
        this.mDirAttrs = AttributedFileFactory.toAttrs(posixDirPerms);
    }

    public AttributedFileFactory(FileAttribute<?>[] fileAttrs, FileAttribute<?>[] dirAttrs) {
        this.mFileAttrs = AttributedFileFactory.copy(fileAttrs);
        this.mDirAttrs = AttributedFileFactory.copy(dirAttrs);
    }

    @Override
    public boolean createFile(File file) throws IOException {
        if (this.mFileAttrs == null) {
            return file.createNewFile();
        }
        try {
            Files.createFile(file.toPath(), this.mFileAttrs);
            return true;
        }
        catch (FileAlreadyExistsException e) {
            return false;
        }
    }

    @Override
    public boolean createDirectory(File dir) throws IOException {
        if (this.mDirAttrs == null) {
            return dir.mkdir();
        }
        try {
            Files.createDirectory(dir.toPath(), this.mDirAttrs);
            return true;
        }
        catch (FileAlreadyExistsException e) {
            return false;
        }
    }

    @Override
    public boolean createDirectories(File dir) throws IOException {
        if (this.mDirAttrs == null) {
            return dir.mkdirs();
        }
        try {
            Files.createDirectories(dir.toPath(), this.mDirAttrs);
            return true;
        }
        catch (FileAlreadyExistsException e) {
            return false;
        }
    }

    private static FileAttribute<Set<PosixFilePermission>>[] toAttrs(String posixPerms) {
        if (posixPerms == null) {
            return null;
        }
        return new FileAttribute[]{PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(posixPerms))};
    }

    private static FileAttribute<?>[] copy(FileAttribute<?>[] attrs) {
        return attrs == null || attrs.length == 0 ? null : (FileAttribute[])attrs.clone();
    }
}

