/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import java.util.ArrayDeque;
import org.cojen.tupl.ClosedIndexException;
import org.cojen.tupl.CommitLock;
import org.cojen.tupl.CorruptDatabaseException;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.DirectPageOps;
import org.cojen.tupl.Index;
import org.cojen.tupl.LHashTable;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Utils;
import org.cojen.tupl._DatabaseAccess;
import org.cojen.tupl._LocalDatabase;
import org.cojen.tupl._LocalTransaction;
import org.cojen.tupl._Lock;
import org.cojen.tupl._LockManager;
import org.cojen.tupl._Node;
import org.cojen.tupl._Tree;
import org.cojen.tupl._TreeCursor;
import org.cojen.tupl.ext.TransactionHandler;

final class _UndoLog
implements _DatabaseAccess {
    _UndoLog mPrev;
    _UndoLog mNext;
    static final int I_LOWER_NODE_ID = 4;
    private static final int HEADER_SIZE = 12;
    private static final int INITIAL_BUFFER_SIZE = 128;
    private static final byte OP_SCOPE_ENTER = 1;
    private static final byte OP_SCOPE_COMMIT = 2;
    static final byte OP_COMMIT = 4;
    static final byte OP_COMMIT_TRUNCATE = 5;
    private static final byte PAYLOAD_OP = 16;
    private static final byte OP_LOG_COPY = 16;
    private static final byte OP_LOG_REF = 17;
    private static final byte OP_INDEX = 18;
    static final byte OP_UNINSERT = 19;
    static final byte OP_UNUPDATE = 20;
    static final byte OP_UNDELETE = 21;
    static final byte OP_UNDELETE_FRAGMENTED = 22;
    static final byte OP_CUSTOM = 24;
    private final _LocalDatabase mDatabase;
    private final long mTxnId;
    private long mLength;
    private byte[] mBuffer;
    private int mBufferPos;
    private _Node mNode;
    private long mActiveIndexId;

    _UndoLog(_LocalDatabase db, long txnId) {
        this.mDatabase = db;
        this.mTxnId = txnId;
    }

    @Override
    public _LocalDatabase getDatabase() {
        return this.mDatabase;
    }

    private void persistReady() throws IOException {
        if (this.mNode != null) {
            return;
        }
        byte[] buffer = this.mBuffer;
        if (buffer == null) {
            _Node node;
            this.mNode = node = this.allocUnevictableNode(0L);
            node.undoTop(this.pageSize(node.mPage));
            node.releaseExclusive();
        } else {
            _Node node;
            this.mNode = node = this.allocUnevictableNode(0L);
            int pos = this.mBufferPos;
            int size = buffer.length - pos;
            long page = node.mPage;
            int newPos = this.pageSize(page) - size;
            DirectPageOps.p_copyFromArray(buffer, pos, page, newPos, size);
            node.undoTop(newPos);
            this.mBuffer = null;
            this.mBufferPos = 0;
            node.releaseExclusive();
        }
    }

    private int pageSize(long page) {
        return this.mDatabase.pageSize();
    }

    long txnId() {
        return this.mTxnId;
    }

    long topNodeId() throws IOException {
        if (this.mNode == null) {
            if (this.mLength == 0L) {
                return 0L;
            }
            this.persistReady();
        }
        return this.mNode.mId;
    }

    void delete() {
        _Node node = this.mNode;
        if (node != null) {
            this.mNode = null;
            node.delete(this.mDatabase);
        }
    }

    final void push(long indexId, byte op, byte[] payload) throws IOException {
        this.push(indexId, op, payload, 0, payload.length);
    }

    final void push(long indexId, byte op, byte[] payload, int off, int len) throws IOException {
        long activeIndexId = this.mActiveIndexId;
        if (indexId != activeIndexId) {
            if (activeIndexId != 0L) {
                this.pushIndexId(activeIndexId);
            }
            this.mActiveIndexId = indexId;
        }
        this.doPush(op, payload, off, len, Utils.calcUnsignedVarIntLength(len));
    }

    final void push(long indexId, byte op, long payloadPtr, int off, int len) throws IOException {
        byte[] temp = new byte[len];
        DirectPageOps.p_copyToArray(payloadPtr, off, temp, 0, len);
        this.push(indexId, op, temp, 0, len);
    }

    private void pushIndexId(long indexId) throws IOException {
        byte[] payload = new byte[8];
        Utils.encodeLongLE(payload, 0, indexId);
        this.doPush((byte)18, payload, 0, 8, 1);
    }

    void pushCommit() throws IOException {
        this.doPush((byte)4);
    }

    void pushCustom(byte[] message) throws IOException {
        int len = message.length;
        this.doPush((byte)24, message, 0, len, Utils.calcUnsignedVarIntLength(len));
    }

    private void doPush(byte op) throws IOException {
        this.doPush(op, Utils.EMPTY_BYTES, 0, 0, 0);
    }

    /*
     * Unable to fully structure code
     */
    private void doPush(byte op, byte[] payload, int off, int len, int varIntLen) throws IOException {
        block10: {
            block11: {
                block12: {
                    block9: {
                        encodedLen = 1 + varIntLen + len;
                        node = this.mNode;
                        if (node == null) break block9;
                        node.acquireExclusive();
                        this.mDatabase.markUndoLogDirty(node);
                        break block10;
                    }
                    buffer = this.mBuffer;
                    if (buffer != null) break block11;
                    newCap = Math.max(128, Utils.roundUpPower2(encodedLen));
                    if (newCap > (pageSize = this.mDatabase.pageSize()) >> 1) break block12;
                    this.mBuffer = buffer = new byte[newCap];
                    this.mBufferPos = pos = newCap;
                    ** GOTO lbl39
                }
                this.mNode = node = this.allocUnevictableNode(0L);
                node.undoTop(pageSize);
                break block10;
            }
            pos = this.mBufferPos;
            if (pos >= encodedLen) ** GOTO lbl39
            size = buffer.length - pos;
            newCap = Math.max(buffer.length << 1, Utils.roundUpPower2(encodedLen + size));
            if (newCap > this.mDatabase.pageSize() >> 1) {
                this.mNode = node = this.allocUnevictableNode(0L);
                page = node.mPage;
                newPos = this.pageSize(page) - size;
                DirectPageOps.p_copyFromArray(buffer, pos, page, newPos, size);
                node.undoTop(newPos);
                this.mBuffer = null;
                this.mBufferPos = 0;
            } else {
                newBuf = new byte[newCap];
                newPos = newCap - size;
                System.arraycopy(buffer, pos, newBuf, newPos, size);
                buffer = newBuf;
                this.mBuffer = newBuf;
                this.mBufferPos = pos = newPos;
lbl39:
                // 3 sources

                _UndoLog.writeBufferEntry(buffer, pos -= encodedLen, op, payload, off, len);
                this.mBufferPos = pos;
                this.mLength += (long)encodedLen;
                return;
            }
        }
        pos = node.undoTop();
        available = pos - 12;
        if (available >= encodedLen) {
            _UndoLog.writePageEntry(node.mPage, pos -= encodedLen, op, payload, off, len);
            node.undoTop(pos);
            node.releaseExclusive();
            this.mLength += (long)encodedLen;
            return;
        }
        originalPos = node.undoTop();
        remaining = len;
        while (true) {
            amt = Math.min(available, remaining);
            page = node.mPage;
            DirectPageOps.p_copyFromArray(payload, off + (remaining -= amt), page, pos -= amt, amt);
            node.undoTop(pos);
            if (remaining <= 0 && (available -= amt) >= 1 + varIntLen) {
                if (varIntLen > 0) {
                    DirectPageOps.p_uintPutVar(page, pos -= varIntLen, len);
                }
                break;
            }
            try {
                newNode = this.allocUnevictableNode(node.mId);
            }
            catch (Throwable e) {
                while (node != this.mNode) {
                    node = this.popNode(node, true);
                }
                node.undoTop(originalPos);
                node.releaseExclusive();
                throw e;
            }
            pos = this.pageSize(page);
            newNode.undoTop(pos);
            available = pos - 12;
            this.mDatabase.nodeMapPut(node);
            node.releaseExclusive();
            node.makeEvictable();
            node = newNode;
        }
        DirectPageOps.p_bytePut(page, --pos, op);
        node.undoTop(pos);
        node.releaseExclusive();
        this.mNode = node;
        this.mLength += (long)encodedLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long scopeEnter() throws IOException {
        CommitLock commitLock = this.mDatabase.commitLock();
        commitLock.acquireShared();
        try {
            long savepoint = this.mLength;
            this.doPush((byte)1);
            long l = savepoint;
            return l;
        }
        finally {
            commitLock.releaseShared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long scopeCommit() throws IOException {
        CommitLock commitLock = this.mDatabase.commitLock();
        commitLock.acquireShared();
        try {
            this.doPush((byte)2);
            long l = this.mLength;
            return l;
        }
        finally {
            commitLock.releaseShared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void scopeRollback(long savepoint) throws IOException {
        CommitLock commitLock = this.mDatabase.commitLock();
        commitLock.acquireShared();
        try {
            if (savepoint < this.mLength) {
                this.doRollback(savepoint);
            }
        }
        finally {
            commitLock.releaseShared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void truncate(boolean commit) throws IOException {
        CommitLock commitLock = this.mDatabase.commitLock();
        commitLock.acquireShared();
        try {
            if (this.mLength > 0L) {
                _Node node = this.mNode;
                if (node == null) {
                    this.mBufferPos = this.mBuffer.length;
                } else {
                    node.acquireExclusive();
                    while ((node = this.popNode(node, true)) != null) {
                        if (commit) {
                            this.mDatabase.prepareToDelete(node);
                            this.mDatabase.redirty(node);
                            long page = node.mPage;
                            int end = this.pageSize(page) - 1;
                            node.undoTop(end);
                            DirectPageOps.p_bytePut(page, end, (byte)5);
                        }
                        commitLock.releaseShared();
                        commitLock.acquireShared();
                    }
                }
                this.mLength = 0L;
                this.mActiveIndexId = 0L;
            }
        }
        finally {
            commitLock.releaseShared();
        }
    }

    final void rollback() throws IOException {
        if (this.mLength == 0L) {
            return;
        }
        CommitLock commitLock = this.mDatabase.commitLock();
        commitLock.acquireShared();
        try {
            this.doRollback(0L);
        }
        finally {
            commitLock.releaseShared();
        }
    }

    private void doRollback(long savepoint) throws IOException {
        byte[] entry;
        byte[] opRef = new byte[1];
        Index activeIndex = null;
        while ((entry = this.pop(opRef, true)) != null) {
            byte op = opRef[0];
            activeIndex = this.undo(activeIndex, op, entry);
            if (savepoint < this.mLength) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void deleteGhosts() throws IOException {
        byte[] entry;
        if (this.mLength <= 0L) {
            return;
        }
        byte[] opRef = new byte[1];
        Index activeIndex = null;
        while ((entry = this.pop(opRef, true)) != null) {
            byte op = opRef[0];
            block2 : switch (op) {
                default: {
                    throw new DatabaseException("Unknown undo log entry type: " + op);
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 19: 
                case 20: 
                case 24: {
                    break;
                }
                case 18: {
                    this.mActiveIndexId = Utils.decodeLongLE(entry, 0);
                    activeIndex = null;
                    break;
                }
                case 21: 
                case 22: {
                    while ((activeIndex = this.findIndex(activeIndex)) != null) {
                        byte[] key;
                        long pentry = DirectPageOps.p_transfer(entry);
                        try {
                            key = _Node.retrieveKeyAtLoc(this, pentry, 0);
                        }
                        finally {
                            DirectPageOps.p_delete(pentry);
                        }
                        _TreeCursor cursor = new _TreeCursor((_Tree)activeIndex, null);
                        try {
                            cursor.deleteGhost(key);
                            break block2;
                        }
                        catch (ClosedIndexException e) {
                            activeIndex = null;
                        }
                        catch (Throwable e) {
                            throw Utils.closeOnFailure(cursor, e);
                        }
                    }
                    break block2;
                }
            }
            if (this.mLength > 0L) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Index undo(Index activeIndex, byte op, byte[] entry) throws IOException {
        block4 : switch (op) {
            default: {
                throw new DatabaseException("Unknown undo log entry type: " + op);
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 18: {
                this.mActiveIndexId = Utils.decodeLongLE(entry, 0);
                activeIndex = null;
                break;
            }
            case 19: {
                while ((activeIndex = this.findIndex(activeIndex)) != null) {
                    try {
                        activeIndex.delete(Transaction.BOGUS, entry);
                        break block4;
                    }
                    catch (ClosedIndexException e) {
                        activeIndex = null;
                    }
                }
                break;
            }
            case 20: 
            case 21: {
                byte[][] pair;
                long pentry = DirectPageOps.p_transfer(entry);
                try {
                    pair = _Node.retrieveKeyValueAtLoc(this, pentry, 0);
                }
                finally {
                    DirectPageOps.p_delete(pentry);
                }
                while ((activeIndex = this.findIndex(activeIndex)) != null) {
                    try {
                        activeIndex.store(Transaction.BOGUS, pair[0], pair[1]);
                        break block4;
                    }
                    catch (ClosedIndexException e) {
                        activeIndex = null;
                    }
                }
                break;
            }
            case 22: {
                while ((activeIndex = this.findIndex(activeIndex)) != null) {
                    try {
                        this.mDatabase.fragmentedTrash().remove(this.mTxnId, (_Tree)activeIndex, entry);
                        break block4;
                    }
                    catch (ClosedIndexException e) {
                        activeIndex = null;
                    }
                }
                break;
            }
            case 24: {
                _LocalDatabase db = this.mDatabase;
                TransactionHandler handler = db.mCustomTxnHandler;
                if (handler == null) {
                    throw new DatabaseException("Custom transaction handler is not installed");
                }
                handler.undo(db, entry);
            }
        }
        return activeIndex;
    }

    private Index findIndex(Index activeIndex) throws IOException {
        if (activeIndex == null || activeIndex.isClosed()) {
            activeIndex = this.mDatabase.anyIndexById(this.mActiveIndexId);
        }
        return activeIndex;
    }

    final byte peek(boolean delete) throws IOException {
        _Node node = this.mNode;
        if (node == null) {
            return this.mBuffer == null || this.mBufferPos >= this.mBuffer.length ? (byte)0 : this.mBuffer[this.mBufferPos];
        }
        node.acquireExclusive();
        do {
            long page = node.mPage;
            int pos = node.undoTop();
            if (pos >= this.pageSize(page)) continue;
            byte op = DirectPageOps.p_byteGet(page, pos);
            node.releaseExclusive();
            return op;
        } while ((node = this.popNode(node, delete)) != null);
        return 0;
    }

    private final byte[] pop(byte[] opRef, boolean delete) throws IOException {
        int pos;
        long page;
        _Node node;
        block13: {
            node = this.mNode;
            if (node == null) {
                byte[] buffer = this.mBuffer;
                if (buffer == null) {
                    opRef[0] = 0;
                    this.mLength = 0L;
                    return null;
                }
                int pos2 = this.mBufferPos;
                if (pos2 >= buffer.length) {
                    opRef[0] = 0;
                    this.mLength = 0L;
                    return null;
                }
                if ((opRef[0] = buffer[pos2++]) < 16) {
                    this.mBufferPos = pos2;
                    --this.mLength;
                    return Utils.EMPTY_BYTES;
                }
                int payloadLen = Utils.decodeUnsignedVarInt(buffer, pos2);
                int varIntLen = Utils.calcUnsignedVarIntLength(payloadLen);
                byte[] entry = new byte[payloadLen];
                System.arraycopy(buffer, pos2 += varIntLen, entry, 0, payloadLen);
                this.mBufferPos = pos2 += payloadLen;
                this.mLength -= (long)(1 + varIntLen + payloadLen);
                return entry;
            }
            node.acquireExclusive();
            do {
                page = node.mPage;
                pos = node.undoTop();
                if (pos < this.pageSize(page)) break block13;
            } while ((node = this.popNode(node, delete)) != null);
            this.mLength = 0L;
            return null;
        }
        if ((opRef[0] = DirectPageOps.p_byteGet(page, pos++)) < 16) {
            --this.mLength;
            node.undoTop(pos);
            if (pos >= this.pageSize(page)) {
                node = this.popNode(node, delete);
            }
            if (node != null) {
                node.releaseExclusive();
            }
            return Utils.EMPTY_BYTES;
        }
        int payloadLen = DirectPageOps.p_uintGetVar(page, pos);
        int varIntLen = DirectPageOps.p_uintVarSize(payloadLen);
        pos += varIntLen;
        this.mLength -= (long)(1 + varIntLen + payloadLen);
        byte[] entry = new byte[payloadLen];
        int entryPos = 0;
        while (true) {
            int avail = Math.min(payloadLen, this.pageSize(page) - pos);
            DirectPageOps.p_copyToArray(page, pos, entry, entryPos, avail);
            payloadLen -= avail;
            node.undoTop(pos += avail);
            if (pos >= this.pageSize(page)) {
                node = this.popNode(node, delete);
            }
            if (payloadLen <= 0) {
                if (node != null) {
                    node.releaseExclusive();
                }
                return entry;
            }
            if (node == null) {
                throw new CorruptDatabaseException("Remainder of undo log is missing");
            }
            page = node.mPage;
            pos = node.undoTop();
            entryPos += avail;
        }
    }

    private _Node popNode(_Node parent, boolean delete) throws IOException {
        _Node lowerNode = null;
        long lowerNodeId = DirectPageOps.p_longGetLE(parent.mPage, 4);
        if (lowerNodeId != 0L) {
            lowerNode = this.mDatabase.nodeMapGetAndRemove(lowerNodeId);
            if (lowerNode != null) {
                lowerNode.makeUnevictable();
            } else {
                lowerNode = _UndoLog.readUndoLogNode(this.mDatabase, lowerNodeId);
            }
        }
        parent.makeEvictable();
        if (delete) {
            _LocalDatabase db = this.mDatabase;
            db.prepareToDelete(parent);
            db.deleteNode(parent, false);
        } else {
            parent.releaseExclusive();
        }
        this.mNode = lowerNode;
        return this.mNode;
    }

    private static void writeBufferEntry(byte[] dest, int destPos, byte op, byte[] payload, int off, int len) {
        dest[destPos] = op;
        if (op >= 16) {
            int payloadPos = Utils.encodeUnsignedVarInt(dest, destPos + 1, len);
            System.arraycopy(payload, off, dest, payloadPos, len);
        }
    }

    private static void writePageEntry(long page, int pagePos, byte op, byte[] payload, int off, int len) {
        DirectPageOps.p_bytePut(page, pagePos, op);
        if (op >= 16) {
            int payloadPos = DirectPageOps.p_uintPutVar(page, pagePos + 1, len);
            DirectPageOps.p_copyFromArray(payload, off, page, payloadPos, len);
        }
    }

    private _Node allocUnevictableNode(long lowerNodeId) throws IOException {
        _Node node = this.mDatabase.allocDirtyNode(1);
        node.type((byte)64);
        DirectPageOps.p_longPutLE(node.mPage, 4, lowerNodeId);
        return node;
    }

    final byte[] writeToMaster(_UndoLog master, byte[] workspace) throws IOException {
        _Node node = this.mNode;
        if (node == null) {
            byte[] buffer = this.mBuffer;
            if (buffer == null) {
                return workspace;
            }
            int pos = this.mBufferPos;
            int bsize = buffer.length - pos;
            if (bsize == 0) {
                return workspace;
            }
            int psize = 18 + bsize;
            if (workspace == null || workspace.length < psize) {
                workspace = new byte[Math.max(128, Utils.roundUpPower2(psize))];
            }
            this.writeHeaderToMaster(workspace);
            Utils.encodeShortLE(workspace, 16, bsize);
            System.arraycopy(buffer, pos, workspace, 18, bsize);
            master.doPush((byte)16, workspace, 0, psize, Utils.calcUnsignedVarIntLength(psize));
        } else {
            if (workspace == null) {
                workspace = new byte[128];
            }
            this.writeHeaderToMaster(workspace);
            Utils.encodeLongLE(workspace, 16, this.mLength);
            Utils.encodeLongLE(workspace, 24, node.mId);
            Utils.encodeShortLE(workspace, 32, node.undoTop());
            master.doPush((byte)17, workspace, 0, 34, 1);
        }
        return workspace;
    }

    private void writeHeaderToMaster(byte[] workspace) {
        Utils.encodeLongLE(workspace, 0, this.mTxnId);
        Utils.encodeLongLE(workspace, 8, this.mActiveIndexId);
    }

    static _UndoLog recoverMasterUndoLog(_LocalDatabase db, long nodeId) throws IOException {
        _UndoLog log = new _UndoLog(db, 0L);
        log.mLength = Long.MAX_VALUE;
        log.mNode = _UndoLog.readUndoLogNode(db, nodeId);
        log.mNode.releaseExclusive();
        return log;
    }

    void recoverTransactions(LHashTable.Obj<_LocalTransaction> txns, LockMode lockMode, long timeoutNanos) throws IOException {
        byte[] entry;
        byte[] opRef = new byte[1];
        while ((entry = this.pop(opRef, true)) != null) {
            _UndoLog log = this.recoverUndoLog(opRef[0], entry);
            _LocalTransaction txn = log.recoverTransaction(lockMode, timeoutNanos);
            txn.recoveredUndoLog(this.recoverUndoLog(opRef[0], entry));
            ((LHashTable.ObjEntry)txns.insert((long)log.mTxnId)).value = txn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final _LocalTransaction recoverTransaction(LockMode lockMode, long timeoutNanos) throws IOException {
        byte[] entry;
        byte[] opRef = new byte[1];
        Scope scope = new Scope();
        ArrayDeque<Scope> scopes = new ArrayDeque<Scope>();
        scopes.addFirst(scope);
        boolean acquireLocks = true;
        int depth = 1;
        while (this.mLength > 0L && (entry = this.pop(opRef, false)) != null) {
            byte op = opRef[0];
            switch (op) {
                default: {
                    throw new DatabaseException("Unknown undo log entry type: " + op);
                }
                case 4: 
                case 5: {
                    acquireLocks = false;
                    break;
                }
                case 1: {
                    if (++depth <= scopes.size()) break;
                    scope.mSavepoint = this.mLength;
                    scope = new Scope();
                    scopes.addFirst(scope);
                    break;
                }
                case 2: {
                    --depth;
                    break;
                }
                case 18: {
                    this.mActiveIndexId = Utils.decodeLongLE(entry, 0);
                    break;
                }
                case 19: {
                    if (lockMode == LockMode.UNSAFE) break;
                    scope.addLock(this.mActiveIndexId, entry);
                    break;
                }
                case 20: 
                case 21: 
                case 22: {
                    if (lockMode == LockMode.UNSAFE) break;
                    long pentry = DirectPageOps.p_transfer(entry);
                    try {
                        byte[] key = _Node.retrieveKeyAtLoc(this, pentry, 0);
                    }
                    finally {
                        DirectPageOps.p_delete(pentry);
                    }
                    scope.addLock((long)this.mActiveIndexId, (byte[])key).mSharedLockOwnersObj = this.mDatabase.anyIndexById(this.mActiveIndexId);
                }
                case 24: 
            }
        }
        _LocalTransaction txn = new _LocalTransaction(this.mDatabase, this.mTxnId, lockMode, timeoutNanos, 4);
        scope = (Scope)scopes.pollFirst();
        if (acquireLocks) {
            scope.acquireLocks(txn);
        }
        while ((scope = (Scope)scopes.pollFirst()) != null) {
            txn.recoveredScope(scope.mSavepoint, 4);
            if (!acquireLocks) continue;
            scope.acquireLocks(txn);
        }
        return txn;
    }

    private _UndoLog recoverUndoLog(byte masterLogOp, byte[] masterLogEntry) throws IOException {
        if (masterLogOp != 16 && masterLogOp != 17) {
            throw new DatabaseException("Unknown undo log entry type: " + masterLogOp);
        }
        long txnId = Utils.decodeLongLE(masterLogEntry, 0);
        _UndoLog log = new _UndoLog(this.mDatabase, txnId);
        log.mActiveIndexId = Utils.decodeLongLE(masterLogEntry, 8);
        if (masterLogOp == 16) {
            int bsize = Utils.decodeUnsignedShortLE(masterLogEntry, 16);
            log.mLength = bsize;
            byte[] buffer = new byte[bsize];
            System.arraycopy(masterLogEntry, 18, buffer, 0, bsize);
            log.mBuffer = buffer;
            log.mBufferPos = 0;
        } else {
            log.mLength = Utils.decodeLongLE(masterLogEntry, 16);
            long nodeId = Utils.decodeLongLE(masterLogEntry, 24);
            int topEntry = Utils.decodeUnsignedShortLE(masterLogEntry, 32);
            log.mNode = _UndoLog.readUndoLogNode(this.mDatabase, nodeId);
            log.mNode.undoTop(topEntry);
            log.mNode.releaseExclusive();
        }
        return log;
    }

    private static _Node readUndoLogNode(_LocalDatabase db, long nodeId) throws IOException {
        _Node node = db.allocLatchedNode(nodeId, 1);
        node.read(db, nodeId);
        if (node.type() != 64) {
            throw new CorruptDatabaseException("Not an undo log node type: " + node.type() + ", id: " + nodeId);
        }
        return node;
    }

    static class Scope {
        long mSavepoint;
        _Lock mTopLock;

        Scope() {
        }

        _Lock addLock(long indexId, byte[] key) {
            _Lock lock = new _Lock();
            lock.mIndexId = indexId;
            lock.mKey = key;
            lock.mHashCode = _LockManager.hash(indexId, key);
            lock.mLockManagerNext = this.mTopLock;
            this.mTopLock = lock;
            return lock;
        }

        void acquireLocks(_LocalTransaction txn) throws LockFailureException {
            _Lock lock = this.mTopLock;
            if (lock != null) {
                while (true) {
                    _Lock next = lock.mLockManagerNext;
                    txn.lockExclusive(lock);
                    if (next == null) break;
                    this.mTopLock = lock = next;
                }
            }
        }
    }
}

