/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import org.cojen.tupl.Utils;
import org.cojen.tupl._CursorFrame;
import org.cojen.tupl._Node;

final class _Split {
    final boolean mSplitRight;
    private final _Node mSibling;
    private byte[] mFullKey;
    private byte[] mActualKey;

    _Split(boolean splitRight, _Node sibling) {
        this.mSplitRight = splitRight;
        this.mSibling = sibling;
    }

    final void setKey(_Split split) {
        this.mFullKey = split.mFullKey;
        this.mActualKey = split.mActualKey;
    }

    final void setKey(byte[] fullKey, byte[] actualKey) {
        this.mFullKey = fullKey;
        this.mActualKey = actualKey;
    }

    final byte[] fragmentedKey() {
        return this.mFullKey == this.mActualKey ? null : this.mActualKey;
    }

    final int compare(byte[] key) {
        return Utils.compareUnsigned(key, 0, key.length, this.mFullKey, 0, this.mFullKey.length);
    }

    final _Node selectNode(_Node node, byte[] key) {
        _Node right;
        _Node left;
        _Node sibling = this.mSibling;
        sibling.acquireShared();
        if (this.mSplitRight) {
            left = node;
            right = sibling;
        } else {
            left = sibling;
            right = node;
        }
        if (this.compare(key) < 0) {
            right.releaseShared();
            return left;
        }
        left.releaseShared();
        return right;
    }

    final int binarySearchLeaf(_Node node, byte[] key) throws IOException {
        int searchPos;
        _Node right;
        _Node left;
        _Node sibling = this.latchSibling();
        if (this.mSplitRight) {
            left = node;
            right = sibling;
        } else {
            left = sibling;
            right = node;
        }
        if (this.compare(key) < 0) {
            searchPos = left.binarySearch(key);
        } else {
            int highestPos = left.highestLeafPos();
            searchPos = right.binarySearch(key);
            searchPos = searchPos < 0 ? searchPos - highestPos - 2 : highestPos + 2 + searchPos;
        }
        sibling.releaseShared();
        return searchPos;
    }

    final int highestPos(_Node node) {
        _Node sibling = this.latchSibling();
        int pos = node.isLeaf() ? node.highestLeafPos() + 2 + sibling.highestLeafPos() : node.highestInternalPos() + 2 + sibling.highestInternalPos();
        sibling.releaseShared();
        return pos;
    }

    final _Node latchSibling() {
        _Node sibling = this.mSibling;
        sibling.acquireShared();
        return sibling;
    }

    final _Node latchSiblingEx() {
        _Node sibling = this.mSibling;
        sibling.acquireExclusive();
        return sibling;
    }

    final void rebindFrame(_CursorFrame frame, _Node sibling) {
        int pos = frame.mNodePos;
        if (this.mSplitRight) {
            byte[] key;
            _Node frameNode = frame.mNode;
            if (frameNode == null) {
                return;
            }
            int highestPos = frameNode.highestPos();
            if (pos >= 0) {
                if (pos > highestPos) {
                    frame.rebind(sibling, pos - highestPos - 2);
                }
                return;
            }
            if ((pos ^= 0xFFFFFFFF) <= highestPos) {
                return;
            }
            if (pos == highestPos + 2 && ((key = frame.mNotFoundKey) == null || this.compare(key) < 0)) {
                return;
            }
            frame.rebind(sibling, ~(pos - highestPos - 2));
        } else {
            int highestPos = sibling.highestPos();
            if (pos >= 0) {
                if (pos <= highestPos) {
                    frame.rebind(sibling, pos);
                } else {
                    frame.mNodePos = pos - highestPos - 2;
                }
                return;
            }
            if ((pos ^= 0xFFFFFFFF) <= highestPos) {
                frame.rebind(sibling, ~pos);
                return;
            }
            if (pos == highestPos + 2) {
                byte[] key = frame.mNotFoundKey;
                if (key == null) {
                    return;
                }
                if (this.compare(key) < 0) {
                    frame.rebind(sibling, ~pos);
                    return;
                }
            }
            frame.mNodePos = ~(pos - highestPos - 2);
        }
    }

    final int splitKeyEncodedLength() {
        byte[] actualKey = this.mActualKey;
        if (actualKey == this.mFullKey) {
            return _Node.calculateKeyLength(actualKey);
        }
        return 2 + actualKey.length;
    }

    final int copySplitKeyToParent(long dest, int destLoc) {
        byte[] actualKey = this.mActualKey;
        if (actualKey == this.mFullKey) {
            return _Node.encodeNormalKey(actualKey, dest, destLoc);
        }
        return _Node.encodeFragmentedKey(actualKey, dest, destLoc);
    }
}

