/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import org.cojen.tupl._LocalDatabase;
import org.cojen.tupl._Lock;
import org.cojen.tupl._LockManager;
import org.cojen.tupl._LockOwner;
import org.cojen.tupl._UndoLog;

final class _PendingTxn
extends _LockOwner {
    private final _Lock mFirst;
    private _Lock[] mRest;
    private int mRestSize;
    long mTxnId;
    long mCommitPos;
    _UndoLog mUndoLog;
    boolean mHasFragmentedTrash;
    _PendingTxn mPrev;

    _PendingTxn(_Lock first) {
        this.mFirst = first;
    }

    void add(_Lock lock) {
        _Lock first = this.mFirst;
        if (first == null) {
            throw new IllegalStateException("cannot add lock");
        }
        _Lock[] rest = this.mRest;
        if (rest == null) {
            this.mRest = rest = new _Lock[8];
            this.mRestSize = 1;
            rest[0] = lock;
        } else {
            int size = this.mRestSize;
            if (size >= rest.length) {
                _Lock[] newRest = new _Lock[rest.length << 1];
                System.arraycopy(rest, 0, newRest, 0, rest.length);
                rest = newRest;
                this.mRest = newRest;
            }
            rest[size] = lock;
            this.mRestSize = size + 1;
        }
    }

    void commit(_LocalDatabase db) throws IOException {
        this.unlockAll(db);
        _UndoLog undo = this.mUndoLog;
        if (undo != null) {
            undo.truncate(true);
            db.unregister(undo);
        }
        if (this.mHasFragmentedTrash) {
            db.fragmentedTrash().emptyTrash(this.mTxnId);
        }
    }

    void rollback(_LocalDatabase db) throws IOException {
        _UndoLog undo = this.mUndoLog;
        if (undo != null) {
            undo.rollback();
        }
        this.unlockAll(db);
        if (undo != null) {
            db.unregister(undo);
        }
    }

    private void unlockAll(_LocalDatabase db) {
        _Lock first = this.mFirst;
        if (first != null) {
            _LockManager manager = db.mLockManager;
            manager.unlock(this, first);
            _Lock[] rest = this.mRest;
            if (rest != null) {
                for (_Lock lock : rest) {
                    if (lock == null) {
                        return;
                    }
                    manager.unlock(this, lock);
                }
            }
        }
    }
}

