/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.util.Arrays;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Utils;
import org.cojen.tupl._LockOwner;
import org.cojen.tupl._Locker;
import org.cojen.tupl._PendingTxn;
import org.cojen.tupl._Tree;
import org.cojen.tupl._TreeCursor;
import org.cojen.tupl.util.Latch;
import org.cojen.tupl.util.LatchCondition;

final class _Lock {
    long mIndexId;
    byte[] mKey;
    int mHashCode;
    _Lock mLockManagerNext;
    int mLockCount;
    _LockOwner mOwner;
    Object mSharedLockOwnersObj;
    LatchCondition mQueueU;
    LatchCondition mQueueSX;

    _Lock() {
    }

    boolean isAvailable(_LockOwner locker) {
        return this.mLockCount >= 0 || this.mOwner == locker;
    }

    LockResult check(_LockOwner locker) {
        int count = this.mLockCount;
        return this.mOwner == locker ? (count == -1 ? LockResult.OWNED_EXCLUSIVE : LockResult.OWNED_UPGRADABLE) : (count != 0 && this.isSharedLockOwner(locker) ? LockResult.OWNED_SHARED : LockResult.UNOWNED);
    }

    LockResult tryLockShared(Latch latch, _LockOwner locker, long nanosTimeout) {
        if (this.mOwner == locker) {
            return this.mLockCount == -1 ? LockResult.OWNED_EXCLUSIVE : LockResult.OWNED_UPGRADABLE;
        }
        LatchCondition queueSX = this.mQueueSX;
        if (queueSX != null) {
            if (nanosTimeout == 0L) {
                return LockResult.TIMED_OUT_LOCK;
            }
        } else {
            LockResult r = this.tryLockShared(locker);
            if (r != null) {
                return r;
            }
            if (nanosTimeout == 0L) {
                return LockResult.TIMED_OUT_LOCK;
            }
            this.mQueueSX = queueSX = new LatchCondition();
        }
        locker.mWaitingFor = this;
        long nanosEnd = nanosTimeout < 0L ? 0L : System.nanoTime() + nanosTimeout;
        while (true) {
            int w = queueSX.awaitShared(latch, nanosTimeout, nanosEnd);
            queueSX = this.mQueueSX;
            if (queueSX != null && !queueSX.signalNextShared()) {
                this.mQueueSX = null;
            }
            if (w < 1) {
                if (w == 0) {
                    return LockResult.TIMED_OUT_LOCK;
                }
                locker.mWaitingFor = null;
                return LockResult.INTERRUPTED;
            }
            if (this.mOwner == locker) {
                locker.mWaitingFor = null;
                return this.mLockCount == -1 ? LockResult.OWNED_EXCLUSIVE : LockResult.OWNED_UPGRADABLE;
            }
            LockResult r = this.tryLockShared(locker);
            if (r != null) {
                locker.mWaitingFor = null;
                return r;
            }
            if (nanosTimeout >= 0L && (nanosTimeout = nanosEnd - System.nanoTime()) <= 0L) {
                return LockResult.TIMED_OUT_LOCK;
            }
            if (this.mQueueSX != null) continue;
            this.mQueueSX = queueSX = new LatchCondition();
        }
    }

    LockResult tryLockUpgradable(Latch latch, _Locker locker, long nanosTimeout) {
        LatchCondition queueU;
        if (this.mOwner == locker) {
            return this.mLockCount == -1 ? LockResult.OWNED_EXCLUSIVE : LockResult.OWNED_UPGRADABLE;
        }
        int count = this.mLockCount;
        if (count != 0 && this.isSharedLockOwner(locker)) {
            if (!locker.canAttemptUpgrade(count)) {
                return LockResult.ILLEGAL;
            }
            if (count > 0) {
                this.mLockCount = count - 1 | Integer.MIN_VALUE;
                this.mOwner = locker;
                return LockResult.OWNED_UPGRADABLE;
            }
        }
        if ((queueU = this.mQueueU) != null) {
            if (nanosTimeout == 0L) {
                return LockResult.TIMED_OUT_LOCK;
            }
        } else {
            if (count >= 0) {
                this.mLockCount = count | Integer.MIN_VALUE;
                this.mOwner = locker;
                return LockResult.ACQUIRED;
            }
            if (nanosTimeout == 0L) {
                return LockResult.TIMED_OUT_LOCK;
            }
            this.mQueueU = queueU = new LatchCondition();
        }
        locker.mWaitingFor = this;
        long nanosEnd = nanosTimeout < 0L ? 0L : System.nanoTime() + nanosTimeout;
        while (true) {
            int w = queueU.await(latch, nanosTimeout, nanosEnd);
            queueU = this.mQueueU;
            if (queueU != null && queueU.isEmpty()) {
                this.mQueueU = null;
            }
            if (w < 1) {
                if (w == 0) {
                    return LockResult.TIMED_OUT_LOCK;
                }
                locker.mWaitingFor = null;
                return LockResult.INTERRUPTED;
            }
            if (this.mOwner == locker) {
                locker.mWaitingFor = null;
                return this.mLockCount == -1 ? LockResult.OWNED_EXCLUSIVE : LockResult.OWNED_UPGRADABLE;
            }
            count = this.mLockCount;
            if (count != 0 && this.isSharedLockOwner(locker)) {
                if (!locker.canAttemptUpgrade(count)) {
                    if (queueU != null) {
                        queueU.signal();
                    }
                    locker.mWaitingFor = null;
                    return LockResult.ILLEGAL;
                }
                if (count > 0) {
                    this.mLockCount = count - 1 | Integer.MIN_VALUE;
                    this.mOwner = locker;
                    return LockResult.OWNED_UPGRADABLE;
                }
            }
            if (count >= 0) {
                this.mLockCount = count | Integer.MIN_VALUE;
                this.mOwner = locker;
                locker.mWaitingFor = null;
                return LockResult.ACQUIRED;
            }
            if (nanosTimeout >= 0L && (nanosTimeout = nanosEnd - System.nanoTime()) <= 0L) {
                return LockResult.TIMED_OUT_LOCK;
            }
            if (this.mQueueU != null) continue;
            this.mQueueU = queueU = new LatchCondition();
        }
    }

    LockResult tryLockExclusive(Latch latch, _Locker locker, long nanosTimeout) {
        LockResult ur = this.tryLockUpgradable(latch, locker, nanosTimeout);
        if (!ur.isHeld() || ur == LockResult.OWNED_EXCLUSIVE) {
            return ur;
        }
        LatchCondition queueSX = this.mQueueSX;
        if (queueSX != null) {
            if (nanosTimeout == 0L) {
                if (ur == LockResult.ACQUIRED) {
                    this.unlockUpgradable();
                }
                return LockResult.TIMED_OUT_LOCK;
            }
        } else {
            if (this.mLockCount == Integer.MIN_VALUE) {
                this.mLockCount = -1;
                return ur == LockResult.OWNED_UPGRADABLE ? LockResult.UPGRADED : LockResult.ACQUIRED;
            }
            if (nanosTimeout == 0L) {
                if (ur == LockResult.ACQUIRED) {
                    this.unlockUpgradable();
                }
                return LockResult.TIMED_OUT_LOCK;
            }
            this.mQueueSX = queueSX = new LatchCondition();
        }
        locker.mWaitingFor = this;
        long nanosEnd = nanosTimeout < 0L ? 0L : System.nanoTime() + nanosTimeout;
        while (true) {
            block20: {
                block19: {
                    int count;
                    block18: {
                        int w = queueSX.await(latch, nanosTimeout, nanosEnd);
                        queueSX = this.mQueueSX;
                        if (queueSX != null && queueSX.isEmpty()) {
                            this.mQueueSX = null;
                        }
                        if (w < 1) {
                            if (ur == LockResult.ACQUIRED) {
                                this.unlockUpgradable();
                            }
                            if (w == 0) {
                                return LockResult.TIMED_OUT_LOCK;
                            }
                            locker.mWaitingFor = null;
                            return LockResult.INTERRUPTED;
                        }
                        count = this.mLockCount;
                        if (count != Integer.MIN_VALUE) break block18;
                        this.mLockCount = -1;
                        break block19;
                    }
                    if (count != -1) break block20;
                }
                locker.mWaitingFor = null;
                return ur == LockResult.OWNED_UPGRADABLE ? LockResult.UPGRADED : LockResult.ACQUIRED;
            }
            if (nanosTimeout >= 0L && (nanosTimeout = nanosEnd - System.nanoTime()) <= 0L) {
                return LockResult.TIMED_OUT_LOCK;
            }
            if (this.mQueueSX != null) continue;
            this.mQueueSX = queueSX = new LatchCondition();
        }
    }

    private void unlockUpgradable() {
        this.mOwner = null;
        LatchCondition queueU = this.mQueueU;
        if (queueU != null) {
            queueU.signal();
        }
        this.mLockCount &= Integer.MAX_VALUE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean unlock(_LockOwner locker, Latch latch) {
        if (this.mOwner == locker) {
            int count;
            this.deleteGhost(latch);
            this.mOwner = null;
            LatchCondition queueU = this.mQueueU;
            if (queueU != null) {
                queueU.signal();
            }
            if ((count = this.mLockCount) != -1) {
                this.mLockCount = count & Integer.MAX_VALUE;
                if (this.mLockCount != 0) return false;
                if (queueU != null) return false;
                if (this.mQueueSX != null) return false;
                return true;
            }
            this.mLockCount = 0;
            LatchCondition queueSX = this.mQueueSX;
            if (queueSX == null) {
                if (queueU != null) return false;
                return true;
            }
            queueSX.signal();
            return false;
        }
        int count = this.mLockCount;
        if ((count & Integer.MAX_VALUE) == 0) throw new IllegalStateException("_Lock not held");
        Object sharedObj = this.mSharedLockOwnersObj;
        if (sharedObj == locker) {
            this.mSharedLockOwnersObj = null;
        } else {
            if (!(sharedObj instanceof LockOwnerHTEntry[])) throw new IllegalStateException("_Lock not held");
            LockOwnerHTEntry[] entries = (LockOwnerHTEntry[])sharedObj;
            if (!_Lock.lockerHTremove(entries, locker)) throw new IllegalStateException("_Lock not held");
            if (count == 2) {
                this.mSharedLockOwnersObj = _Lock.lockerHTgetOne(entries);
            }
        }
        this.mLockCount = --count;
        LatchCondition queueSX = this.mQueueSX;
        if (count == Integer.MIN_VALUE) {
            if (queueSX == null) return false;
            queueSX.signal();
            return false;
        }
        if (count != 0) return false;
        if (queueSX != null) return false;
        if (this.mQueueU != null) return false;
        return true;
    }

    void unlockToShared(_LockOwner locker, Latch latch) {
        if (this.mOwner == locker) {
            int count;
            this.deleteGhost(latch);
            this.mOwner = null;
            LatchCondition queueU = this.mQueueU;
            if (queueU != null) {
                queueU.signal();
            }
            if ((count = this.mLockCount) != -1) {
                if ((count &= Integer.MAX_VALUE) >= 0x7FFFFFFE) {
                    throw new IllegalStateException("Too many shared locks held");
                }
                this.addSharedLockOwner(count, locker);
            } else {
                this.addSharedLockOwner(0, locker);
                LatchCondition queueSX = this.mQueueSX;
                if (queueSX != null) {
                    queueSX.signal();
                }
            }
        } else if (this.mLockCount == 0 || !this.isSharedLockOwner(locker)) {
            throw new IllegalStateException("_Lock not held");
        }
    }

    void unlockToUpgradable(_LockOwner locker, Latch latch) {
        if (this.mOwner != locker) {
            String message = "Exclusive or upgradable lock not held";
            if (this.mLockCount == 0 || !this.isSharedLockOwner(locker)) {
                message = "_Lock not held";
            }
            throw new IllegalStateException(message);
        }
        if (this.mLockCount != -1) {
            return;
        }
        this.deleteGhost(latch);
        this.mLockCount = Integer.MIN_VALUE;
        LatchCondition queueSX = this.mQueueSX;
        if (queueSX != null) {
            queueSX.signalShared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteGhost(Latch latch) {
        Object obj = this.mSharedLockOwnersObj;
        if (!(obj instanceof _Tree)) {
            return;
        }
        _Tree tree = (_Tree)obj;
        try {
            while (true) {
                _TreeCursor c = new _TreeCursor(tree, null);
                c.autoload(false);
                byte[] key = this.mKey;
                this.mSharedLockOwnersObj = null;
                latch.releaseExclusive();
                try {
                    if (!c.deleteGhost(key) && (tree = (_Tree)tree.mDatabase.indexById(tree.mId)) != null) continue;
                }
                finally {
                    latch.acquireExclusive();
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            latch.releaseExclusive();
            try {
                Utils.closeQuietly(null, ((_Tree)obj).mDatabase, e);
            }
            finally {
                latch.acquireExclusive();
            }
        }
    }

    _PendingTxn transferExclusive(_LockOwner locker, _PendingTxn pending) {
        if (this.mLockCount == -1) {
            if (this.mOwner == locker) {
                if (pending == null) {
                    pending = new _PendingTxn(this);
                } else {
                    pending.add(this);
                }
                this.mOwner = pending;
            }
        } else {
            this.unlock(locker, null);
        }
        return pending;
    }

    boolean matches(long indexId, byte[] key, int hash) {
        return this.mHashCode == hash && this.mIndexId == indexId && Arrays.equals(this.mKey, key);
    }

    private boolean isSharedLockOwner(_LockOwner locker) {
        Object sharedObj = this.mSharedLockOwnersObj;
        if (sharedObj == locker) {
            return true;
        }
        if (sharedObj instanceof LockOwnerHTEntry[]) {
            return _Lock.lockerHTcontains((LockOwnerHTEntry[])sharedObj, locker);
        }
        return false;
    }

    private LockResult tryLockShared(_LockOwner locker) {
        int count = this.mLockCount;
        if (count == -1) {
            return null;
        }
        if (count != 0 && this.isSharedLockOwner(locker)) {
            return LockResult.OWNED_SHARED;
        }
        if ((count & Integer.MAX_VALUE) >= 0x7FFFFFFE) {
            throw new IllegalStateException("Too many shared locks held");
        }
        this.addSharedLockOwner(count, locker);
        return LockResult.ACQUIRED;
    }

    private void addSharedLockOwner(int count, _LockOwner locker) {
        ++count;
        Object sharedObj = this.mSharedLockOwnersObj;
        if (sharedObj == null) {
            this.mSharedLockOwnersObj = locker;
        } else if (sharedObj instanceof LockOwnerHTEntry[]) {
            LockOwnerHTEntry[] entries = (LockOwnerHTEntry[])sharedObj;
            this.lockerHTadd(entries, count & Integer.MAX_VALUE, locker);
        } else {
            LockOwnerHTEntry[] entries = new LockOwnerHTEntry[8];
            _Lock.lockerHTadd(entries, (_LockOwner)sharedObj);
            _Lock.lockerHTadd(entries, locker);
            this.mSharedLockOwnersObj = entries;
        }
        this.mLockCount = count;
    }

    private static boolean lockerHTcontains(LockOwnerHTEntry[] entries, _LockOwner locker) {
        int hash = locker.hashCode();
        LockOwnerHTEntry e = entries[hash & entries.length - 1];
        while (e != null) {
            if (e.mOwner == locker) {
                return true;
            }
            e = e.mNext;
        }
        return false;
    }

    private void lockerHTadd(LockOwnerHTEntry[] entries, int newSize, _LockOwner locker) {
        if (newSize > entries.length >> 1) {
            int capacity = entries.length << 1;
            LockOwnerHTEntry[] newEntries = new LockOwnerHTEntry[capacity];
            int newMask = capacity - 1;
            int i = entries.length;
            while (--i >= 0) {
                LockOwnerHTEntry e = entries[i];
                while (e != null) {
                    LockOwnerHTEntry next = e.mNext;
                    int ix = e.mOwner.hashCode() & newMask;
                    e.mNext = newEntries[ix];
                    newEntries[ix] = e;
                    e = next;
                }
            }
            entries = newEntries;
            this.mSharedLockOwnersObj = newEntries;
        }
        _Lock.lockerHTadd(entries, locker);
    }

    private static void lockerHTadd(LockOwnerHTEntry[] entries, _LockOwner locker) {
        int index = locker.hashCode() & entries.length - 1;
        LockOwnerHTEntry e = new LockOwnerHTEntry();
        e.mOwner = locker;
        e.mNext = entries[index];
        entries[index] = e;
    }

    private static boolean lockerHTremove(LockOwnerHTEntry[] entries, _LockOwner locker) {
        int index = locker.hashCode() & entries.length - 1;
        LockOwnerHTEntry e = entries[index];
        LockOwnerHTEntry prev = null;
        while (e != null) {
            if (e.mOwner == locker) {
                if (prev == null) {
                    entries[index] = e.mNext;
                } else {
                    prev.mNext = e.mNext;
                }
                return true;
            }
            prev = e;
            e = e.mNext;
        }
        return false;
    }

    private static _LockOwner lockerHTgetOne(LockOwnerHTEntry[] entries) {
        for (LockOwnerHTEntry e : entries) {
            if (e == null) continue;
            return e.mOwner;
        }
        throw new AssertionError((Object)"No lockers in hashtable");
    }

    static final class LockOwnerHTEntry {
        _LockOwner mOwner;
        LockOwnerHTEntry mNext;

        LockOwnerHTEntry() {
        }
    }
}

