/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.Index;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.View;

class ViewUtils {
    ViewUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long count(View view, boolean autoload, byte[] lowKey, byte[] highKey) throws IOException {
        long count = 0L;
        Cursor c = view.newCursor(Transaction.BOGUS);
        try {
            c.autoload(autoload);
            if (lowKey == null) {
                c.first();
            } else {
                c.findGe(lowKey);
            }
            if (highKey == null) {
                while (c.key() != null) {
                    ++count;
                    c.next();
                }
            } else {
                while (c.key() != null && c.compareKeyTo(highKey) < 0) {
                    ++count;
                    c.next();
                }
            }
        }
        finally {
            c.reset();
        }
        return count;
    }

    static byte[] appendZero(byte[] key) {
        byte[] newKey = new byte[key.length + 1];
        System.arraycopy(key, 0, newKey, 0, key.length);
        return newKey;
    }

    static View checkOrdering(View view) {
        Ordering ordering = view.getOrdering();
        if (ordering == Ordering.DESCENDING) {
            view = view.viewReverse();
            ordering = view.getOrdering();
        }
        if (ordering != Ordering.ASCENDING) {
            throw new UnsupportedOperationException("Unsupported ordering: " + (Object)((Object)ordering));
        }
        return view;
    }

    static LockResult skip(Cursor c, long amount, byte[] limitKey, boolean inclusive) throws IOException {
        if (amount == 0L || limitKey == null) {
            return c.skip(amount);
        }
        if (amount > 0L) {
            if (inclusive) {
                while (true) {
                    LockResult result = c.nextLe(limitKey);
                    if (c.key() == null || --amount <= 0L) {
                        return result;
                    }
                    if (result != LockResult.ACQUIRED) continue;
                    c.link().unlock();
                }
            }
            while (true) {
                LockResult result = c.nextLt(limitKey);
                if (c.key() == null || --amount <= 0L) {
                    return result;
                }
                if (result != LockResult.ACQUIRED) continue;
                c.link().unlock();
            }
        }
        if (inclusive) {
            while (true) {
                LockResult result = c.previousGe(limitKey);
                if (c.key() == null || ++amount >= 0L) {
                    return result;
                }
                if (result != LockResult.ACQUIRED) continue;
                c.link().unlock();
            }
        }
        while (true) {
            LockResult result = c.previousGt(limitKey);
            if (c.key() == null || ++amount >= 0L) {
                return result;
            }
            if (result != LockResult.ACQUIRED) continue;
            c.link().unlock();
        }
    }

    static LockResult doSkip(Cursor c, long amount) throws IOException {
        if (amount == 0L) {
            throw new IllegalArgumentException("Skip is zero");
        }
        if (amount > 0L) {
            while (true) {
                LockResult result = c.next();
                if (c.key() == null || --amount <= 0L) {
                    return result;
                }
                if (result != LockResult.ACQUIRED) continue;
                c.link().unlock();
            }
        }
        while (true) {
            LockResult result = c.previous();
            if (c.key() == null || ++amount >= 0L) {
                return result;
            }
            if (result != LockResult.ACQUIRED) continue;
            c.link().unlock();
        }
    }

    static final String toString(Index ix) {
        StringBuilder b = new StringBuilder(ix.getClass().getName());
        b.append('@').append(Integer.toHexString(ix.hashCode()));
        b.append(" {");
        String nameStr = ix.getNameString();
        if (nameStr != null) {
            b.append("name").append(": ").append(nameStr);
            b.append(", ");
        }
        b.append("id").append(": ").append(ix.getId());
        return b.append('}').toString();
    }
}

