/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.Filter;
import org.cojen.tupl.Index;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Transformer;
import org.cojen.tupl.UnmodifiableCursor;
import org.cojen.tupl.UnmodifiableViewException;
import org.cojen.tupl.VerificationObserver;
import org.cojen.tupl.View;
import org.cojen.tupl.ViewConstraintException;
import org.cojen.tupl.ViewUtils;

final class UnmodifiableView
implements Index {
    private final View mSource;

    static View apply(View view) {
        return view.isUnmodifiable() ? view : new UnmodifiableView(view);
    }

    UnmodifiableView(View source) {
        this.mSource = source;
    }

    public String toString() {
        if (this.mSource instanceof Index) {
            return ViewUtils.toString(this);
        }
        return super.toString();
    }

    @Override
    public Ordering getOrdering() {
        return this.mSource.getOrdering();
    }

    @Override
    public long getId() {
        if (this.mSource instanceof Index) {
            return ((Index)this.mSource).getId();
        }
        return 0L;
    }

    @Override
    public byte[] getName() {
        if (this.mSource instanceof Index) {
            return ((Index)this.mSource).getName();
        }
        return null;
    }

    @Override
    public String getNameString() {
        if (this.mSource instanceof Index) {
            return ((Index)this.mSource).getNameString();
        }
        return null;
    }

    @Override
    public Cursor newCursor(Transaction txn) {
        return new UnmodifiableCursor(this.mSource.newCursor(txn));
    }

    @Override
    public long count(byte[] lowKey, byte[] highKey) throws IOException {
        return this.mSource.count(lowKey, highKey);
    }

    @Override
    public byte[] load(Transaction txn, byte[] key) throws IOException {
        return this.mSource.load(txn, key);
    }

    @Override
    public void store(Transaction txn, byte[] key, byte[] value) throws IOException {
        throw new UnmodifiableViewException();
    }

    @Override
    public byte[] exchange(Transaction txn, byte[] key, byte[] value) throws IOException {
        throw new UnmodifiableViewException();
    }

    @Override
    public boolean insert(Transaction txn, byte[] key, byte[] value) throws IOException {
        throw new UnmodifiableViewException();
    }

    @Override
    public boolean replace(Transaction txn, byte[] key, byte[] value) throws IOException {
        throw new UnmodifiableViewException();
    }

    @Override
    public boolean update(Transaction txn, byte[] key, byte[] oldValue, byte[] newValue) throws IOException {
        throw new UnmodifiableViewException();
    }

    @Override
    public boolean delete(Transaction txn, byte[] key) throws IOException {
        throw new UnmodifiableViewException();
    }

    @Override
    public boolean remove(Transaction txn, byte[] key, byte[] value) throws IOException {
        throw new UnmodifiableViewException();
    }

    @Override
    public long evict(Transaction txn, byte[] lowKey, byte[] highKey, Filter evictionFilter, boolean autoload) throws IOException {
        throw new UnmodifiableViewException();
    }

    @Override
    public LockResult lockShared(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        return this.mSource.lockShared(txn, key);
    }

    @Override
    public LockResult lockUpgradable(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        return this.mSource.lockUpgradable(txn, key);
    }

    @Override
    public LockResult lockExclusive(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        return this.mSource.lockExclusive(txn, key);
    }

    @Override
    public LockResult lockCheck(Transaction txn, byte[] key) throws ViewConstraintException {
        return this.mSource.lockCheck(txn, key);
    }

    @Override
    public View viewGe(byte[] key) {
        return new UnmodifiableView(this.mSource.viewGe(key));
    }

    @Override
    public View viewGt(byte[] key) {
        return new UnmodifiableView(this.mSource.viewGt(key));
    }

    @Override
    public View viewLe(byte[] key) {
        return new UnmodifiableView(this.mSource.viewLe(key));
    }

    @Override
    public View viewLt(byte[] key) {
        return new UnmodifiableView(this.mSource.viewLt(key));
    }

    @Override
    public View viewPrefix(byte[] prefix, int trim) {
        return new UnmodifiableView(this.mSource.viewPrefix(prefix, trim));
    }

    @Override
    public View viewTransformed(Transformer transformer) {
        return new UnmodifiableView(this.mSource.viewTransformed(transformer));
    }

    @Override
    public View viewReverse() {
        return new UnmodifiableView(this.mSource.viewReverse());
    }

    @Override
    public View viewUnmodifiable() {
        return this;
    }

    @Override
    public boolean isUnmodifiable() {
        return true;
    }

    @Override
    public Index.Stats analyze(byte[] lowKey, byte[] highKey) throws IOException {
        if (this.mSource instanceof Index) {
            return ((Index)this.mSource).analyze(lowKey, highKey);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean verify(VerificationObserver observer) throws IOException {
        if (this.mSource instanceof Index) {
            return ((Index)this.mSource).verify(observer);
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        throw new UnmodifiableViewException();
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void drop() throws IOException {
        throw new UnmodifiableViewException();
    }
}

