/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import java.util.Arrays;
import org.cojen.tupl.AbstractStream;
import org.cojen.tupl.CommitLock;
import org.cojen.tupl.CursorFrame;
import org.cojen.tupl.LargeValueException;
import org.cojen.tupl.LocalDatabase;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Node;
import org.cojen.tupl.PageOps;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Tree;
import org.cojen.tupl.TreeCursor;
import org.cojen.tupl.Utils;

final class TreeValueStream
extends AbstractStream {
    private static final int OP_LENGTH = 0;
    private static final int OP_READ = 1;
    private static final int OP_SET_LENGTH = 2;
    private static final int OP_WRITE = 3;
    static final byte[] TOUCH_VALUE = new byte[0];
    private final TreeCursor mCursor;
    private final LocalDatabase mDatabase;

    TreeValueStream(TreeCursor cursor) {
        this.mCursor = cursor;
        this.mDatabase = cursor.mTree.mDatabase;
    }

    @Override
    public LockResult open(Transaction txn, byte[] key) throws IOException {
        TreeCursor cursor = this.mCursor;
        if (cursor.key() != null) {
            this.close();
        }
        cursor.link(txn);
        try {
            return cursor.find(key);
        }
        catch (Throwable e) {
            this.mCursor.reset();
            throw e;
        }
    }

    @Override
    public Transaction link(Transaction txn) {
        return this.mCursor.link(txn);
    }

    @Override
    public Transaction link() {
        return this.mCursor.link();
    }

    @Override
    public long length() throws IOException {
        CursorFrame frame;
        try {
            frame = this.mCursor.leafSharedNotSplit();
        }
        catch (IllegalStateException e) {
            this.checkOpen();
            throw e;
        }
        long result = this.action(frame, 0, 0L, null, 0, 0);
        frame.mNode.releaseShared();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLength(long length) throws IOException {
        try {
            if (length < 0L) {
                this.mCursor.store(null);
                return;
            }
            CursorFrame leaf = this.mCursor.leafExclusiveNotSplit();
            CommitLock commitLock = this.mCursor.commitLock(leaf);
            try {
                this.mCursor.notSplitDirty(leaf);
                this.action(leaf, 2, length, Utils.EMPTY_BYTES, 0, 0);
                leaf.mNode.releaseExclusive();
            }
            finally {
                commitLock.releaseShared();
            }
        }
        catch (IllegalStateException e) {
            this.checkOpen();
            throw e;
        }
    }

    @Override
    int doRead(long pos, byte[] buf, int off, int len) throws IOException {
        CursorFrame frame;
        try {
            frame = this.mCursor.leafSharedNotSplit();
        }
        catch (IllegalStateException e) {
            this.checkOpen();
            throw e;
        }
        int result = (int)this.action(frame, 1, pos, buf, off, len);
        frame.mNode.releaseShared();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doWrite(long pos, byte[] buf, int off, int len) throws IOException {
        try {
            CursorFrame leaf = this.mCursor.leafExclusiveNotSplit();
            CommitLock commitLock = this.mCursor.commitLock(leaf);
            try {
                this.mCursor.notSplitDirty(leaf);
                this.action(leaf, 3, pos, buf, off, len);
                leaf.mNode.releaseExclusive();
            }
            finally {
                commitLock.releaseShared();
            }
        }
        catch (IllegalStateException e) {
            this.checkOpen();
            throw e;
        }
    }

    @Override
    int selectBufferSize(int bufferSize) {
        if (bufferSize <= 1) {
            bufferSize = bufferSize < 0 ? this.mDatabase.mPageSize : 1;
        } else if (bufferSize >= 65536) {
            bufferSize = 65536;
        }
        return bufferSize;
    }

    @Override
    void checkOpen() {
        if (this.mCursor.key() == null) {
            throw new IllegalStateException("Stream closed");
        }
    }

    @Override
    void doClose() {
        this.mCursor.reset();
    }

    int compactCheck(CursorFrame frame, long pos, long highestNodeId) throws IOException {
        long vLen;
        int len;
        byte header;
        Node node = frame.mNode;
        int nodePos = frame.mNodePos;
        if (nodePos < 0) {
            return -1;
        }
        byte[] page = node.mPage;
        int loc = PageOps.p_ushortGetLE(page, node.searchVecStart() + nodePos);
        loc += Node.keyLengthAtLoc(page, loc);
        if ((header = PageOps.p_byteGet(page, loc++)) >= 0) {
            return pos >= (long)header ? -1 : 0;
        }
        if ((header & 0x20) == 0) {
            len = 1 + ((header & 0x1F) << 8 | PageOps.p_ubyteGet(page, loc++));
        } else if (header != -1) {
            len = 1 + ((header & 0xF) << 16 | PageOps.p_ubyteGet(page, loc++) << 8 | PageOps.p_ubyteGet(page, loc++));
        } else {
            return -1;
        }
        if ((header & 0x40) == 0) {
            return pos >= (long)len ? -1 : 0;
        }
        if (pos >= (vLen = LocalDatabase.decodeFullFragmentedValueLength(header = PageOps.p_byteGet(page, loc++), page, loc))) {
            return -1;
        }
        loc += 2 + (header >> 1 & 6);
        if ((header & 2) != 0) {
            int inLen = PageOps.p_ushortGetLE(page, loc);
            if (pos < (long)inLen) {
                return 0;
            }
            pos -= (long)inLen;
            loc = loc + 2 + inLen;
        }
        if ((header & 1) == 0) {
            long fNodeId = PageOps.p_uint48GetLE(page, loc += (int)pos / this.pageSize(page) * 6);
            return fNodeId > highestNodeId ? 1 : 0;
        }
        long inodeId = PageOps.p_uint48GetLE(page, loc);
        if (inodeId == 0L) {
            return 0;
        }
        Node inode = this.mDatabase.nodeMapLoadFragment(inodeId);
        int level = this.mDatabase.calculateInodeLevels(vLen);
        while (true) {
            long levelCap = this.mDatabase.levelCap(--level);
            long childNodeId = PageOps.p_uint48GetLE(inode.mPage, (int)(pos / levelCap) * 6);
            inode.releaseShared();
            if (childNodeId > highestNodeId) {
                return 1;
            }
            if (level <= 0 || childNodeId == 0L) {
                return 0;
            }
            inode = this.mDatabase.nodeMapLoadFragment(childNodeId);
            pos %= levelCap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private long action(CursorFrame frame, int op, long pos, byte[] b, int bOff, int bLen) throws IOException {
        block87: {
            block86: {
                block85: {
                    node = frame.mNode;
                    nodePos = frame.mNodePos;
                    if (nodePos < 0) {
                        if (op <= 1) {
                            return -1L;
                        }
                        if (b == TreeValueStream.TOUCH_VALUE) {
                            return 0L;
                        }
                        node = this.mCursor.insertBlank(frame, node, pos + (long)bLen);
                        if (bLen <= 0) {
                            return 0L;
                        }
                        nodePos = frame.mNodePos;
                    }
                    page = node.mPage;
                    loc = PageOps.p_ushortGetLE(page, node.searchVecStart() + nodePos);
                    loc += Node.keyLengthAtLoc(page, loc);
                    vHeaderLoc = loc;
                    if ((header = PageOps.p_byteGet(page, loc++)) < 0) break block85;
                    vLen = header;
                    break block86;
                }
                if ((header & 32) == 0) {
                    len = 1 + ((header & 31) << 8 | PageOps.p_ubyteGet(page, loc++));
                } else if (header != -1) {
                    len = 1 + ((header & 15) << 16 | PageOps.p_ubyteGet(page, loc++) << 8 | PageOps.p_ubyteGet(page, loc++));
                } else {
                    if (op <= 1) {
                        return -1L;
                    }
                    if (b == TreeValueStream.TOUCH_VALUE) {
                        return 0L;
                    }
                    node.releaseExclusive();
                    throw null;
                }
                if ((header & 64) != 0) break block87;
                vLen = len;
            }
            switch (op) {
                default: {
                    return vLen;
                }
                case 1: {
                    if (bLen <= 0 || pos >= vLen) {
                        bLen = 0;
                    } else {
                        bLen = Math.min((int)(vLen - pos), bLen);
                        PageOps.p_copyToArray(page, (int)((long)loc + pos), b, bOff, bLen);
                    }
                    return bLen;
                }
                case 2: {
                    if (pos > vLen) break;
                    newLen = (int)pos;
                    oldLen = (int)vLen;
                    garbageAccum = oldLen - newLen;
                    if (newLen > 127) ** GOTO lbl60
                    PageOps.p_bytePut(page, vHeaderLoc, newLen);
                    if (oldLen <= 127) ** GOTO lbl73
                    if (oldLen <= 8192) {
                        vLoc = vHeaderLoc + 2;
                        vShift = 1;
                    } else {
                        vLoc = vHeaderLoc + 3;
                        vShift = 2;
                    }
                    ** GOTO lbl71
lbl60:
                    // 1 sources

                    if (newLen > 8192) ** GOTO lbl67
                    PageOps.p_bytePut(page, vHeaderLoc, 128 | newLen - 1 >> 8);
                    PageOps.p_bytePut(page, vHeaderLoc + 1, newLen - 1);
                    if (oldLen <= 8192) ** GOTO lbl73
                    vLoc = vHeaderLoc + 3;
                    vShift = 1;
                    ** GOTO lbl71
lbl67:
                    // 1 sources

                    PageOps.p_bytePut(page, vHeaderLoc, 160 | newLen - 1 >> 16);
                    PageOps.p_bytePut(page, vHeaderLoc + 1, newLen - 1 >> 8);
                    PageOps.p_bytePut(page, vHeaderLoc + 2, newLen - 1);
                    ** GOTO lbl73
lbl71:
                    // 3 sources

                    garbageAccum += vShift;
                    PageOps.p_copy(page, vLoc, page, vLoc - vShift, newLen);
lbl73:
                    // 4 sources

                    node.garbage(node.garbage() + garbageAccum);
                    return 0L;
                }
                case 3: {
                    if (b == TreeValueStream.TOUCH_VALUE) {
                        return 0L;
                    }
                    if (pos >= vLen) break;
                    end = pos + (long)bLen;
                    if (end <= vLen) {
                        PageOps.p_copyFromArray(b, bOff, page, (int)((long)loc + pos), bLen);
                        return 0L;
                    }
                    if (pos == 0L && bOff == 0 && bLen == b.length) {
                        try {
                            node.updateLeafValue(null, this.mCursor.mTree, nodePos, 0, b);
                        }
                        catch (IOException e) {
                            node.releaseExclusive();
                            throw e;
                        }
                        return 0L;
                    }
                    len = (int)(vLen - pos);
                    PageOps.p_copyFromArray(b, bOff, page, (int)((long)loc + pos), len);
                    pos = vLen;
                    bOff += len;
                    bLen -= len;
                }
            }
            oldValue = new byte[(int)vLen];
            PageOps.p_copyToArray(page, loc, oldValue, 0, oldValue.length);
            node.deleteLeafEntry(nodePos);
            frame.mNodePos = ~nodePos;
            this.mCursor.insertBlank(frame, node, pos + (long)bLen);
            this.action(frame, 3, 0L, oldValue, 0, oldValue.length);
            if (bLen > 0) {
                this.action(frame, 3, pos, b, bOff, bLen);
            }
            return 0L;
        }
        fHeaderLoc = loc;
        header = PageOps.p_byteGet(page, loc++);
        switch (header >> 2 & 3) {
            default: {
                vLen = PageOps.p_ushortGetLE(page, loc);
                break;
            }
            case 1: {
                vLen = (long)PageOps.p_intGetLE(page, loc) & 0xFFFFFFFFL;
                break;
            }
            case 2: {
                vLen = PageOps.p_uint48GetLE(page, loc);
                break;
            }
            case 3: {
                vLen = PageOps.p_longGetLE(page, loc);
                if (vLen >= 0L) break;
                if (op <= 1) {
                    node.releaseShared();
                } else {
                    node.releaseExclusive();
                }
                throw new LargeValueException(vLen);
            }
        }
        loc += 2 + (header >> 1 & 6);
        switch (op) {
            default: {
                return vLen;
            }
            case 1: {
                try {
                    if (bLen <= 0 || pos >= vLen) {
                        return 0L;
                    }
                    total = bLen = (int)Math.min(vLen - pos, (long)bLen);
                    if ((header & 2) != 0) {
                        inLen = PageOps.p_ushortGetLE(page, loc);
                        loc += 2;
                        amt = (int)((long)inLen - pos);
                        if (amt <= 0) {
                            pos -= (long)inLen;
                        } else {
                            if (bLen <= amt) {
                                PageOps.p_copyToArray(page, (int)((long)loc + pos), b, bOff, bLen);
                                return bLen;
                            }
                            PageOps.p_copyToArray(page, (int)((long)loc + pos), b, bOff, amt);
                            bLen -= amt;
                            bOff += amt;
                            pos = 0L;
                        }
                        loc += inLen;
                    }
                    if ((header & 1) == 0) {
                        ipos = (int)pos;
                        loc += ipos / this.pageSize(page) * 6;
                        fNodeOff = ipos % this.pageSize(page);
                        while (true) {
                            amt = Math.min(bLen, this.pageSize(page) - fNodeOff);
                            fNodeId = PageOps.p_uint48GetLE(page, loc);
                            if (fNodeId == 0L) {
                                Arrays.fill(b, bOff, bOff + amt, (byte)0);
                            } else {
                                fNode = this.mDatabase.nodeMapLoadFragment(fNodeId);
                                PageOps.p_copyToArray(fNode.mPage, fNodeOff, b, bOff, amt);
                                fNode.releaseShared();
                            }
                            if ((bLen -= amt) <= 0) {
                                return total;
                            }
                            bOff += amt;
                            loc += 6;
                            fNodeOff = 0;
                        }
                    }
                    inodeId = PageOps.p_uint48GetLE(page, loc);
                    if (inodeId == 0L) {
                        Arrays.fill(b, bOff, bOff + bLen, (byte)0);
                    } else {
                        db = this.mDatabase;
                        inode = db.nodeMapLoadFragment(inodeId);
                        levels = db.calculateInodeLevels(vLen);
                        this.readMultilevelFragments(pos, levels, inode, b, bOff, bLen);
                    }
                    return total;
                }
                catch (IOException e) {
                    node.releaseShared();
                    throw e;
                }
            }
            case 2: {
                endPos = pos + (long)bLen;
                if (endPos > vLen) break;
                if (endPos == vLen) {
                    return 0L;
                }
                node.releaseExclusive();
                throw null;
            }
            case 3: 
        }
        try {
            endPos = pos + (long)bLen;
            inlineLen = 0;
            if ((header & 2) != 0) {
                inlineLen = PageOps.p_ushortGetLE(page, loc);
                loc += 2;
                amt = (long)inlineLen - pos;
                if (amt <= 0L) {
                    pos -= (long)inlineLen;
                } else {
                    if ((long)bLen <= amt) {
                        PageOps.p_copyFromArray(b, bOff, page, (int)((long)loc + pos), bLen);
                        return 0L;
                    }
                    PageOps.p_copyFromArray(b, bOff, page, (int)((long)loc + pos), (int)amt);
                    bLen = (int)((long)bLen - amt);
                    bOff = (int)((long)bOff + amt);
                    pos = 0L;
                }
                loc += inlineLen;
            }
            if (endPos <= vLen) {
                if (bLen == 0 & b != TreeValueStream.TOUCH_VALUE) {
                    return 0L;
                }
            } else {
                if (b == TreeValueStream.TOUCH_VALUE) {
                    return 0L;
                }
                newLoc = this.updateLengthField(frame, page, fHeaderLoc, endPos);
                if (newLoc < 0) {
                    fHeaderLoc = loc = ~newLoc;
                    header = PageOps.p_byteGet(page, loc++);
                    loc += 2 + (header >> 1 & 6);
                } else if (newLoc != fHeaderLoc) {
                    fHeaderLoc = loc = newLoc;
                    header = PageOps.p_byteGet(page, loc++);
                    loc += 2 + (header >> 1 & 6);
                }
                page = node.mPage;
                if ((header & 1) == 0) {
                    p = this.pageSize(page);
                    growth = (endPos + p - 1L) / p - (vLen + p - 1L) / p;
                    vLen = endPos;
                    if (growth > 0L) {
                        newLoc = this.extendFragmentedValue(node, this.mCursor.mTree, nodePos, growth * 6L, true);
                        if (newLoc >= 0) {
                            delta = newLoc - fHeaderLoc;
                            loc += delta;
                            page = node.mPage;
                        } else {
                            page = node.mPage;
                            header = PageOps.p_byteGet(page, newLoc ^= -1);
                            delta = newLoc - fHeaderLoc;
                            loc += delta;
                        }
                    }
                } else {
                    inode = this.prepareMultilevelWrite(page, loc);
                    levels = this.mDatabase.calculateInodeLevels(vLen - (long)inlineLen);
                    vLen = endPos - (long)inlineLen;
                    if (this.mDatabase.levelCap(levels) < vLen) {
                        newLevels = this.mDatabase.calculateInodeLevels(vLen);
                        if (newLevels <= levels) {
                            throw new AssertionError();
                        }
                        do {
                            upper = this.mDatabase.allocDirtyFragmentNode();
                            upage = upper.mPage;
                            PageOps.p_int48PutLE(upage, 0, inode.mId);
                            inode.releaseExclusive();
                            PageOps.p_clear(upage, 6, this.pageSize(upage));
                            inode = upper;
                        } while (newLevels > ++levels);
                        PageOps.p_int48PutLE(page, loc, inode.mId);
                    }
                    this.writeMultilevelFragments(pos, levels, inode, b, bOff, bLen);
                    return 0L;
                }
            }
            vLen -= (long)inlineLen;
            if ((header & 1) == 0) {
                ipos = (int)pos;
                loc += ipos / this.pageSize(page) * 6;
                fNodeOff = ipos % this.pageSize(page);
                while (true) {
                    amt = Math.min(bLen, this.pageSize(page) - fNodeOff);
                    fNodeId = PageOps.p_uint48GetLE(page, loc);
                    if (fNodeId == 0L) {
                        fNode = this.mDatabase.allocDirtyFragmentNode();
                        try {
                            PageOps.p_int48PutLE(page, loc, fNode.mId);
                            fNodePage = fNode.mPage;
                            PageOps.p_clear(fNodePage, 0, fNodeOff);
                            PageOps.p_copyFromArray(b, bOff, fNodePage, fNodeOff, amt);
                            PageOps.p_clear(fNodePage, fNodeOff + amt, this.pageSize(fNodePage));
                        }
                        finally {
                            fNode.releaseExclusive();
                        }
                    }
                    db = this.mDatabase;
                    fNode = db.nodeMapLoadFragmentExclusive(fNodeId, amt < this.pageSize(page));
                    try {
                        if (db.markFragmentDirty(fNode)) {
                            PageOps.p_int48PutLE(page, loc, fNode.mId);
                        }
                        PageOps.p_copyFromArray(b, bOff, fNode.mPage, fNodeOff, amt);
                    }
                    finally {
                        fNode.releaseExclusive();
                    }
                    if ((bLen -= amt) <= 0) {
                        return 0L;
                    }
                    bOff += amt;
                    loc += 6;
                    fNodeOff = 0;
                }
            }
            inode = this.prepareMultilevelWrite(page, loc);
            levels = this.mDatabase.calculateInodeLevels(vLen);
            this.writeMultilevelFragments(pos, levels, inode, b, bOff, bLen);
            return 0L;
        }
        catch (IOException e) {
            node.releaseExclusive();
            throw e;
        }
    }

    private int updateLengthField(CursorFrame frame, byte[] page, int loc, long len) throws IOException {
        int growth;
        int header = PageOps.p_byteGet(page, loc);
        switch (header >> 2 & 3) {
            default: {
                if (len < 65536L) {
                    PageOps.p_shortPutLE(page, loc + 1, (int)len);
                    return loc;
                }
                growth = len < 0x100000000L ? 2 : (len < 0x1000000000000L ? 2 : 4);
                break;
            }
            case 1: {
                if (len < 0x100000000L) {
                    PageOps.p_intPutLE(page, loc + 1, (int)len);
                    return loc;
                }
                growth = len < 0x1000000000000L ? 2 : 4;
                break;
            }
            case 2: {
                if (len < 0x1000000000000L) {
                    PageOps.p_int48PutLE(page, loc + 1, len);
                    return loc;
                }
                growth = 2;
                break;
            }
            case 3: {
                PageOps.p_longPutLE(page, loc + 1, len);
                return loc;
            }
        }
        Node node = frame.mNode;
        int nodePos = frame.mNodePos;
        int newLoc = this.extendFragmentedValue(node, this.mCursor.mTree, nodePos, growth, false);
        page = node.mPage;
        if (newLoc < 0) {
            loc = ~newLoc;
            header |= 1;
        } else {
            loc = newLoc;
        }
        header &= 0xFFFFFFF3;
        if (len < 0x100000000L) {
            header |= 4;
            PageOps.p_intPutLE(page, loc + 1, (int)len);
        } else if (len < 0x1000000000000L) {
            header |= 8;
            PageOps.p_int48PutLE(page, loc + 1, len);
        } else {
            header |= 0xC;
            PageOps.p_longPutLE(page, loc + 1, len);
        }
        PageOps.p_bytePut(page, loc, header);
        return newLoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMultilevelFragments(long pos, int level, Node inode, byte[] b, int bOff, int bLen) throws IOException {
        try {
            byte[] page = inode.mPage;
            long levelCap = this.mDatabase.levelCap(--level);
            int firstChild = (int)(pos / levelCap);
            int lastChild = (int)((pos + (long)bLen - 1L) / levelCap);
            int childNodeCount = lastChild - firstChild + 1;
            long ppos = pos % levelCap;
            int poffset = firstChild * 6;
            for (int i = 0; i < childNodeCount; ++i) {
                long childNodeId = PageOps.p_uint48GetLE(page, poffset);
                int len = (int)Math.min(levelCap - ppos, (long)bLen);
                if (childNodeId == 0L) {
                    Arrays.fill(b, bOff, bOff + len, (byte)0);
                } else {
                    Node childNode = this.mDatabase.nodeMapLoadFragment(childNodeId);
                    if (level <= 0) {
                        PageOps.p_copyToArray(childNode.mPage, (int)ppos, b, bOff, len);
                        childNode.releaseShared();
                    } else {
                        this.readMultilevelFragments(ppos, level, childNode, b, bOff, len);
                    }
                }
                if ((bLen -= len) <= 0) {
                    break;
                }
                bOff += len;
                ppos = 0L;
                poffset += 6;
            }
        }
        finally {
            inode.releaseShared();
        }
    }

    private Node prepareMultilevelWrite(byte[] page, int loc) throws IOException {
        Node inode;
        block5: {
            block4: {
                long inodeId = PageOps.p_uint48GetLE(page, loc);
                if (inodeId == 0L) {
                    inode = this.mDatabase.allocDirtyFragmentNode();
                    PageOps.p_clear(inode.mPage, 0, this.pageSize(inode.mPage));
                } else {
                    LocalDatabase db = this.mDatabase;
                    inode = db.nodeMapLoadFragmentExclusive(inodeId, true);
                    try {
                        if (db.markFragmentDirty(inode)) break block4;
                        break block5;
                    }
                    catch (Throwable e) {
                        inode.releaseExclusive();
                        throw e;
                    }
                }
            }
            PageOps.p_int48PutLE(page, loc, inode.mId);
        }
        return inode;
    }

    private void writeMultilevelFragments(long pos, int level, Node inode, byte[] b, int bOff, int bLen) throws IOException {
        LocalDatabase db = this.mDatabase;
        try {
            byte[] page = inode.mPage;
            long levelCap = db.levelCap(--level);
            int firstChild = (int)(pos / levelCap);
            int lastChild = bLen == 0 ? firstChild : (int)((pos + (long)bLen - 1L) / levelCap);
            int childNodeCount = lastChild - firstChild + 1;
            long ppos = pos % levelCap;
            int poffset = firstChild * 6;
            for (int i = 0; i < childNodeCount; ++i) {
                Node childNode;
                int off;
                int len;
                block15: {
                    block14: {
                        len = (int)Math.min(levelCap - ppos, (long)bLen);
                        off = (int)ppos;
                        long childNodeId = PageOps.p_uint48GetLE(page, poffset);
                        boolean partial = level > 0 | off > 0 | len < this.pageSize(page);
                        if (childNodeId == 0L) {
                            childNode = db.allocDirtyFragmentNode();
                            if (partial) {
                                PageOps.p_clear(childNode.mPage, 0, this.pageSize(childNode.mPage));
                            }
                        } else {
                            childNode = db.nodeMapLoadFragmentExclusive(childNodeId, partial);
                            try {
                                if (db.markFragmentDirty(childNode)) break block14;
                                break block15;
                            }
                            catch (Throwable e) {
                                childNode.releaseExclusive();
                                throw e;
                            }
                        }
                    }
                    PageOps.p_int48PutLE(page, poffset, childNode.mId);
                }
                if (level <= 0) {
                    PageOps.p_copyFromArray(b, bOff, childNode.mPage, off, len);
                    childNode.releaseExclusive();
                } else {
                    this.writeMultilevelFragments(ppos, level, childNode, b, bOff, len);
                }
                if ((bLen -= len) <= 0) {
                    break;
                }
                bOff += len;
                ppos = 0L;
                poffset += 6;
            }
        }
        catch (Throwable e) {
            db.close(e);
            throw e;
        }
        finally {
            inode.releaseExclusive();
        }
    }

    private int extendFragmentedValue(Node node, Tree tree, int pos, long growth, boolean tail) throws IOException {
        int entryLoc;
        long avail = (long)node.availableLeafBytes() - growth;
        if (avail < 0L) {
            throw new Error("split 1: " + node.availableLeafBytes() + ", " + growth);
        }
        int igrowth = (int)growth;
        int searchVecStart = node.searchVecStart();
        byte[] page = node.mPage;
        int loc = entryLoc = PageOps.p_ushortGetLE(page, searchVecStart + pos);
        int len = Node.keyLengthAtLoc(page, loc);
        byte[] key = new byte[len];
        PageOps.p_copyToArray(page, loc, key, 0, len);
        loc += len;
        byte header = PageOps.p_byteGet(page, loc++);
        int len2 = (header & 0x20) == 0 ? 1 + ((header & 0x1F) << 8 | PageOps.p_ubyteGet(page, loc++)) : 1 + ((header & 0xF) << 16 | PageOps.p_ubyteGet(page, loc++) << 8 | PageOps.p_ubyteGet(page, loc++));
        byte[] value = new byte[len2];
        PageOps.p_copyToArray(page, loc, value, 0, value.length);
        loc += len2;
        int retMask = 0;
        int newValueLen = Node.calculateFragmentedValueLength(value.length + igrowth);
        if (key.length + newValueLen > tree.mDatabase.mMaxFragmentedEntrySize) {
            int off;
            long vLen;
            byte header2 = value[0];
            if ((header2 & 1) != 0) {
                throw new Error("too big and indirect: " + header2);
            }
            switch (header2 >> 2 & 3) {
                default: {
                    vLen = Utils.decodeUnsignedShortLE(value, 1);
                    off = 3;
                    break;
                }
                case 1: {
                    vLen = (long)Utils.decodeIntLE(value, 1) & 0xFFFFFFFFL;
                    off = 5;
                    break;
                }
                case 2: {
                    vLen = Utils.decodeUnsignedInt48LE(value, 1);
                    off = 7;
                    break;
                }
                case 3: {
                    vLen = Utils.decodeLongLE(value, 1);
                    off = 9;
                }
            }
            int levels = tree.mDatabase.calculateInodeLevels(vLen);
            if (levels <= 0) {
                throw new Error("too big and direct: " + header2 + ", " + levels);
            }
            if ((header2 & 2) != 0) {
                off += Utils.decodeUnsignedShortLE(value, off);
            }
            Node inode = tree.mDatabase.allocDirtyFragmentNode();
            byte[] ipage = inode.mPage;
            PageOps.p_copyFromArray(value, off, ipage, 0, value.length - off);
            PageOps.p_clear(ipage, value.length - off, this.pageSize(ipage));
            while (--levels != 0) {
                Node upper = tree.mDatabase.allocDirtyFragmentNode();
                byte[] upage = upper.mPage;
                PageOps.p_int48PutLE(upage, 0, inode.mId);
                inode.releaseExclusive();
                PageOps.p_clear(upage, 6, this.pageSize(upage));
                inode = upper;
            }
            byte[] ivalue = new byte[off + 6];
            System.arraycopy(value, 0, ivalue, 0, off);
            ivalue[0] = (byte)(ivalue[0] | 1);
            Utils.encodeInt48LE(ivalue, off, inode.mId);
            inode.releaseExclusive();
            retMask = -1;
            value = ivalue;
            if (!tail) {
                throw new Error("head");
            }
            newValueLen = Node.calculateFragmentedValueLength(value.length);
            igrowth = 0;
        }
        node.doDeleteLeafEntry(pos, loc - entryLoc);
        entryLoc = node.createLeafEntry(null, tree, pos, key.length + newValueLen);
        if (entryLoc < 0) {
            throw new Error("split 2");
        }
        page = node.mPage;
        PageOps.p_copyFromArray(key, 0, page, entryLoc, key.length);
        entryLoc += key.length;
        entryLoc = Node.encodeLeafValueHeader(page, 64, value.length + igrowth, entryLoc);
        if (tail) {
            PageOps.p_copyFromArray(value, 0, page, entryLoc, value.length);
            int valueLoc = entryLoc + value.length;
            PageOps.p_clear(page, valueLoc, valueLoc + igrowth);
        } else {
            PageOps.p_copyFromArray(value, 0, page, entryLoc + igrowth, value.length);
        }
        return entryLoc ^ retMask;
    }

    private int pageSize(byte[] page) {
        return page.length;
    }
}

