/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import java.util.Arrays;
import org.cojen.tupl.BoundedView;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.ReverseView;
import org.cojen.tupl.SubView;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.TransformedCursor;
import org.cojen.tupl.Transformer;
import org.cojen.tupl.TrimmedView;
import org.cojen.tupl.UnmodifiableView;
import org.cojen.tupl.Utils;
import org.cojen.tupl.View;
import org.cojen.tupl.ViewConstraintException;
import org.cojen.tupl.ViewUtils;

final class TransformedView
implements View {
    private final View mSource;
    private final Transformer mTransformer;

    static View apply(View source, Transformer transformer) {
        if (transformer == null) {
            throw new NullPointerException("Transformer is null");
        }
        return new TransformedView(source, transformer);
    }

    private TransformedView(View source, Transformer transformer) {
        this.mSource = source;
        this.mTransformer = transformer;
    }

    @Override
    public Ordering getOrdering() {
        return this.mTransformer.transformedOrdering(this.mSource.getOrdering());
    }

    @Override
    public Cursor newCursor(Transaction txn) {
        return new TransformedCursor(this.mSource.newCursor(txn), this.mTransformer);
    }

    @Override
    public long count(byte[] lowKey, byte[] highKey) throws IOException {
        return ViewUtils.count(this, this.mTransformer.requireValue(), lowKey, highKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] load(Transaction txn, byte[] tkey) throws IOException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null) {
            return null;
        }
        if (txn == null || !txn.lockMode().isRepeatable()) {
            return this.mTransformer.transformValue(this.mSource.load(txn, key), key, tkey);
        }
        txn.enter();
        try {
            byte[] value = this.mSource.load(txn, key);
            if (value == null || (value = this.mTransformer.transformValue(value, key, tkey)) != null) {
                txn.commit();
            }
            byte[] byArray = value;
            return byArray;
        }
        finally {
            txn.exit();
        }
    }

    @Override
    public void store(Transaction txn, byte[] tkey, byte[] tvalue) throws IOException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null) {
            throw TransformedView.fail();
        }
        this.mSource.store(txn, key, this.mTransformer.inverseTransformValue(tvalue, key, tkey));
    }

    @Override
    public byte[] exchange(Transaction txn, byte[] tkey, byte[] tvalue) throws IOException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null) {
            throw TransformedView.fail();
        }
        return this.mTransformer.transformValue(this.mSource.exchange(txn, key, this.mTransformer.inverseTransformValue(tvalue, key, tkey)), key, tkey);
    }

    @Override
    public boolean insert(Transaction txn, byte[] tkey, byte[] tvalue) throws IOException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null) {
            if (tvalue == null) {
                return true;
            }
            throw TransformedView.fail();
        }
        byte[] value = this.mTransformer.inverseTransformValue(tvalue, key, tkey);
        if (txn == null || txn.lockMode() == LockMode.UNSAFE) {
            return this.mSource.insert(txn, key, value);
        }
        return this.condStore(txn, key, value, Cursor.NOT_LOADED);
    }

    @Override
    public boolean replace(Transaction txn, byte[] tkey, byte[] tvalue) throws IOException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null) {
            return false;
        }
        byte[] value = this.mTransformer.inverseTransformValue(tvalue, key, tkey);
        if (txn == null || txn.lockMode() == LockMode.UNSAFE) {
            return this.mSource.replace(txn, key, value);
        }
        return this.condStore(txn, key, value, null);
    }

    private boolean condStore(Transaction txn, byte[] key, byte[] value, byte[] failConditionValue) throws IOException {
        Cursor c = this.mSource.newCursor(txn);
        c.autoload(false);
        LockResult result = c.find(key);
        if (c.value() == failConditionValue) {
            c.reset();
            if (result == LockResult.ACQUIRED) {
                txn.unlock();
            }
            return false;
        }
        c.store(value);
        c.reset();
        return true;
    }

    @Override
    public boolean update(Transaction txn, byte[] tkey, byte[] oldTValue, byte[] newTValue) throws IOException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null) {
            if (oldTValue == null) {
                if (newTValue == null) {
                    return true;
                }
                throw TransformedView.fail();
            }
            return false;
        }
        byte[] oldValue = this.mTransformer.inverseTransformValue(oldTValue, key, tkey);
        byte[] newValue = this.mTransformer.inverseTransformValue(newTValue, key, tkey);
        if (txn == null || txn.lockMode() == LockMode.UNSAFE) {
            return this.mSource.update(txn, key, oldValue, newValue);
        }
        return this.condUpdate(txn, key, oldValue, newValue);
    }

    private boolean condUpdate(Transaction txn, byte[] key, byte[] oldValue, byte[] newValue) throws IOException {
        Cursor c = this.mSource.newCursor(txn);
        LockResult result = c.find(key);
        if (!Arrays.equals(c.value(), oldValue)) {
            c.reset();
            if (result == LockResult.ACQUIRED) {
                txn.unlock();
            }
            return false;
        }
        c.store(newValue);
        c.reset();
        return true;
    }

    @Override
    public boolean delete(Transaction txn, byte[] tkey) throws IOException {
        byte[] key = this.inverseTransformKey(tkey);
        return key == null ? false : this.mSource.delete(txn, key);
    }

    @Override
    public boolean remove(Transaction txn, byte[] tkey, byte[] tvalue) throws IOException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null) {
            return tvalue == null;
        }
        byte[] value = this.mTransformer.inverseTransformValue(tvalue, key, tkey);
        if (txn == null || txn.lockMode() == LockMode.UNSAFE) {
            return this.mSource.remove(txn, key, value);
        }
        return this.condUpdate(txn, key, value, null);
    }

    @Override
    public final LockResult lockShared(Transaction txn, byte[] tkey) throws LockFailureException, ViewConstraintException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key != null) {
            return this.mSource.lockShared(txn, key);
        }
        throw TransformedView.fail();
    }

    @Override
    public final LockResult lockUpgradable(Transaction txn, byte[] tkey) throws LockFailureException, ViewConstraintException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key != null) {
            return this.mSource.lockUpgradable(txn, key);
        }
        throw TransformedView.fail();
    }

    @Override
    public final LockResult lockExclusive(Transaction txn, byte[] tkey) throws LockFailureException, ViewConstraintException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key != null) {
            return this.mSource.lockExclusive(txn, key);
        }
        throw TransformedView.fail();
    }

    @Override
    public final LockResult lockCheck(Transaction txn, byte[] tkey) throws ViewConstraintException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key != null) {
            return this.mSource.lockCheck(txn, key);
        }
        throw TransformedView.fail();
    }

    @Override
    public View viewGe(byte[] tkey) {
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null && (key = this.mTransformer.inverseTransformKeyGt(tkey)) == null) {
            return this.nonView();
        }
        return new TransformedView(this.mSource.viewGe(key), this.mTransformer);
    }

    @Override
    public View viewGt(byte[] tkey) {
        View subView;
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null) {
            key = this.mTransformer.inverseTransformKeyGt(tkey);
            if (key == null) {
                return this.nonView();
            }
            subView = this.mSource.viewGe(key);
        } else {
            subView = this.mSource.viewGt(key);
        }
        return new TransformedView(subView, this.mTransformer);
    }

    @Override
    public View viewLe(byte[] tkey) {
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null && (key = this.mTransformer.inverseTransformKeyLt(tkey)) == null) {
            return this.nonView();
        }
        return new TransformedView(this.mSource.viewLe(key), this.mTransformer);
    }

    @Override
    public View viewLt(byte[] tkey) {
        View subView;
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null) {
            key = this.mTransformer.inverseTransformKeyLt(tkey);
            if (key == null) {
                return this.nonView();
            }
            subView = this.mSource.viewLe(key);
        } else {
            subView = this.mSource.viewLt(key);
        }
        return new TransformedView(subView, this.mTransformer);
    }

    @Override
    public View viewPrefix(byte[] tprefix, int trim) {
        byte[] key;
        SubView.prefixCheck(tprefix, trim);
        byte[] lowKey = key = this.inverseTransformKey(tprefix);
        if (lowKey == null && (lowKey = this.mTransformer.inverseTransformKeyGt(tprefix)) == null) {
            return this.nonView();
        }
        View subView = this.mSource.viewGe(lowKey);
        byte[] highTKey = (byte[])tprefix.clone();
        if (Utils.increment(highTKey, 0, highTKey.length)) {
            byte[] highKey = this.inverseTransformKey(highTKey);
            if (highKey == null) {
                highKey = this.mTransformer.inverseTransformKeyLt(highTKey);
                if (highKey == null) {
                    return this.nonView();
                }
                subView = subView.viewLe(highKey);
            } else {
                subView = subView.viewLt(highKey);
            }
        }
        View view = new TransformedView(subView, this.mTransformer);
        if (trim > 0) {
            view = new TrimmedView(view, tprefix, trim);
        }
        return view;
    }

    @Override
    public View viewTransformed(Transformer transformer) {
        return TransformedView.apply(this, transformer);
    }

    @Override
    public View viewReverse() {
        return new ReverseView(this);
    }

    @Override
    public View viewUnmodifiable() {
        return UnmodifiableView.apply(this);
    }

    @Override
    public boolean isUnmodifiable() {
        return this.mSource.isUnmodifiable();
    }

    private byte[] inverseTransformKey(byte[] tkey) {
        if (tkey == null) {
            throw new NullPointerException("Key is null");
        }
        return this.mTransformer.inverseTransformKey(tkey);
    }

    private View nonView() {
        return new TransformedView(new BoundedView(this.mSource, Utils.EMPTY_BYTES, Utils.EMPTY_BYTES, -1), this.mTransformer);
    }

    private static ViewConstraintException fail() {
        return new ViewConstraintException("Unsupported key");
    }
}

