/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.ReverseView;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.TransformedView;
import org.cojen.tupl.Transformer;
import org.cojen.tupl.UnmodifiableView;
import org.cojen.tupl.View;
import org.cojen.tupl.ViewConstraintException;

abstract class SubView
implements View {
    final View mSource;

    SubView(View source) {
        this.mSource = source;
    }

    @Override
    public byte[] load(Transaction txn, byte[] key) throws IOException {
        return this.inRange(key) ? this.mSource.load(txn, key) : null;
    }

    @Override
    public void store(Transaction txn, byte[] key, byte[] value) throws IOException {
        if (!this.inRange(key)) {
            throw SubView.fail();
        }
        this.mSource.store(txn, key, value);
    }

    @Override
    public byte[] exchange(Transaction txn, byte[] key, byte[] value) throws IOException {
        if (this.inRange(key)) {
            return this.mSource.exchange(txn, key, value);
        }
        throw SubView.fail();
    }

    @Override
    public boolean insert(Transaction txn, byte[] key, byte[] value) throws IOException {
        if (this.inRange(key)) {
            return this.mSource.insert(txn, key, value);
        }
        if (value == null) {
            return true;
        }
        throw SubView.fail();
    }

    @Override
    public boolean replace(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.inRange(key) ? this.mSource.replace(txn, key, value) : false;
    }

    @Override
    public boolean update(Transaction txn, byte[] key, byte[] oldValue, byte[] newValue) throws IOException {
        if (this.inRange(key)) {
            return this.mSource.update(txn, key, oldValue, newValue);
        }
        if (oldValue == null) {
            if (newValue == null) {
                return true;
            }
            throw SubView.fail();
        }
        return false;
    }

    @Override
    public boolean delete(Transaction txn, byte[] key) throws IOException {
        return this.inRange(key) ? this.mSource.delete(txn, key) : false;
    }

    @Override
    public boolean remove(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.inRange(key) ? this.mSource.remove(txn, key, value) : value == null;
    }

    @Override
    public final LockResult lockShared(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        if (this.inRange(key)) {
            return this.mSource.lockShared(txn, key);
        }
        throw SubView.fail();
    }

    @Override
    public final LockResult lockUpgradable(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        if (this.inRange(key)) {
            return this.mSource.lockUpgradable(txn, key);
        }
        throw SubView.fail();
    }

    @Override
    public final LockResult lockExclusive(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        if (this.inRange(key)) {
            return this.mSource.lockExclusive(txn, key);
        }
        throw SubView.fail();
    }

    @Override
    public final LockResult lockCheck(Transaction txn, byte[] key) throws ViewConstraintException {
        if (this.inRange(key)) {
            return this.mSource.lockCheck(txn, key);
        }
        throw SubView.fail();
    }

    @Override
    public View viewTransformed(Transformer transformer) {
        return TransformedView.apply(this, transformer);
    }

    @Override
    public View viewReverse() {
        return new ReverseView(this);
    }

    @Override
    public View viewUnmodifiable() {
        return UnmodifiableView.apply(this);
    }

    @Override
    public boolean isUnmodifiable() {
        return this.mSource.isUnmodifiable();
    }

    abstract boolean inRange(byte[] var1);

    static void prefixCheck(byte[] prefix, int trim) {
        if (prefix == null) {
            throw new NullPointerException("Prefix is null");
        }
        if (trim < 0 | trim > prefix.length) {
            if (trim < 0) {
                throw new IllegalArgumentException("Negative trim");
            }
            throw new IllegalArgumentException("Trim amount is longer than prefix");
        }
    }

    private static ViewConstraintException fail() {
        return new ViewConstraintException("Key is outside allowed range");
    }
}

