/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.ReverseView;
import org.cojen.tupl.Transaction;

final class ReverseCursor
implements Cursor {
    private final Cursor mSource;

    ReverseCursor(Cursor source) {
        this.mSource = source;
    }

    @Override
    public Ordering getOrdering() {
        return this.mSource.getOrdering().reverse();
    }

    @Override
    public Transaction link(Transaction txn) {
        return this.mSource.link(txn);
    }

    @Override
    public Transaction link() {
        return this.mSource.link();
    }

    @Override
    public byte[] key() {
        return this.mSource.key();
    }

    @Override
    public byte[] value() {
        return this.mSource.value();
    }

    @Override
    public boolean autoload(boolean mode) {
        return this.mSource.autoload(mode);
    }

    @Override
    public boolean autoload() {
        return this.mSource.autoload();
    }

    @Override
    public int compareKeyTo(byte[] rkey) {
        return -this.mSource.compareKeyTo(rkey);
    }

    @Override
    public int compareKeyTo(byte[] rkey, int offset, int length) {
        return -this.mSource.compareKeyTo(rkey, offset, length);
    }

    @Override
    public LockResult first() throws IOException {
        return this.mSource.last();
    }

    @Override
    public LockResult last() throws IOException {
        return this.mSource.first();
    }

    @Override
    public LockResult skip(long amount) throws IOException {
        if (amount == Long.MIN_VALUE) {
            LockResult result = this.mSource.skip(Long.MAX_VALUE);
            if (this.mSource.key() == null) {
                return result;
            }
            return this.next();
        }
        return this.mSource.skip(-amount);
    }

    @Override
    public LockResult skip(long amount, byte[] limitKey, boolean inclusive) throws IOException {
        if (amount == Long.MIN_VALUE) {
            LockResult result = this.mSource.skip(Long.MAX_VALUE, limitKey, inclusive);
            if (this.mSource.key() == null) {
                return result;
            }
            return this.next();
        }
        return this.mSource.skip(-amount, limitKey, inclusive);
    }

    @Override
    public LockResult next() throws IOException {
        return this.mSource.previous();
    }

    @Override
    public LockResult nextLe(byte[] limitKey) throws IOException {
        return this.mSource.previousGe(limitKey);
    }

    @Override
    public LockResult nextLt(byte[] limitKey) throws IOException {
        return this.mSource.previousGt(limitKey);
    }

    @Override
    public LockResult previous() throws IOException {
        return this.mSource.next();
    }

    @Override
    public LockResult previousGe(byte[] limitKey) throws IOException {
        return this.mSource.nextLe(limitKey);
    }

    @Override
    public LockResult previousGt(byte[] limitKey) throws IOException {
        return this.mSource.nextLt(limitKey);
    }

    @Override
    public LockResult find(byte[] key) throws IOException {
        return this.mSource.find(key);
    }

    @Override
    public LockResult findGe(byte[] key) throws IOException {
        return this.mSource.findLe(key);
    }

    @Override
    public LockResult findGt(byte[] key) throws IOException {
        return this.mSource.findLt(key);
    }

    @Override
    public LockResult findLe(byte[] key) throws IOException {
        return this.mSource.findGe(key);
    }

    @Override
    public LockResult findLt(byte[] key) throws IOException {
        return this.mSource.findGt(key);
    }

    @Override
    public LockResult findNearby(byte[] key) throws IOException {
        return this.mSource.findNearby(key);
    }

    @Override
    public LockResult random(byte[] lowKey, byte[] highKey) throws IOException {
        return this.mSource.random(ReverseView.appendZero(highKey), ReverseView.appendZero(lowKey));
    }

    @Override
    public LockResult load() throws IOException {
        return this.mSource.load();
    }

    @Override
    public void store(byte[] value) throws IOException {
        this.mSource.store(value);
    }

    @Override
    public void commit(byte[] value) throws IOException {
        this.mSource.commit(value);
    }

    @Override
    public Cursor copy() {
        return new ReverseCursor(this.mSource.copy());
    }

    @Override
    public void reset() {
        this.mSource.reset();
    }
}

