/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.LocalDatabase;
import org.cojen.tupl.LocalTransaction;
import org.cojen.tupl.PendingTxn;
import org.cojen.tupl.PendingTxnWaiter;
import org.cojen.tupl.RedoWriter;
import org.cojen.tupl.ReplRedoEngine;
import org.cojen.tupl.UnmodifiableReplicaException;
import org.cojen.tupl.ext.ReplicationManager;

class ReplRedoWriter
extends RedoWriter {
    final ReplRedoEngine mEngine;
    final ReplicationManager.Writer mReplWriter;
    long mLastCommitPos;
    long mLastCommitTxnId;
    long mConfirmedPos;
    long mConfirmedTxnId;
    private volatile PendingTxnWaiter mPendingWaiter;

    ReplRedoWriter(ReplRedoEngine engine, ReplicationManager.Writer writer) {
        super(4096, 0L);
        this.mEngine = engine;
        this.mReplWriter = writer;
    }

    @Override
    public final long store(long indexId, byte[] key, byte[] value, DurabilityMode mode) throws IOException {
        return super.store(indexId, key, value, DurabilityMode.SYNC);
    }

    @Override
    public final long storeNoLock(long indexId, byte[] key, byte[] value, DurabilityMode mode) throws IOException {
        return super.storeNoLock(indexId, key, value, DurabilityMode.SYNC);
    }

    @Override
    public final long renameIndex(long txnId, long indexId, byte[] newName, DurabilityMode mode) throws IOException {
        return super.renameIndex(txnId, indexId, newName, DurabilityMode.SYNC);
    }

    @Override
    public final long deleteIndex(long txnId, long indexId, DurabilityMode mode) throws IOException {
        return super.deleteIndex(txnId, indexId, DurabilityMode.SYNC);
    }

    @Override
    public final long txnCommitFinal(long txnId, DurabilityMode mode) throws IOException {
        return super.txnCommitFinal(txnId, DurabilityMode.SYNC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void txnCommitSync(LocalTransaction txn, long commitPos) throws IOException {
        ReplicationManager.Writer writer = this.mReplWriter;
        if (writer == null) {
            throw new UnmodifiableReplicaException();
        }
        if (writer.confirm(commitPos)) {
            ReplRedoWriter replRedoWriter = this;
            synchronized (replRedoWriter) {
                if (commitPos > this.mConfirmedPos) {
                    this.mConfirmedPos = commitPos;
                    this.mConfirmedTxnId = txn.txnId();
                }
            }
            return;
        }
        ReplRedoWriter replRedoWriter = this;
        synchronized (replRedoWriter) {
            if (this.mConfirmedPos >= commitPos) {
                return;
            }
        }
        throw this.unmodifiable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void txnCommitPending(PendingTxn pending) throws IOException {
        int action;
        PendingTxnWaiter waiter = this.mPendingWaiter;
        if (waiter == null || (action = waiter.add(pending)) == 4) {
            ReplRedoWriter replRedoWriter = this;
            synchronized (replRedoWriter) {
                waiter = this.mPendingWaiter;
                if (waiter == null || (action = waiter.add(pending)) == 4) {
                    this.mPendingWaiter = waiter = new PendingTxnWaiter(this);
                    action = waiter.add(pending);
                    if (action == 1) {
                        waiter.setName("PendingTxnWaiter-" + waiter.getId());
                        waiter.setDaemon(true);
                        waiter.start();
                    }
                }
            }
        }
        if (action != 1) {
            LocalDatabase db = this.mEngine.mDatabase;
            if (action == 2) {
                pending.commit(db);
            } else if (action == 3) {
                pending.rollback(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void flipped(long commitPos) {
        PendingTxnWaiter waiter;
        ReplRedoWriter replRedoWriter = this;
        synchronized (replRedoWriter) {
            waiter = this.mPendingWaiter;
            if (waiter == null) {
                this.mPendingWaiter = waiter = new PendingTxnWaiter(this);
            }
            waiter.flipped(commitPos);
        }
        waiter.finishAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean confirm(long txnId, long commitPos) {
        block11: {
            ReplicationManager.Writer writer = this.mReplWriter;
            if (writer == null) {
                return false;
            }
            try {
                if (!writer.confirm(commitPos)) break block11;
                ReplRedoWriter replRedoWriter = this;
                synchronized (replRedoWriter) {
                    if (commitPos > this.mConfirmedPos) {
                        this.mConfirmedPos = commitPos;
                        this.mConfirmedTxnId = txnId;
                    }
                }
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ReplRedoWriter replRedoWriter = this;
        synchronized (replRedoWriter) {
            if (this.mConfirmedPos >= commitPos) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final synchronized void close(Throwable cause) throws IOException {
        super.close(cause);
        this.forceAndClose();
    }

    @Override
    public final long encoding() {
        return this.mEngine.mManager.encoding();
    }

    @Override
    final boolean isOpen() {
        return false;
    }

    @Override
    public RedoWriter txnRedoWriter() {
        return this;
    }

    @Override
    boolean shouldCheckpoint(long sizeThreshold) {
        return false;
    }

    @Override
    void checkpointPrepare() throws IOException {
        throw this.fail();
    }

    @Override
    void checkpointSwitch() throws IOException {
        throw this.fail();
    }

    @Override
    long checkpointNumber() {
        throw this.fail();
    }

    @Override
    long checkpointPosition() {
        throw this.fail();
    }

    @Override
    long checkpointTransactionId() {
        throw this.fail();
    }

    @Override
    void checkpointAborted() {
    }

    @Override
    void checkpointStarted() throws IOException {
        throw this.fail();
    }

    @Override
    void checkpointFlushed() throws IOException {
        throw this.fail();
    }

    @Override
    void checkpointFinished() throws IOException {
        throw this.fail();
    }

    @Override
    final void write(byte[] buffer, int len) throws IOException {
        if (len > 0) {
            ReplicationManager.Writer writer = this.mReplWriter;
            if (writer == null) {
                throw new UnmodifiableReplicaException();
            }
            if (writer.write(buffer, 0, len) < 0L) {
                throw this.unmodifiable();
            }
        }
    }

    @Override
    final long writeCommit(byte[] buffer, int len) throws IOException {
        if (len > 0) {
            ReplicationManager.Writer writer = this.mReplWriter;
            if (writer == null) {
                throw new UnmodifiableReplicaException();
            }
            long pos = writer.writeCommit(buffer, 0, len);
            if (pos >= 0L) {
                this.mLastCommitPos = pos;
                this.mLastCommitTxnId = this.lastTransactionId();
                return pos;
            }
            throw this.unmodifiable();
        }
        return 0L;
    }

    @Override
    void force(boolean metadata) throws IOException {
        this.mEngine.mManager.sync();
    }

    @Override
    final void forceAndClose() throws IOException {
        IOException ex;
        block5: {
            ex = null;
            try {
                this.force(false);
            }
            catch (IOException e) {
                ex = e;
            }
            try {
                this.mEngine.mManager.close();
            }
            catch (IOException e) {
                if (ex != null) break block5;
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    @Override
    final void writeTerminator() throws IOException {
    }

    private UnsupportedOperationException fail() {
        return new UnsupportedOperationException();
    }

    private UnmodifiableReplicaException unmodifiable() {
        return this.mEngine.mController.unmodifiable(this.mReplWriter);
    }
}

