/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.Flushable;
import java.io.IOException;
import java.util.Random;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.LocalTransaction;
import org.cojen.tupl.PendingTxn;
import org.cojen.tupl.ShutdownHook;
import org.cojen.tupl.Utils;
import org.cojen.tupl.io.CauseCloseable;

abstract class RedoWriter
implements CauseCloseable,
ShutdownHook,
Flushable {
    private final byte[] mBuffer;
    private int mBufferPos;
    private long mLastTxnId;
    private boolean mAlwaysFlush;
    volatile Throwable mCause;

    RedoWriter(int bufferSize, long initialTxnId) {
        this.mBuffer = new byte[bufferSize];
        this.mLastTxnId = initialTxnId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long store(long indexId, byte[] key, byte[] value, DurabilityMode mode) throws IOException {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        RedoWriter redoWriter = this;
        synchronized (redoWriter) {
            if (value == null) {
                this.writeOp((byte)18, indexId);
                this.writeUnsignedVarInt(key.length);
                this.writeBytes(key);
            } else {
                this.writeOp((byte)16, indexId);
                this.writeUnsignedVarInt(key.length);
                this.writeBytes(key);
                this.writeUnsignedVarInt(value.length);
                this.writeBytes(value);
            }
            this.writeTerminator();
            return this.commitFlush(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long storeNoLock(long indexId, byte[] key, byte[] value, DurabilityMode mode) throws IOException {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        RedoWriter redoWriter = this;
        synchronized (redoWriter) {
            if (value == null) {
                this.writeOp((byte)19, indexId);
                this.writeUnsignedVarInt(key.length);
                this.writeBytes(key);
            } else {
                this.writeOp((byte)17, indexId);
                this.writeUnsignedVarInt(key.length);
                this.writeBytes(key);
                this.writeUnsignedVarInt(value.length);
                this.writeBytes(value);
            }
            this.writeTerminator();
            return this.commitFlush(mode);
        }
    }

    public synchronized long renameIndex(long txnId, long indexId, byte[] newName, DurabilityMode mode) throws IOException {
        this.writeTxnOp((byte)21, txnId);
        this.writeLongLE(indexId);
        this.writeUnsignedVarInt(newName.length);
        this.writeBytes(newName);
        this.writeTerminator();
        return this.commitFlush(mode);
    }

    public synchronized long deleteIndex(long txnId, long indexId, DurabilityMode mode) throws IOException {
        this.writeTxnOp((byte)22, txnId);
        this.writeLongLE(indexId);
        this.writeTerminator();
        return this.commitFlush(mode);
    }

    public synchronized void reset() throws IOException {
        this.writeOp((byte)1);
        this.mLastTxnId = 0L;
        this.writeTerminator();
    }

    public synchronized void txnEnter(long txnId) throws IOException {
        this.writeTxnOp((byte)24, txnId);
        this.writeTerminator();
    }

    public synchronized void txnRollback(long txnId) throws IOException {
        this.writeTxnOp((byte)25, txnId);
        this.writeTerminator();
    }

    public synchronized void txnRollbackFinal(long txnId) throws IOException {
        this.writeTxnOp((byte)26, txnId);
        this.writeTerminator();
    }

    public synchronized void txnCommit(long txnId) throws IOException {
        this.writeTxnOp((byte)27, txnId);
        this.writeTerminator();
    }

    public synchronized long txnCommitFinal(long txnId, DurabilityMode mode) throws IOException {
        this.writeTxnOp((byte)28, txnId);
        this.writeTerminator();
        return this.commitFlush(mode);
    }

    public void txnCommitSync(LocalTransaction txn, long commitPos) throws IOException {
        this.sync(false);
    }

    public void txnCommitPending(PendingTxn pending) throws IOException {
        throw new UnsupportedOperationException();
    }

    public synchronized void txnStore(byte op, long txnId, long indexId, byte[] key, byte[] value) throws IOException {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        this.writeTxnOp(op, txnId);
        this.writeLongLE(indexId);
        this.writeUnsignedVarInt(key.length);
        this.writeBytes(key);
        this.writeUnsignedVarInt(value.length);
        this.writeBytes(value);
        this.writeTerminator();
    }

    public synchronized long txnStoreCommitFinal(long txnId, long indexId, byte[] key, byte[] value, DurabilityMode mode) throws IOException {
        this.txnStore((byte)35, txnId, indexId, key, value);
        return this.commitFlush(mode);
    }

    public synchronized void txnDelete(byte op, long txnId, long indexId, byte[] key) throws IOException {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        this.writeTxnOp(op, txnId);
        this.writeLongLE(indexId);
        this.writeUnsignedVarInt(key.length);
        this.writeBytes(key);
        this.writeTerminator();
    }

    public synchronized long txnDeleteCommitFinal(long txnId, long indexId, byte[] key, DurabilityMode mode) throws IOException {
        this.txnDelete((byte)39, txnId, indexId, key);
        return this.commitFlush(mode);
    }

    public synchronized void txnCustom(long txnId, byte[] message) throws IOException {
        if (message == null) {
            throw new NullPointerException("Message is null");
        }
        this.writeTxnOp((byte)-128, txnId);
        this.writeUnsignedVarInt(message.length);
        this.writeBytes(message);
        this.writeTerminator();
    }

    public synchronized void txnCustomLock(long txnId, byte[] message, long indexId, byte[] key) throws IOException {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (message == null) {
            throw new NullPointerException("Message is null");
        }
        this.writeTxnOp((byte)-127, txnId);
        this.writeLongLE(indexId);
        this.writeUnsignedVarInt(key.length);
        this.writeBytes(key);
        this.writeUnsignedVarInt(message.length);
        this.writeBytes(message);
        this.writeTerminator();
    }

    public synchronized void timestamp() throws IOException {
        this.writeOp((byte)2, System.currentTimeMillis());
        this.writeTerminator();
    }

    public synchronized void endFile() throws IOException {
        this.writeOp((byte)5, System.currentTimeMillis());
        this.writeTerminator();
        this.flush();
    }

    public synchronized void nopRandom() throws IOException {
        this.writeOp((byte)6, new Random().nextLong());
        this.writeTerminator();
        this.flush();
    }

    @Override
    public synchronized void flush() throws IOException {
        this.doFlush();
    }

    public void flushSync(boolean metadata) throws IOException {
        this.flush();
        this.sync(metadata);
    }

    @Override
    public final synchronized void close() throws IOException {
        this.close(null);
    }

    @Override
    public synchronized void close(Throwable cause) throws IOException {
        if (cause != null) {
            this.mCause = cause;
        }
        this.shutdown((byte)4);
    }

    @Override
    public void shutdown() {
        try {
            this.shutdown((byte)3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(byte op) throws IOException {
        RedoWriter redoWriter = this;
        synchronized (redoWriter) {
            this.mAlwaysFlush = true;
            if (!this.isOpen()) {
                return;
            }
            this.writeOp(op, System.currentTimeMillis());
            this.writeTerminator();
            this.doFlush();
            if (op == 4) {
                try {
                    this.forceAndClose();
                }
                catch (IOException e) {
                    throw Utils.rethrow(e, this.mCause);
                }
                return;
            }
        }
        this.force(true);
    }

    public abstract long encoding();

    public abstract RedoWriter txnRedoWriter();

    abstract boolean isOpen();

    abstract boolean shouldCheckpoint(long var1);

    abstract void checkpointPrepare() throws IOException;

    abstract void checkpointSwitch() throws IOException;

    abstract long checkpointNumber() throws IOException;

    abstract long checkpointPosition() throws IOException;

    abstract long checkpointTransactionId() throws IOException;

    abstract void checkpointAborted();

    abstract void checkpointStarted() throws IOException;

    abstract void checkpointFlushed() throws IOException;

    abstract void checkpointFinished() throws IOException;

    void opWriteCheck() throws IOException {
    }

    long adjustTransactionId(long txnId) {
        return txnId;
    }

    abstract void write(byte[] var1, int var2) throws IOException;

    abstract long writeCommit(byte[] var1, int var2) throws IOException;

    abstract void force(boolean var1) throws IOException;

    abstract void forceAndClose() throws IOException;

    abstract void writeTerminator() throws IOException;

    synchronized void clearAndReset() throws IOException {
        this.mBufferPos = 0;
        this.reset();
    }

    long lastTransactionId() {
        return this.mLastTxnId;
    }

    void writeIntLE(int v) throws IOException {
        int pos = this.mBufferPos;
        byte[] buffer = this.mBuffer;
        if (pos > buffer.length - 4) {
            this.doFlush(buffer, pos);
            pos = 0;
        }
        Utils.encodeIntLE(buffer, pos, v);
        this.mBufferPos = pos + 4;
    }

    private void writeLongLE(long v) throws IOException {
        int pos = this.mBufferPos;
        byte[] buffer = this.mBuffer;
        if (pos > buffer.length - 8) {
            this.doFlush(buffer, pos);
            pos = 0;
        }
        Utils.encodeLongLE(buffer, pos, v);
        this.mBufferPos = pos + 8;
    }

    private void writeUnsignedVarInt(int v) throws IOException {
        int pos = this.mBufferPos;
        byte[] buffer = this.mBuffer;
        if (pos > buffer.length - 5) {
            this.doFlush(buffer, pos);
            pos = 0;
        }
        this.mBufferPos = Utils.encodeUnsignedVarInt(buffer, pos, v);
    }

    private void writeBytes(byte[] bytes) throws IOException {
        this.writeBytes(bytes, 0, bytes.length);
    }

    private void writeBytes(byte[] bytes, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        byte[] buffer = this.mBuffer;
        int pos = this.mBufferPos;
        while (true) {
            if (pos <= buffer.length - length) {
                System.arraycopy(bytes, offset, buffer, pos, length);
                this.mBufferPos = pos + length;
                return;
            }
            int remaining = buffer.length - pos;
            System.arraycopy(bytes, offset, buffer, pos, remaining);
            this.doFlush(buffer, buffer.length);
            pos = 0;
            offset += remaining;
            length -= remaining;
        }
    }

    public void writeOp(byte op) throws IOException {
        this.opWriteCheck();
        byte[] buffer = this.mBuffer;
        int pos = this.mBufferPos;
        if (pos >= buffer.length - 1) {
            this.doFlush(buffer, pos);
            pos = 0;
        }
        buffer[pos] = op;
        this.mBufferPos = pos + 1;
    }

    private void writeOp(byte op, long operand) throws IOException {
        this.opWriteCheck();
        byte[] buffer = this.mBuffer;
        int pos = this.mBufferPos;
        if (pos >= buffer.length - 9) {
            this.doFlush(buffer, pos);
            pos = 0;
        }
        buffer[pos] = op;
        Utils.encodeLongLE(buffer, pos + 1, operand);
        this.mBufferPos = pos + 9;
    }

    private void writeTxnOp(byte op, long txnId) throws IOException {
        this.opWriteCheck();
        byte[] buffer = this.mBuffer;
        int pos = this.mBufferPos;
        if (pos >= buffer.length - 10) {
            this.doFlush(buffer, pos);
            pos = 0;
        }
        buffer[pos] = op;
        this.mBufferPos = Utils.encodeSignedVarLong(buffer, pos + 1, txnId - this.mLastTxnId);
        this.mLastTxnId = txnId;
    }

    private void doFlush() throws IOException {
        this.doFlush(this.mBuffer, this.mBufferPos);
    }

    private void doFlush(byte[] buffer, int len) throws IOException {
        try {
            this.write(buffer, len);
            this.mBufferPos = 0;
        }
        catch (IOException e) {
            throw Utils.rethrow(e, this.mCause);
        }
    }

    private void sync(boolean metadata) throws IOException {
        try {
            this.force(metadata);
        }
        catch (IOException e) {
            throw Utils.rethrow(e, this.mCause);
        }
    }

    private long commitFlush(DurabilityMode mode) throws IOException {
        try {
            switch (mode) {
                default: {
                    return 0L;
                }
                case NO_FLUSH: {
                    if (this.mAlwaysFlush) {
                        this.doCommitFlush();
                    }
                    return 0L;
                }
                case SYNC: {
                    return this.doCommitFlush();
                }
                case NO_SYNC: 
            }
            this.doCommitFlush();
            return 0L;
        }
        catch (IOException e) {
            throw Utils.rethrow(e, this.mCause);
        }
    }

    private long doCommitFlush() throws IOException {
        int len = this.mBufferPos;
        this.mBufferPos = 0;
        return this.writeCommit(this.mBuffer, len);
    }
}

