/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.util.concurrent.atomic.AtomicInteger;
import org.cojen.tupl.BasicPageCache;
import org.cojen.tupl.PageCache;
import org.cojen.tupl.Utils;

final class PartitionedPageCache
implements PageCache {
    private final PageCache[] mPartitions;
    private final long mPartitionShift;
    private final long mCapacity;
    private final long mMaxEntryCount;

    PartitionedPageCache(long capacity, int pageSize) {
        this(capacity, pageSize, Runtime.getRuntime().availableProcessors() * 4);
    }

    PartitionedPageCache(long capacity, final int pageSize, int minPartitions) {
        block10: {
            capacity = Math.min(capacity, 0x1000000000000000L);
            minPartitions = (int)Math.max((long)minPartitions, (capacity + 0x3FFFFFFFL) / 0x40000000L);
            int pcount = Utils.roundUpPower2(minPartitions);
            double psize = (double)capacity / (double)pcount;
            final int[] pcapacities = new int[pcount];
            capacity = 0L;
            long maxEntryCount = 0L;
            for (int i = 0; i < pcount; ++i) {
                int pcapacity = (int)((long)((double)(i + 1) * psize) - capacity);
                int pentryCount = BasicPageCache.entryCountFor(pcapacity, pageSize);
                pcapacities[i] = BasicPageCache.capacityFor(pentryCount, pageSize);
                capacity += (long)pcapacities[i];
                maxEntryCount += (long)pentryCount;
            }
            this.mPartitions = new PageCache[pcount];
            this.mPartitionShift = Long.numberOfLeadingZeros(pcount - 1);
            this.mCapacity = capacity;
            this.mMaxEntryCount = maxEntryCount;
            int procCount = Runtime.getRuntime().availableProcessors();
            try {
                int i;
                if (capacity <= 0x1000000L || procCount <= 1) {
                    int i2 = pcount;
                    while (--i2 >= 0) {
                        this.mPartitions[i2] = new BasicPageCache(pcapacities[i2], pageSize);
                    }
                    break block10;
                }
                final AtomicInteger slot = new AtomicInteger(pcount);
                class Init
                extends Thread {
                    volatile Throwable mEx;

                    Init() {
                    }

                    @Override
                    public void run() {
                        try {
                            int i;
                            while ((i = slot.get()) > 0) {
                                if (!slot.compareAndSet(i--, i)) continue;
                                ((PartitionedPageCache)PartitionedPageCache.this).mPartitions[i] = new BasicPageCache(pcapacities[i], pageSize);
                            }
                        }
                        catch (Throwable e) {
                            this.mEx = e;
                        }
                    }
                }
                Init[] inits = new Init[procCount];
                for (i = 0; i < inits.length && slot.get() > 0; ++i) {
                    inits[i] = new Init();
                    inits[i].start();
                }
                try {
                    Init init;
                    for (i = 0; i < inits.length; ++i) {
                        init = inits[i];
                        if (init == null) continue;
                        init.join();
                    }
                    for (i = 0; i < inits.length; ++i) {
                        Throwable e;
                        init = inits[i];
                        if (init == null || (e = init.mEx) == null) continue;
                        throw e;
                    }
                }
                catch (Throwable e) {
                    throw Utils.rethrow(e);
                }
            }
            catch (Throwable e) {
                this.close();
                throw e;
            }
        }
    }

    @Override
    public boolean add(long pageId, byte[] page, int offset, boolean canEvict) {
        pageId = Utils.scramble(pageId);
        return this.mPartitions[(int)(pageId >>> (int)this.mPartitionShift)].add(pageId, page, offset, canEvict);
    }

    @Override
    public boolean add(long pageId, long pagePtr, int offset, boolean canEvict) {
        pageId = Utils.scramble(pageId);
        return this.mPartitions[(int)(pageId >>> (int)this.mPartitionShift)].add(pageId, pagePtr, offset, canEvict);
    }

    @Override
    public boolean copy(long pageId, int start, byte[] page, int offset) {
        pageId = Utils.scramble(pageId);
        return this.mPartitions[(int)(pageId >>> (int)this.mPartitionShift)].copy(pageId, start, page, offset);
    }

    @Override
    public boolean copy(long pageId, int start, long pagePtr, int offset) {
        pageId = Utils.scramble(pageId);
        return this.mPartitions[(int)(pageId >>> (int)this.mPartitionShift)].copy(pageId, start, pagePtr, offset);
    }

    @Override
    public boolean remove(long pageId, byte[] page, int offset, int length) {
        pageId = Utils.scramble(pageId);
        return this.mPartitions[(int)(pageId >>> (int)this.mPartitionShift)].remove(pageId, page, offset, length);
    }

    @Override
    public boolean remove(long pageId, long pagePtr, int offset, int length) {
        pageId = Utils.scramble(pageId);
        return this.mPartitions[(int)(pageId >>> (int)this.mPartitionShift)].remove(pageId, pagePtr, offset, length);
    }

    @Override
    public long capacity() {
        return this.mCapacity;
    }

    @Override
    public long maxEntryCount() {
        return this.mMaxEntryCount;
    }

    @Override
    public void close() {
        for (PageCache cache : this.mPartitions) {
            if (cache == null) continue;
            cache.close();
        }
    }
}

