/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PageAccessTransformer {
    private static final int STATE_NORMAL = 0;
    private static final int STATE_DISABLE = 1;
    private static final int STATE_ENABLE = 2;
    private int mState;
    private final Pattern mDisablePattern = Pattern.compile("\\s+");
    private final File mSrc;
    private final File mDst;
    private Map<String, Pattern> mNames;

    public static void main(String[] args) throws Exception {
        File src = new File(args[0]);
        File dst = new File(args[1]);
        PageAccessTransformer pa = new PageAccessTransformer(src, dst);
        pa.findFiles();
        pa.transform();
    }

    PageAccessTransformer(File src, File dst) {
        PageAccessTransformer.dirCheck(src);
        PageAccessTransformer.dirCheck(dst);
        this.mSrc = src;
        this.mDst = dst;
    }

    private static void dirCheck(File dir) {
        if (dir.exists() && !dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + dir);
        }
    }

    void findFiles() throws IOException {
        HashMap<String, Pattern> names = new HashMap<String, Pattern>();
        File[] files = this.mSrc.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.isFile() || !PageAccessTransformer.requiresTransform(f)) continue;
                String name = f.getName();
                name = name.substring(0, name.length() - 5);
                names.put(name, Pattern.compile("\\b" + name + "\\b"));
            }
        }
        this.mNames = names;
    }

    Collection<String> transform() throws IOException {
        ArrayList<String> all = new ArrayList<String>(this.mNames.size());
        for (String name : this.mNames.keySet()) {
            String newName = "_" + name + ".java";
            this.transform(new File(this.mSrc, name + ".java"), new File(this.mDst, newName));
            all.add(newName);
        }
        return all;
    }

    private void transform(File src, File dst) throws IOException {
        try (BufferedReader in = new BufferedReader(new FileReader(src));){
            dst.getParentFile().mkdirs();
            try (BufferedWriter out = new BufferedWriter(new FileWriter(dst));){
                String line;
                this.mState = 0;
                while ((line = in.readLine()) != null) {
                    int index = line.indexOf("@author ");
                    if ((line = index > 0 ? line.substring(0, index + 8) + "Generated by PageAccessTransformer from " + src.getName() : this.transform(line)) == null) continue;
                    out.write(line);
                    out.newLine();
                }
            }
        }
    }

    private String transform(String line) {
        line = this.replaceNames(line);
        while (true) {
            int index;
            if ((index = line.indexOf("/*P*/ ")) < 0) {
                if (this.mState == 1) {
                    Matcher m = this.mDisablePattern.matcher(line);
                    if (m.find()) {
                        line = m.group() + m.replaceFirst("// ");
                    }
                } else {
                    index = line.indexOf("PageOps");
                    if (!(index < 0 || index >= 6 && line.regionMatches(index - 6, "Direct", 0, 6))) {
                        line = line.substring(0, index) + "Direct" + line.substring(index);
                    }
                }
                return line;
            }
            int typeIndex = index + 6;
            if (line.indexOf("byte[]", typeIndex) == typeIndex) {
                line = line.substring(0, index) + "long" + line.substring(typeIndex + 6);
                continue;
            }
            if (line.indexOf("// ", typeIndex) != typeIndex) break;
            int tagIndex = typeIndex + 3;
            if (tagIndex < line.length()) {
                switch (line.charAt(tagIndex)) {
                    case '[': {
                        if (this.mState != 0) {
                            throw new IllegalStateException();
                        }
                        this.mState = ++tagIndex < line.length() && line.charAt(tagIndex) == '|' ? 2 : 1;
                        return line;
                    }
                    case '|': {
                        if (this.mState != 1) {
                            throw new IllegalStateException();
                        }
                        this.mState = 2;
                        return line;
                    }
                    case ']': {
                        if (this.mState == 0) {
                            throw new IllegalStateException();
                        }
                        this.mState = 0;
                        return line;
                    }
                }
            }
            if (this.mState != 2) break;
            line = line.substring(0, index) + line.substring(tagIndex);
        }
        return line;
    }

    private String replaceNames(String line) {
        for (Map.Entry<String, Pattern> e : this.mNames.entrySet()) {
            line = e.getValue().matcher(line).replaceAll("_" + e.getKey());
        }
        return line;
    }

    private static boolean requiresTransform(File file) throws IOException {
        String name = file.getName();
        if (!name.endsWith(".java") || name.equals("PageAccessTransformer.java") || name.startsWith("_") || name.endsWith("PageOps.java")) {
            return false;
        }
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = in.readLine()) != null) {
                if (line.indexOf("/*P*/") < 0) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }
}

