/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.LocalDatabase;
import org.cojen.tupl.Node;
import org.cojen.tupl.PageOps;
import org.cojen.tupl.util.Latch;

final class NodeUsageList
extends Latch {
    static final int MODE_UNEVICTABLE = 1;
    static final int MODE_NO_EVICT = 2;
    final transient LocalDatabase mDatabase;
    private final int mPageSize;
    private int mMaxSize;
    private int mSize;
    private Node mMostRecentlyUsed;
    private Node mLeastRecentlyUsed;

    NodeUsageList(LocalDatabase db, int maxSize) {
        this.mDatabase = db;
        this.mPageSize = db.pageSize();
        this.acquireExclusive();
        this.mMaxSize = maxSize;
        this.releaseExclusive();
    }

    int pageSize() {
        return this.mPageSize;
    }

    void initialize(Object arena, int min) throws DatabaseException, OutOfMemoryError {
        min = Math.max(min, 2);
        while (--min >= 0) {
            this.acquireExclusive();
            if (this.mSize >= this.mMaxSize) {
                this.releaseExclusive();
                break;
            }
            this.doAllocLatchedNode(arena, 0).releaseExclusive();
        }
    }

    int size() {
        this.acquireShared();
        int size = this.mSize;
        this.releaseShared();
        return size;
    }

    Node tryAllocLatchedNode(int trial, int mode) throws IOException {
        this.acquireExclusive();
        int max = this.mMaxSize;
        if (max != 0) {
            if (this.mSize < max && (trial > 1 || this.mLeastRecentlyUsed == null || this.mLeastRecentlyUsed.mMoreUsed == null)) {
                return this.doAllocLatchedNode(null, mode);
            }
            if ((mode & 1) == 0 || this.mLeastRecentlyUsed.mMoreUsed != this.mMostRecentlyUsed) {
                do {
                    Node node = this.mLeastRecentlyUsed;
                    this.mLeastRecentlyUsed = node.mMoreUsed;
                    node.mMoreUsed.mLessUsed = null;
                    node.mMoreUsed = null;
                    node.mLessUsed = this.mMostRecentlyUsed;
                    this.mMostRecentlyUsed.mMoreUsed = node;
                    this.mMostRecentlyUsed = node;
                    if (!node.tryAcquireExclusive()) continue;
                    if (trial == 1) {
                        if (node.mCachedState != 0) {
                            if (this.mSize < this.mMaxSize) {
                                node.releaseExclusive();
                                return this.doAllocLatchedNode(null, mode);
                            }
                            if ((mode & 2) != 0) {
                                node.releaseExclusive();
                                break;
                            }
                        }
                        this.releaseExclusive();
                        if (node.evict(this.mDatabase)) {
                            if ((mode & 1) != 0) {
                                node.mUsageList.makeUnevictable(node);
                            }
                            return node;
                        }
                        this.acquireExclusive();
                        if (this.mMaxSize != 0) continue;
                        break;
                    }
                    if ((mode & 2) != 0) {
                        if (node.mCachedState == 0) continue;
                        node.releaseExclusive();
                        break;
                    }
                    try {
                        if (node.evict(this.mDatabase)) {
                            if ((mode & 1) != 0) {
                                NodeUsageList usageList = node.mUsageList;
                                if (usageList == this) {
                                    this.doMakeUnevictable(node);
                                } else {
                                    this.releaseExclusive();
                                    usageList.makeUnevictable(node);
                                    return node;
                                }
                            }
                            this.releaseExclusive();
                            return node;
                        }
                    }
                    catch (Throwable e) {
                        this.releaseExclusive();
                        throw e;
                    }
                } while (--max > 0);
            }
        }
        this.releaseExclusive();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node doAllocLatchedNode(Object arena, int mode) throws DatabaseException {
        try {
            this.mDatabase.checkClosed();
            byte[] page = PageOps.p_calloc(arena, this.mPageSize);
            Node node = new Node(this, page);
            node.acquireExclusive();
            ++this.mSize;
            if ((mode & 1) == 0) {
                node.mLessUsed = this.mMostRecentlyUsed;
                if (node.mLessUsed == null) {
                    this.mLeastRecentlyUsed = node;
                } else {
                    this.mMostRecentlyUsed.mMoreUsed = node;
                }
                this.mMostRecentlyUsed = node;
            }
            Node node2 = node;
            return node2;
        }
        finally {
            this.releaseExclusive();
        }
    }

    void used(Node node) {
        if (this.tryAcquireExclusive()) {
            Node moreUsed = node.mMoreUsed;
            if (moreUsed != null) {
                Node lessUsed = node.mLessUsed;
                moreUsed.mLessUsed = lessUsed;
                if (moreUsed.mLessUsed == null) {
                    this.mLeastRecentlyUsed = moreUsed;
                } else {
                    lessUsed.mMoreUsed = moreUsed;
                }
                node.mMoreUsed = null;
                node.mLessUsed = this.mMostRecentlyUsed;
                this.mMostRecentlyUsed.mMoreUsed = node;
                this.mMostRecentlyUsed = node;
            }
            this.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unused(Node node) {
        try {
            this.acquireExclusive();
        }
        catch (Throwable e) {
            node.releaseExclusive();
            throw e;
        }
        try {
            if (this.mMaxSize == 0) {
                return;
            }
            Node lessUsed = node.mLessUsed;
            if (lessUsed == null) {
                if (node.mMoreUsed != null) {
                    return;
                }
            } else {
                Node moreUsed = node.mMoreUsed;
                lessUsed.mMoreUsed = moreUsed;
                if (lessUsed.mMoreUsed == null) {
                    this.mMostRecentlyUsed = lessUsed;
                } else {
                    moreUsed.mLessUsed = lessUsed;
                }
                node.mLessUsed = null;
            }
            node.mMoreUsed = this.mLeastRecentlyUsed;
            this.mLeastRecentlyUsed.mLessUsed = node;
            this.mLeastRecentlyUsed = node;
        }
        finally {
            node.releaseExclusive();
            this.releaseExclusive();
        }
    }

    void makeEvictable(Node node) {
        this.acquireExclusive();
        try {
            if (this.mMaxSize != 0 && node.mMoreUsed == null && node.mLessUsed == null) {
                node.mLessUsed = this.mMostRecentlyUsed;
                this.mMostRecentlyUsed.mMoreUsed = node;
                this.mMostRecentlyUsed = node;
            }
        }
        finally {
            this.releaseExclusive();
        }
    }

    void makeEvictableNow(Node node) {
        this.acquireExclusive();
        try {
            if (this.mMaxSize != 0 && node.mMoreUsed == null && node.mLessUsed == null) {
                node.mMoreUsed = this.mLeastRecentlyUsed;
                this.mLeastRecentlyUsed.mLessUsed = node;
                this.mLeastRecentlyUsed = node;
            }
        }
        finally {
            this.releaseExclusive();
        }
    }

    void makeUnevictable(Node node) {
        this.acquireExclusive();
        try {
            if (this.mMaxSize != 0) {
                this.doMakeUnevictable(node);
            }
        }
        finally {
            this.releaseExclusive();
        }
    }

    private void doMakeUnevictable(Node node) {
        Node lessUsed = node.mLessUsed;
        Node moreUsed = node.mMoreUsed;
        if (lessUsed == null) {
            this.mLeastRecentlyUsed = moreUsed;
            moreUsed.mLessUsed = null;
        } else if (moreUsed == null) {
            this.mMostRecentlyUsed = lessUsed;
            lessUsed.mMoreUsed = null;
        } else {
            lessUsed.mMoreUsed = moreUsed;
            moreUsed.mLessUsed = lessUsed;
        }
        node.mMoreUsed = null;
        node.mLessUsed = null;
    }

    void delete() {
        this.acquireExclusive();
        try {
            this.mMaxSize = 0;
            Node node = this.mLeastRecentlyUsed;
            this.mLeastRecentlyUsed = null;
            this.mMostRecentlyUsed = null;
            while (node != null) {
                Node next = node.mMoreUsed;
                node.mLessUsed = null;
                node.mMoreUsed = null;
                node.delete(this.mDatabase);
                node = next;
            }
        }
        finally {
            this.releaseExclusive();
        }
    }
}

