/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.cojen.tupl.DatabaseException;

final class LockedFile
implements Closeable {
    private final RandomAccessFile mRaf;

    LockedFile(File file, boolean readOnly) throws IOException {
        RandomAccessFile raf;
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            raf = new RandomAccessFile(file, readOnly ? "r" : "rw");
            FileLock lock = raf.getChannel().tryLock(0L, Long.MAX_VALUE, readOnly);
            if (lock == null) {
                throw new DatabaseException("Database is open and locked by another process");
            }
        }
        catch (FileNotFoundException e) {
            if (readOnly) {
                raf = null;
            }
            throw e;
        }
        catch (OverlappingFileLockException e) {
            throw new DatabaseException("Database is already open by current process");
        }
        this.mRaf = raf;
    }

    @Override
    public void close() throws IOException {
        RandomAccessFile raf = this.mRaf;
        if (raf != null) {
            raf.close();
        }
    }
}

