/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.util.Arrays;
import org.cojen.tupl.Utils;

abstract class LHashTable<E extends Entry<E>> {
    private static final float LOAD_FACTOR = 0.75f;
    private E[] mEntries;
    private int mSize;
    private int mGrowThreshold;

    LHashTable(int capacity) {
        this.clear(capacity);
    }

    public final int size() {
        return this.mSize;
    }

    public final void clear(int capacity) {
        if (capacity <= 0) {
            capacity = 1;
        }
        capacity = Utils.roundUpPower2(capacity);
        Object[] entries = this.mEntries;
        if (entries != null && entries.length == capacity) {
            Arrays.fill(entries, null);
        } else {
            this.mEntries = new Entry[capacity];
            this.mGrowThreshold = (int)((float)capacity * 0.75f);
        }
        this.mSize = 0;
    }

    public final E get(long key) {
        E[] entries = this.mEntries;
        E e = entries[(int)key & entries.length - 1];
        while (e != null) {
            if (((Entry)e).key == key) {
                return e;
            }
            e = ((Entry)e).next;
        }
        return null;
    }

    public final E insert(long key) {
        E[] entries = this.mEntries;
        int index = (int)key & entries.length - 1;
        E e = entries[index];
        while (e != null) {
            if (((Entry)e).key == key) {
                return e;
            }
            e = ((Entry)e).next;
        }
        if (this.grow()) {
            entries = this.mEntries;
            index = (int)key & entries.length - 1;
        }
        ++this.mSize;
        entries[index] = this.newEntry(key, entries[index]);
        return entries[index];
    }

    public final E replace(long key) {
        E[] entries = this.mEntries;
        int index = (int)key & entries.length - 1;
        E e = entries[index];
        Object prev = null;
        while (e != null) {
            if (((Entry)e).key == key) {
                if (prev == null) {
                    entries[index] = ((Entry)e).next;
                } else {
                    prev.next = ((Entry)e).next;
                }
                entries[index] = this.newEntry(key, entries[index]);
                return entries[index];
            }
            prev = e;
            e = ((Entry)e).next;
        }
        if (this.grow()) {
            entries = this.mEntries;
            index = (int)key & entries.length - 1;
        }
        ++this.mSize;
        entries[index] = this.newEntry(key, entries[index]);
        return entries[index];
    }

    public final E remove(long key) {
        E[] entries = this.mEntries;
        int index = (int)key & entries.length - 1;
        E e = entries[index];
        Object prev = null;
        while (e != null) {
            if (((Entry)e).key == key) {
                if (prev == null) {
                    entries[index] = ((Entry)e).next;
                } else {
                    prev.next = ((Entry)e).next;
                }
                --this.mSize;
                return e;
            }
            prev = e;
            e = ((Entry)e).next;
        }
        return null;
    }

    public <X extends Exception> void traverse(Visitor<E, X> v) throws X {
        E[] entries = this.mEntries;
        for (int i = 0; i < entries.length; ++i) {
            E e = entries[i];
            Object prev = null;
            while (e != null) {
                Object next = ((Entry)e).next;
                if (v.visit(e)) {
                    if (prev == null) {
                        entries[i] = next;
                    } else {
                        prev.next = next;
                    }
                    --this.mSize;
                } else {
                    prev = e;
                }
                e = next;
            }
        }
    }

    protected abstract E newEntry();

    private E newEntry(long key, E next) {
        E e = this.newEntry();
        ((Entry)e).key = key;
        ((Entry)e).next = next;
        return e;
    }

    private boolean grow() {
        if (this.mSize < this.mGrowThreshold) {
            return false;
        }
        E[] entries = this.mEntries;
        int capacity = entries.length << 1;
        if (capacity == 0) {
            capacity = 1;
        }
        Entry[] newEntries = new Entry[capacity];
        int newMask = capacity - 1;
        int i = entries.length;
        while (--i >= 0) {
            E e = entries[i];
            while (e != null) {
                Object next = ((Entry)e).next;
                int ix = (int)((Entry)e).key & newMask;
                ((Entry)e).next = newEntries[ix];
                newEntries[ix] = e;
                e = next;
            }
        }
        this.mEntries = newEntries;
        this.mGrowThreshold = (int)((float)capacity * 0.75f);
        return true;
    }

    @FunctionalInterface
    public static interface Visitor<E extends Entry<E>, X extends Exception> {
        public boolean visit(E var1) throws X;
    }

    public static class Entry<E extends Entry<E>> {
        public long key;
        E next;
    }

    public static final class Int
    extends LHashTable<IntEntry> {
        Int(int capacity) {
            super(capacity);
        }

        @Override
        protected IntEntry newEntry() {
            return new IntEntry();
        }
    }

    public static final class IntEntry
    extends Entry<IntEntry> {
        public int value;
    }

    public static final class Obj<V>
    extends LHashTable<ObjEntry<V>> {
        Obj(int capacity) {
            super(capacity);
        }

        public V getValue(long key) {
            ObjEntry entry = (ObjEntry)this.get(key);
            return entry == null ? null : (V)entry.value;
        }

        public V removeValue(long key) {
            ObjEntry entry = (ObjEntry)this.remove(key);
            return entry == null ? null : (V)entry.value;
        }

        @Override
        protected ObjEntry<V> newEntry() {
            return new ObjEntry();
        }
    }

    public static final class ObjEntry<V>
    extends Entry<ObjEntry<V>> {
        public V value;
    }
}

