/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.CRC32;
import org.cojen.tupl.Hasher;
import org.cojen.tupl.IntegerRef;
import org.cojen.tupl.Utils;
import org.cojen.tupl.io.DirectAccess;
import org.cojen.tupl.io.MappedPageArray;
import sun.misc.Unsafe;

final class DirectPageOps {
    static final int NODE_OVERHEAD = 76;
    private static final Unsafe UNSAFE;
    private static final long BYTE_ARRAY_OFFSET;
    private static final long CLOSED_TREE_PAGE;
    private static final long NON_TREE_PAGE;
    private static final Method CRC_BUFFER_UPDATE_METHOD;
    private static volatile Arena[] cArenas;

    DirectPageOps() {
    }

    private static long newEmptyPage() {
        long empty = DirectPageOps.p_calloc(12);
        DirectPageOps.p_bytePut(empty, 0, -118);
        DirectPageOps.p_shortPutLE(empty, 4, 12);
        DirectPageOps.p_shortPutLE(empty, 6, 11);
        DirectPageOps.p_shortPutLE(empty, 8, 12);
        DirectPageOps.p_shortPutLE(empty, 10, 10);
        return empty;
    }

    static long p_null() {
        return 0L;
    }

    static long p_closedTreePage() {
        return CLOSED_TREE_PAGE;
    }

    static long p_nonTreePage() {
        return NON_TREE_PAGE;
    }

    static long p_alloc(int size) {
        return UNSAFE.allocateMemory(size);
    }

    static long p_calloc(int size) {
        long ptr = DirectPageOps.p_alloc(size);
        UNSAFE.setMemory(ptr, size, (byte)0);
        return ptr;
    }

    static long[] p_allocArray(int size) {
        return new long[size];
    }

    static void p_delete(long page) {
        if (page != CLOSED_TREE_PAGE && page != NON_TREE_PAGE && !DirectPageOps.inArena(page)) {
            UNSAFE.freeMemory(page);
        }
    }

    static boolean inArena(long page) {
        Arena[] arenas = cArenas;
        if (arenas != null) {
            int low = 0;
            int high = arenas.length - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int cmp = Long.compareUnsigned(arenas[mid].mStartPtr, page);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return true;
            }
            if (low > 0 && Long.compareUnsigned(page, arenas[low - 1].mEndPtr) < 0) {
                return true;
            }
        }
        return false;
    }

    private static synchronized void registerArena(Arena arena) {
        Arena[] existing = cArenas;
        if (existing == null) {
            cArenas = new Arena[]{arena};
        } else {
            Object[] arenas = new Arena[existing.length + 1];
            System.arraycopy(existing, 0, arenas, 0, existing.length);
            arenas[arenas.length - 1] = arena;
            Arrays.sort(arenas);
            cArenas = arenas;
        }
    }

    private static synchronized void unregisterArena(Arena arena) {
        Arena[] existing = cArenas;
        if (existing == null) {
            return;
        }
        if (existing.length == 1) {
            if (existing[0] == arena) {
                cArenas = null;
            }
            return;
        }
        try {
            Arena[] arenas = new Arena[existing.length - 1];
            int j = 0;
            for (int i = 0; i < existing.length; ++i) {
                Arena a = existing[i];
                if (a == arena) continue;
                arenas[j++] = a;
            }
            cArenas = arenas;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    static Object p_arenaAlloc(int pageSize, long pageCount) throws IOException {
        Arena arena = new Arena(pageSize, pageCount);
        DirectPageOps.registerArena(arena);
        return arena;
    }

    static void p_arenaDelete(Object arena) throws IOException {
        if (arena instanceof Arena) {
            Arena a = (Arena)arena;
            DirectPageOps.unregisterArena(a);
            a.close();
        } else if (arena != null) {
            throw new IllegalArgumentException();
        }
    }

    static long p_calloc(Object arena, int size) {
        if (arena instanceof Arena) {
            long page = ((Arena)arena).p_calloc(size);
            if (page != DirectPageOps.p_null()) {
                return page;
            }
        } else if (arena != null) {
            throw new IllegalArgumentException();
        }
        return DirectPageOps.p_calloc(size);
    }

    static long p_clone(long page, int length) {
        long dst = DirectPageOps.p_alloc(length);
        UNSAFE.copyMemory(page, dst, length);
        return dst;
    }

    static long p_transfer(byte[] array) {
        int length = array.length;
        long page = DirectPageOps.p_alloc(length);
        DirectPageOps.p_copyFromArray(array, 0, page, 0, length);
        return page;
    }

    static long p_transferTo(byte[] array, long page) {
        int length = array.length;
        DirectPageOps.p_copyFromArray(array, 0, page, 0, length);
        return page;
    }

    static byte p_byteGet(long page, int index) {
        return UNSAFE.getByte(page + (long)index);
    }

    static int p_ubyteGet(long page, int index) {
        return UNSAFE.getByte(page + (long)index) & 0xFF;
    }

    static void p_bytePut(long page, int index, byte v) {
        UNSAFE.putByte(page + (long)index, v);
    }

    static void p_bytePut(long page, int index, int v) {
        UNSAFE.putByte(page + (long)index, (byte)v);
    }

    static int p_ushortGetLE(long page, int index) {
        return UNSAFE.getChar(page + (long)index);
    }

    static void p_shortPutLE(long page, int index, int v) {
        UNSAFE.putShort(page + (long)index, (short)v);
    }

    static int p_intGetLE(long page, int index) {
        return UNSAFE.getInt(page + (long)index);
    }

    static void p_intPutLE(long page, int index, int v) {
        UNSAFE.putInt(page + (long)index, v);
    }

    static int p_uintGetVar(long page, int index) {
        byte v = DirectPageOps.p_byteGet(page, index);
        if (v >= 0) {
            return v;
        }
        switch (v >> 4 & 7) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return 128 + ((v & 0x3F) << 8 | DirectPageOps.p_ubyteGet(page, index + 1));
            }
            case 4: 
            case 5: {
                return 16512 + ((v & 0x1F) << 16 | DirectPageOps.p_ubyteGet(page, ++index) << 8 | DirectPageOps.p_ubyteGet(page, index + 1));
            }
            case 6: {
                return 2113664 + ((v & 0xF) << 24 | DirectPageOps.p_ubyteGet(page, ++index) << 16 | DirectPageOps.p_ubyteGet(page, ++index) << 8 | DirectPageOps.p_ubyteGet(page, index + 1));
            }
        }
        return 270549120 + (DirectPageOps.p_byteGet(page, ++index) << 24 | DirectPageOps.p_ubyteGet(page, ++index) << 16 | DirectPageOps.p_ubyteGet(page, ++index) << 8 | DirectPageOps.p_ubyteGet(page, index + 1));
    }

    static int p_uintPutVar(long page, int index, int v) {
        if (v < 128) {
            if (v < 0) {
                DirectPageOps.p_bytePut(page, index++, 255);
                DirectPageOps.p_bytePut(page, index++, (v -= 270549120) >> 24);
                DirectPageOps.p_bytePut(page, index++, v >> 16);
                DirectPageOps.p_bytePut(page, index++, v >> 8);
            }
        } else if ((v -= 128) < 16384) {
            DirectPageOps.p_bytePut(page, index++, 0x80 | v >> 8);
        } else {
            if ((v -= 16384) < 0x200000) {
                DirectPageOps.p_bytePut(page, index++, 0xC0 | v >> 16);
            } else {
                if ((v -= 0x200000) < 0x10000000) {
                    DirectPageOps.p_bytePut(page, index++, 0xE0 | v >> 24);
                } else {
                    DirectPageOps.p_bytePut(page, index++, 240);
                    DirectPageOps.p_bytePut(page, index++, (v -= 0x10000000) >> 24);
                }
                DirectPageOps.p_bytePut(page, index++, v >> 16);
            }
            DirectPageOps.p_bytePut(page, index++, v >> 8);
        }
        DirectPageOps.p_bytePut(page, index++, v);
        return index;
    }

    static int p_uintVarSize(int v) {
        return Utils.calcUnsignedVarIntLength(v);
    }

    static long p_uint48GetLE(long page, int index) {
        return (long)UNSAFE.getInt(page += (long)index) & 0xFFFFFFFFL | (long)UNSAFE.getChar(page + 4L) << 32;
    }

    static void p_int48PutLE(long page, int index, long v) {
        UNSAFE.putInt(page += (long)index, (int)v);
        UNSAFE.putShort(page + 4L, (short)(v >> 32));
    }

    static long p_longGetLE(long page, int index) {
        return UNSAFE.getLong(page + (long)index);
    }

    static void p_longPutLE(long page, int index, long v) {
        UNSAFE.putLong(page + (long)index, v);
    }

    static long p_longGetBE(long page, int index) {
        return Long.reverseBytes(UNSAFE.getLong(page + (long)index));
    }

    static void p_longPutBE(long page, int index, long v) {
        UNSAFE.putLong(page + (long)index, Long.reverseBytes(v));
    }

    static long p_ulongGetVar(long page, IntegerRef ref) {
        long decoded;
        byte val;
        int offset = ref.get();
        if ((val = DirectPageOps.p_byteGet(page, offset++)) >= 0) {
            ref.set(offset);
            return val;
        }
        block0 : switch (val >> 4 & 7) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                decoded = 128L + (long)((val & 0x3F) << 8 | DirectPageOps.p_ubyteGet(page, offset++));
                break;
            }
            case 4: 
            case 5: {
                decoded = 16512L + (long)((val & 0x1F) << 16 | DirectPageOps.p_ubyteGet(page, offset++) << 8 | DirectPageOps.p_ubyteGet(page, offset++));
                break;
            }
            case 6: {
                decoded = 2113664L + (long)((val & 0xF) << 24 | DirectPageOps.p_ubyteGet(page, offset++) << 16 | DirectPageOps.p_ubyteGet(page, offset++) << 8 | DirectPageOps.p_ubyteGet(page, offset++));
                break;
            }
            default: {
                switch (val & 0xF) {
                    default: {
                        decoded = 270549120L + (((long)val & 7L) << 32 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 24 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 16 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 8 | (long)DirectPageOps.p_ubyteGet(page, offset++));
                        break block0;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        decoded = 34630287488L + (((long)val & 3L) << 40 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 32 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 24 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 16 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 8 | (long)DirectPageOps.p_ubyteGet(page, offset++));
                        break block0;
                    }
                    case 12: 
                    case 13: {
                        decoded = 4432676798592L + (((long)val & 1L) << 48 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 40 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 32 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 24 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 16 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 8 | (long)DirectPageOps.p_ubyteGet(page, offset++));
                        break block0;
                    }
                    case 14: {
                        decoded = 567382630219904L + ((long)DirectPageOps.p_ubyteGet(page, offset++) << 48 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 40 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 32 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 24 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 16 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 8 | (long)DirectPageOps.p_ubyteGet(page, offset++));
                        break block0;
                    }
                    case 15: 
                }
                decoded = 72624976668147840L + ((long)DirectPageOps.p_byteGet(page, offset++) << 56 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 48 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 40 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 32 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 24 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 16 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 8 | (long)DirectPageOps.p_ubyteGet(page, offset++));
            }
        }
        ref.set(offset);
        return decoded;
    }

    static int p_ulongPutVar(long page, int index, long v) {
        if (v < 128L) {
            if (v < 0L) {
                DirectPageOps.p_bytePut(page, index++, 255);
                DirectPageOps.p_bytePut(page, index++, (byte)((v -= 72624976668147840L) >> 56));
                DirectPageOps.p_bytePut(page, index++, (byte)(v >> 48));
                DirectPageOps.p_bytePut(page, index++, (byte)(v >> 40));
                DirectPageOps.p_bytePut(page, index++, (byte)(v >> 32));
                DirectPageOps.p_bytePut(page, index++, (byte)(v >> 24));
                DirectPageOps.p_bytePut(page, index++, (byte)(v >> 16));
                DirectPageOps.p_bytePut(page, index++, (byte)(v >> 8));
            }
        } else if ((v -= 128L) < 16384L) {
            DirectPageOps.p_bytePut(page, index++, 0x80 | (int)(v >> 8));
        } else {
            if ((v -= 16384L) < 0x200000L) {
                DirectPageOps.p_bytePut(page, index++, 0xC0 | (int)(v >> 16));
            } else {
                if ((v -= 0x200000L) < 0x10000000L) {
                    DirectPageOps.p_bytePut(page, index++, 0xE0 | (int)(v >> 24));
                } else {
                    if ((v -= 0x10000000L) < 0x800000000L) {
                        DirectPageOps.p_bytePut(page, index++, 0xF0 | (int)(v >> 32));
                    } else {
                        if ((v -= 0x800000000L) < 0x40000000000L) {
                            DirectPageOps.p_bytePut(page, index++, 0xF8 | (int)(v >> 40));
                        } else {
                            if ((v -= 0x40000000000L) < 0x2000000000000L) {
                                DirectPageOps.p_bytePut(page, index++, 0xFC | (int)(v >> 48));
                            } else {
                                if ((v -= 0x2000000000000L) < 0x100000000000000L) {
                                    DirectPageOps.p_bytePut(page, index++, 0xFE | (int)(v >> 56));
                                } else {
                                    DirectPageOps.p_bytePut(page, index++, 255);
                                    DirectPageOps.p_bytePut(page, index++, (byte)((v -= 0x100000000000000L) >> 56));
                                }
                                DirectPageOps.p_bytePut(page, index++, (byte)(v >> 48));
                            }
                            DirectPageOps.p_bytePut(page, index++, (byte)(v >> 40));
                        }
                        DirectPageOps.p_bytePut(page, index++, (byte)(v >> 32));
                    }
                    DirectPageOps.p_bytePut(page, index++, (byte)(v >> 24));
                }
                DirectPageOps.p_bytePut(page, index++, (byte)(v >> 16));
            }
            DirectPageOps.p_bytePut(page, index++, (byte)(v >> 8));
        }
        DirectPageOps.p_bytePut(page, index++, (byte)v);
        return index;
    }

    static int p_ulongVarSize(long v) {
        return Utils.calcUnsignedVarLongLength(v);
    }

    static void p_clear(long page, int fromIndex, int toIndex) {
        UNSAFE.setMemory(page + (long)fromIndex, toIndex - fromIndex, (byte)0);
    }

    static byte[] p_copyIfNotArray(long page, byte[] dstArray) {
        DirectPageOps.p_copyToArray(page, 0, dstArray, 0, dstArray.length);
        return dstArray;
    }

    static void p_copyFromArray(byte[] src, int srcStart, long dstPage, int dstStart, int len) {
        UNSAFE.copyMemory(src, BYTE_ARRAY_OFFSET + (long)srcStart, null, dstPage + (long)dstStart, len);
    }

    static void p_copyToArray(long srcPage, int srcStart, byte[] dst, int dstStart, int len) {
        UNSAFE.copyMemory(null, srcPage + (long)srcStart, dst, BYTE_ARRAY_OFFSET + (long)dstStart, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void p_copyFromBB(ByteBuffer src, long dstPage, int dstStart, int len) {
        ByteBuffer dst = DirectAccess.ref(dstPage + (long)dstStart, len);
        try {
            src.limit(src.position() + len);
            dst.put(src);
            src.limit(src.capacity());
        }
        finally {
            DirectAccess.unref(dst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void p_copyToBB(long srcPage, int srcStart, ByteBuffer dst, int len) {
        ByteBuffer src = DirectAccess.ref(srcPage + (long)srcStart, len);
        try {
            dst.put(src);
        }
        finally {
            DirectAccess.unref(src);
        }
    }

    static void p_copy(long srcPage, int srcStart, long dstPage, int dstStart, int len) {
        UNSAFE.copyMemory(srcPage + (long)srcStart, dstPage + (long)dstStart, len);
    }

    static void p_copies(long page, int start1, int dest1, int length1, int start2, int dest2, int length2) {
        if (dest1 < start1) {
            DirectPageOps.p_copy(page, start1, page, dest1, length1);
            DirectPageOps.p_copy(page, start2, page, dest2, length2);
        } else {
            DirectPageOps.p_copy(page, start2, page, dest2, length2);
            DirectPageOps.p_copy(page, start1, page, dest1, length1);
        }
    }

    static void p_copies(long page, int start1, int dest1, int length1, int start2, int dest2, int length2, int start3, int dest3, int length3) {
        if (dest1 < start1) {
            DirectPageOps.p_copy(page, start1, page, dest1, length1);
            DirectPageOps.p_copies(page, start2, dest2, length2, start3, dest3, length3);
        } else {
            DirectPageOps.p_copies(page, start2, dest2, length2, start3, dest3, length3);
            DirectPageOps.p_copy(page, start1, page, dest1, length1);
        }
    }

    static int p_compareKeysPageToArray(long apage, int aoff, int alen, byte[] b, int boff, int blen) {
        apage += (long)aoff;
        int minLen = Math.min(alen, blen);
        for (int i = 0; i < minLen; ++i) {
            byte bb;
            byte ab;
            if ((ab = UNSAFE.getByte(apage++)) == (bb = b[boff + i])) continue;
            return (ab & 0xFF) - (bb & 0xFF);
        }
        return alen - blen;
    }

    static int p_compareKeysPageToPage(long apage, int aoff, int alen, long bpage, int boff, int blen) {
        apage += (long)aoff;
        bpage += (long)boff;
        int minLen = Math.min(alen, blen);
        for (int i = 0; i < minLen; ++i) {
            byte bb;
            byte ab;
            if ((ab = UNSAFE.getByte(apage++)) == (bb = UNSAFE.getByte(bpage++))) continue;
            return (ab & 0xFF) - (bb & 0xFF);
        }
        return alen - blen;
    }

    static byte[] p_midKeyLowPage(long lowPage, int lowOff, int lowLen, byte[] high, int highOff, int highLen) {
        lowPage += (long)lowOff;
        for (int i = 0; i < lowLen; ++i) {
            byte hi;
            byte lo = UNSAFE.getByte(lowPage + (long)i);
            if (lo == (hi = high[highOff + i])) continue;
            byte[] mid = new byte[i + 1];
            DirectPageOps.p_copyToArray(lowPage, 0, mid, 0, i);
            mid[i] = (byte)((lo & 0xFF) + (hi & 0xFF) + 1 >> 1);
            return mid;
        }
        byte[] mid = new byte[lowLen + 1];
        System.arraycopy(high, highOff, mid, 0, mid.length);
        return mid;
    }

    static byte[] p_midKeyHighPage(byte[] low, int lowOff, int lowLen, long highPage, int highOff, int highLen) {
        highPage += (long)highOff;
        for (int i = 0; i < lowLen; ++i) {
            byte lo = low[lowOff + i];
            byte hi = UNSAFE.getByte(highPage + (long)i);
            if (lo == hi) continue;
            byte[] mid = new byte[i + 1];
            System.arraycopy(low, lowOff, mid, 0, i);
            mid[i] = (byte)((lo & 0xFF) + (hi & 0xFF) + 1 >> 1);
            return mid;
        }
        byte[] mid = new byte[lowLen + 1];
        DirectPageOps.p_copyToArray(highPage, 0, mid, 0, mid.length);
        return mid;
    }

    static byte[] p_midKeyLowHighPage(long lowPage, int lowOff, int lowLen, long highPage, int highOff, int highLen) {
        lowPage += (long)lowOff;
        highPage += (long)highOff;
        for (int i = 0; i < lowLen; ++i) {
            byte hi;
            byte lo = UNSAFE.getByte(lowPage + (long)i);
            if (lo == (hi = UNSAFE.getByte(highPage + (long)i))) continue;
            byte[] mid = new byte[i + 1];
            DirectPageOps.p_copyToArray(lowPage, 0, mid, 0, i);
            mid[i] = (byte)((lo & 0xFF) + (hi & 0xFF) + 1 >> 1);
            return mid;
        }
        byte[] mid = new byte[lowLen + 1];
        DirectPageOps.p_copyToArray(highPage, 0, mid, 0, mid.length);
        return mid;
    }

    static int p_crc32(long srcPage, int srcStart, int len) {
        CRC32 crc = new CRC32();
        if (CRC_BUFFER_UPDATE_METHOD != null) {
            ByteBuffer bb = DirectAccess.ref(srcPage + (long)srcStart, len);
            try {
                CRC_BUFFER_UPDATE_METHOD.invoke((Object)crc, bb);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                DirectAccess.unref(bb);
            }
        } else {
            byte[] temp = new byte[len];
            DirectPageOps.p_copyToArray(srcPage, srcStart, temp, 0, len);
            crc.update(temp);
        }
        return (int)crc.getValue();
    }

    static {
        Method m;
        UNSAFE = Hasher.getUnsafe();
        BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
        CLOSED_TREE_PAGE = DirectPageOps.newEmptyPage();
        NON_TREE_PAGE = DirectPageOps.newEmptyPage();
        try {
            m = CRC32.class.getMethod("update", ByteBuffer.class);
        }
        catch (Exception e) {
            m = null;
        }
        CRC_BUFFER_UPDATE_METHOD = m;
    }

    static class Arena
    implements Comparable<Arena> {
        private final MappedPageArray mPageArray;
        private final long mStartPtr;
        private final long mEndPtr;
        private long mNextPtr;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Arena(int pageSize, long pageCount) throws IOException {
            this.mPageArray = MappedPageArray.open(pageSize, pageCount, null, null);
            this.mStartPtr = this.mPageArray.directPagePointer(0L);
            this.mEndPtr = this.mStartPtr + (long)pageSize * pageCount;
            Arena arena = this;
            synchronized (arena) {
                this.mNextPtr = this.mStartPtr;
            }
        }

        @Override
        public int compareTo(Arena other) {
            return Long.compareUnsigned(this.mStartPtr, other.mStartPtr);
        }

        synchronized long p_calloc(int size) {
            int pageSize = this.mPageArray.pageSize();
            if (size != pageSize) {
                throw new IllegalArgumentException();
            }
            long ptr = this.mNextPtr;
            if (ptr >= this.mEndPtr) {
                return DirectPageOps.p_null();
            }
            this.mNextPtr = ptr + (long)pageSize;
            return ptr;
        }

        synchronized void close() throws IOException {
            this.mNextPtr = this.mEndPtr;
            this.mPageArray.close();
        }
    }
}

