/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.time.ZonedDateTime;
import java.util.EnumSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.cojen.tupl.Crypto;
import org.cojen.tupl.Database;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.EventListener;
import org.cojen.tupl.EventType;
import org.cojen.tupl.LockUpgradeRule;
import org.cojen.tupl.PageCache;
import org.cojen.tupl.PartitionedPageCache;
import org.cojen.tupl.Utils;
import org.cojen.tupl.ext.ReplicationManager;
import org.cojen.tupl.ext.TransactionHandler;
import org.cojen.tupl.io.FileFactory;
import org.cojen.tupl.io.OpenOption;
import org.cojen.tupl.io.PageArray;

public class DatabaseConfig
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static volatile Method cDirectOpen;
    private static volatile Method cDirectDestroy;
    private static volatile Method cDirectRestore;
    File mBaseFile;
    boolean mMkdirs;
    File[] mDataFiles;
    boolean mMapDataFiles;
    transient PageArray mDataPageArray;
    FileFactory mFileFactory;
    long mMinCachedBytes;
    long mMaxCachedBytes;
    long mSecondaryCacheSize;
    DurabilityMode mDurabilityMode;
    LockUpgradeRule mLockUpgradeRule;
    long mLockTimeoutNanos;
    long mCheckpointRateNanos;
    long mCheckpointSizeThreshold;
    long mCheckpointDelayThresholdNanos;
    transient EventListener mEventListener;
    boolean mFileSync;
    boolean mReadOnly;
    int mPageSize;
    Boolean mDirectPageAccess;
    boolean mCachePriming;
    transient ReplicationManager mReplManager;
    int mMaxReplicaThreads;
    transient Crypto mCrypto;
    transient TransactionHandler mTxnHandler;
    transient long mReplRecoveryStartNanos;
    transient long mReplInitialTxnId;

    public DatabaseConfig() {
        this.createFilePath(true);
        this.durabilityMode(null);
        this.lockTimeout(1L, TimeUnit.SECONDS);
        this.checkpointRate(1L, TimeUnit.SECONDS);
        this.checkpointSizeThreshold(0x100000L);
        this.checkpointDelayThreshold(1L, TimeUnit.MINUTES);
    }

    public DatabaseConfig baseFile(File file) {
        this.mBaseFile = file == null ? null : DatabaseConfig.abs(file);
        return this;
    }

    public DatabaseConfig baseFilePath(String path) {
        this.mBaseFile = path == null ? null : DatabaseConfig.abs(new File(path));
        return this;
    }

    public DatabaseConfig createFilePath(boolean mkdirs) {
        this.mMkdirs = mkdirs;
        return this;
    }

    public DatabaseConfig dataFile(File file) {
        this.dataFiles(file);
        return this;
    }

    public DatabaseConfig dataFiles(File ... files) {
        if (files == null || files.length == 0) {
            this.mDataFiles = null;
        } else {
            File[] dataFiles = new File[files.length];
            for (int i = 0; i < files.length; ++i) {
                dataFiles[i] = DatabaseConfig.abs(files[i]);
            }
            this.mDataFiles = dataFiles;
            this.mDataPageArray = null;
        }
        return this;
    }

    public DatabaseConfig mapDataFiles(boolean mapped) {
        this.mMapDataFiles = mapped;
        return this;
    }

    public DatabaseConfig dataPageArray(PageArray array) {
        this.mDataPageArray = array;
        if (array != null) {
            int expected = this.mDataPageArray.pageSize();
            if (this.mPageSize != 0 && this.mPageSize != expected) {
                throw new IllegalArgumentException("Page size doesn't match data page array: " + this.mPageSize + " != " + expected);
            }
            this.mDataFiles = null;
            this.mPageSize = expected;
        }
        return this;
    }

    public DatabaseConfig fileFactory(FileFactory factory) {
        this.mFileFactory = factory;
        return this;
    }

    public DatabaseConfig minCacheSize(long minBytes) {
        this.mMinCachedBytes = minBytes;
        return this;
    }

    public DatabaseConfig maxCacheSize(long maxBytes) {
        this.mMaxCachedBytes = maxBytes;
        return this;
    }

    public DatabaseConfig secondaryCacheSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException();
        }
        this.mSecondaryCacheSize = size;
        return this;
    }

    public DatabaseConfig durabilityMode(DurabilityMode durabilityMode) {
        if (durabilityMode == null) {
            durabilityMode = DurabilityMode.SYNC;
        }
        this.mDurabilityMode = durabilityMode;
        return this;
    }

    public DatabaseConfig lockUpgradeRule(LockUpgradeRule lockUpgradeRule) {
        if (lockUpgradeRule == null) {
            lockUpgradeRule = LockUpgradeRule.STRICT;
        }
        this.mLockUpgradeRule = lockUpgradeRule;
        return this;
    }

    public DatabaseConfig lockTimeout(long timeout, TimeUnit unit) {
        this.mLockTimeoutNanos = Utils.toNanos(timeout, unit);
        return this;
    }

    public DatabaseConfig checkpointRate(long rate, TimeUnit unit) {
        this.mCheckpointRateNanos = Utils.toNanos(rate, unit);
        return this;
    }

    public DatabaseConfig checkpointSizeThreshold(long bytes) {
        this.mCheckpointSizeThreshold = bytes;
        return this;
    }

    public DatabaseConfig checkpointDelayThreshold(long delay, TimeUnit unit) {
        this.mCheckpointDelayThresholdNanos = Utils.toNanos(delay, unit);
        return this;
    }

    public DatabaseConfig eventListener(EventListener listener) {
        this.mEventListener = listener;
        return this;
    }

    public DatabaseConfig syncWrites(boolean fileSync) {
        this.mFileSync = fileSync;
        return this;
    }

    public DatabaseConfig pageSize(int size) {
        int expected;
        if (this.mDataPageArray != null && (expected = this.mDataPageArray.pageSize()) != size) {
            throw new IllegalArgumentException("Page size doesn't match data page array: " + size + " != " + expected);
        }
        this.mPageSize = size;
        return this;
    }

    public DatabaseConfig directPageAccess(boolean direct) {
        this.mDirectPageAccess = direct;
        return this;
    }

    public DatabaseConfig cachePriming(boolean priming) {
        this.mCachePriming = priming;
        return this;
    }

    public DatabaseConfig replicate(ReplicationManager manager) {
        this.mReplManager = manager;
        return this;
    }

    public DatabaseConfig maxReplicaThreads(int num) {
        this.mMaxReplicaThreads = num;
        return this;
    }

    public DatabaseConfig encrypt(Crypto crypto) {
        this.mCrypto = crypto;
        return this;
    }

    public DatabaseConfig customTransactionHandler(TransactionHandler handler) {
        this.mTxnHandler = handler;
        return this;
    }

    public TransactionHandler getCustomTransactionHandler() {
        return this.mTxnHandler;
    }

    public DatabaseConfig clone() {
        try {
            return (DatabaseConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Utils.rethrow(e);
        }
    }

    PageCache pageCache(EventListener listener) {
        long size = this.mSecondaryCacheSize;
        if (size <= 0L) {
            return null;
        }
        if (listener != null) {
            listener.notify(EventType.CACHE_INIT_BEGIN, "Initializing %1$d bytes for secondary cache", size);
        }
        return new PartitionedPageCache(size, this.mPageSize);
    }

    File[] dataFiles() {
        long encoding;
        if (this.mReplManager != null && (encoding = this.mReplManager.encoding()) == 0L) {
            throw new IllegalArgumentException("Illegal replication manager encoding: " + encoding);
        }
        File[] dataFiles = this.mDataFiles;
        if (this.mBaseFile == null) {
            if (dataFiles != null && dataFiles.length > 0) {
                throw new IllegalArgumentException("Cannot specify data files when no base file is provided");
            }
            return null;
        }
        if (this.mBaseFile.isDirectory()) {
            throw new IllegalArgumentException("Base file is a directory: " + this.mBaseFile);
        }
        if (this.mDataPageArray != null) {
            return null;
        }
        if (dataFiles == null || dataFiles.length == 0) {
            dataFiles = new File[]{new File(this.mBaseFile.getPath() + ".db")};
        }
        for (File dataFile : dataFiles) {
            if (!dataFile.isDirectory()) continue;
            throw new IllegalArgumentException("Data file is a directory: " + dataFile);
        }
        return dataFiles;
    }

    EnumSet<OpenOption> createOpenOptions() {
        EnumSet<OpenOption> options = EnumSet.noneOf(OpenOption.class);
        if (this.mReadOnly) {
            options.add(OpenOption.READ_ONLY);
        }
        if (this.mFileSync) {
            options.add(OpenOption.SYNC_IO);
        }
        if (this.mMapDataFiles) {
            options.add(OpenOption.MAPPED);
        }
        options.add(OpenOption.CREATE);
        return options;
    }

    void writeInfo(BufferedWriter w) throws IOException {
        String user;
        String pid = ManagementFactory.getRuntimeMXBean().getName();
        try {
            user = System.getProperty("user.name");
        }
        catch (SecurityException e) {
            user = null;
        }
        TreeMap<String, String> props = new TreeMap<String, String>();
        if (pid != null) {
            DatabaseConfig.set(props, "lastOpenedByProcess", pid);
        }
        if (user != null) {
            DatabaseConfig.set(props, "lastOpenedByUser", user);
        }
        DatabaseConfig.set(props, "baseFile", this.mBaseFile);
        DatabaseConfig.set(props, "createFilePath", this.mMkdirs);
        DatabaseConfig.set(props, "mapDataFiles", this.mMapDataFiles);
        if (this.mDataFiles != null && this.mDataFiles.length > 0) {
            if (this.mDataFiles.length == 1) {
                DatabaseConfig.set(props, "dataFile", this.mDataFiles[0]);
            } else {
                StringBuilder b = new StringBuilder();
                b.append('[');
                for (int i = 0; i < this.mDataFiles.length; ++i) {
                    if (i > 0) {
                        b.append(", ");
                    }
                    b.append(this.mDataFiles[i]);
                }
                b.append(']');
                DatabaseConfig.set(props, "dataFiles", b);
            }
        }
        DatabaseConfig.set(props, "minCacheSize", this.mMinCachedBytes);
        DatabaseConfig.set(props, "maxCacheSize", this.mMaxCachedBytes);
        DatabaseConfig.set(props, "secondaryCacheSize", this.mSecondaryCacheSize);
        DatabaseConfig.set(props, "durabilityMode", (Object)this.mDurabilityMode);
        DatabaseConfig.set(props, "lockTimeoutNanos", this.mLockTimeoutNanos);
        DatabaseConfig.set(props, "checkpointRateNanos", this.mCheckpointRateNanos);
        DatabaseConfig.set(props, "checkpointSizeThreshold", this.mCheckpointSizeThreshold);
        DatabaseConfig.set(props, "checkpointDelayThresholdNanos", this.mCheckpointDelayThresholdNanos);
        DatabaseConfig.set(props, "syncWrites", this.mFileSync);
        DatabaseConfig.set(props, "pageSize", this.mPageSize);
        DatabaseConfig.set(props, "directPageAccess", this.mDirectPageAccess);
        DatabaseConfig.set(props, "cachePriming", this.mCachePriming);
        w.write(35);
        w.write(Database.class.getName());
        w.newLine();
        w.write(35);
        w.write(ZonedDateTime.now().toString());
        w.newLine();
        for (Map.Entry line : props.entrySet()) {
            w.write((String)line.getKey());
            w.write(61);
            w.write((String)line.getValue());
            w.newLine();
        }
    }

    private static void set(Map<String, String> props, String name, Object value) {
        if (value != null) {
            props.put(name, value.toString());
        }
    }

    private static File abs(File file) {
        return file.getAbsoluteFile();
    }

    Class<?> directOpenClass() throws IOException {
        if (this.mDirectPageAccess == Boolean.FALSE) {
            return null;
        }
        try {
            return Class.forName("org.cojen.tupl._LocalDatabase");
        }
        catch (Exception e) {
            this.handleDirectException(e);
            return null;
        }
    }

    Method directOpenMethod() throws IOException {
        if (this.mDirectPageAccess == Boolean.FALSE) {
            return null;
        }
        Method m = cDirectOpen;
        if (m == null) {
            cDirectOpen = m = this.findMethod("open", DatabaseConfig.class);
        }
        return m;
    }

    Method directDestroyMethod() throws IOException {
        if (this.mDirectPageAccess == Boolean.FALSE) {
            return null;
        }
        Method m = cDirectDestroy;
        if (m == null) {
            cDirectDestroy = m = this.findMethod("destroy", DatabaseConfig.class);
        }
        return m;
    }

    Method directRestoreMethod() throws IOException {
        if (this.mDirectPageAccess == Boolean.FALSE) {
            return null;
        }
        Method m = cDirectRestore;
        if (m == null) {
            cDirectRestore = m = this.findMethod("restoreFromSnapshot", DatabaseConfig.class, InputStream.class);
        }
        return m;
    }

    void handleDirectException(Exception e) throws IOException {
        if (e instanceof RuntimeException || e instanceof IOException) {
            throw Utils.rethrow(e);
        }
        Throwable cause = e.getCause();
        if (cause == null) {
            cause = e;
        }
        if (cause instanceof RuntimeException || e instanceof IOException) {
            throw Utils.rethrow(cause);
        }
        if (this.mDirectPageAccess == Boolean.TRUE) {
            throw new DatabaseException("Unable open with direct page access", cause);
        }
    }

    private Method findMethod(String name, Class<?> ... paramTypes) throws IOException {
        Class<?> directClass = this.directOpenClass();
        if (directClass != null) {
            try {
                return directClass.getDeclaredMethod(name, paramTypes);
            }
            catch (Exception e) {
                this.handleDirectException(e);
            }
        }
        return null;
    }
}

