/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Utils;
import org.cojen.tupl.ViewUtils;

public interface Cursor {
    public static final byte[] NOT_LOADED = new byte[0];

    public Ordering getOrdering();

    public Transaction link(Transaction var1);

    public Transaction link();

    public byte[] key();

    public byte[] value();

    public boolean autoload(boolean var1);

    public boolean autoload();

    default public int compareKeyTo(byte[] rkey) {
        byte[] lkey = this.key();
        return Utils.compareUnsigned(lkey, 0, lkey.length, rkey, 0, rkey.length);
    }

    default public int compareKeyTo(byte[] rkey, int offset, int length) {
        byte[] lkey = this.key();
        return Utils.compareUnsigned(lkey, 0, lkey.length, rkey, offset, length);
    }

    public LockResult first() throws IOException;

    public LockResult last() throws IOException;

    public LockResult skip(long var1) throws IOException;

    default public LockResult skip(long amount, byte[] limitKey, boolean inclusive) throws IOException {
        return ViewUtils.skip(this, amount, limitKey, inclusive);
    }

    public LockResult next() throws IOException;

    public LockResult nextLe(byte[] var1) throws IOException;

    public LockResult nextLt(byte[] var1) throws IOException;

    public LockResult previous() throws IOException;

    public LockResult previousGe(byte[] var1) throws IOException;

    public LockResult previousGt(byte[] var1) throws IOException;

    public LockResult find(byte[] var1) throws IOException;

    public LockResult findGe(byte[] var1) throws IOException;

    public LockResult findGt(byte[] var1) throws IOException;

    public LockResult findLe(byte[] var1) throws IOException;

    public LockResult findLt(byte[] var1) throws IOException;

    public LockResult findNearby(byte[] var1) throws IOException;

    public LockResult random(byte[] var1, byte[] var2) throws IOException;

    public LockResult load() throws IOException;

    public void store(byte[] var1) throws IOException;

    default public void commit(byte[] value) throws IOException {
        this.store(value);
        Transaction txn = this.link();
        if (txn != null && txn != Transaction.BOGUS) {
            txn.commit();
        }
    }

    public Cursor copy();

    public void reset();
}

