/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import org.cojen.tupl.Crypto;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.DirectPageOps;
import org.cojen.tupl.io.PageArray;

final class CryptoPageArray
extends PageArray {
    private final PageArray mSource;
    private final Crypto mCrypto;

    CryptoPageArray(PageArray source, Crypto crypto) {
        super(source.pageSize());
        this.mSource = source;
        this.mCrypto = crypto;
    }

    @Override
    public boolean isReadOnly() {
        return this.mSource.isReadOnly();
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.mSource.isEmpty();
    }

    @Override
    public long getPageCount() throws IOException {
        return this.mSource.getPageCount();
    }

    @Override
    public void setPageCount(long count) throws IOException {
        this.mSource.setPageCount(count);
    }

    @Override
    public long getPageCountLimit() throws IOException {
        return this.mSource.getPageCountLimit();
    }

    @Override
    public void readPage(long index, byte[] dst) throws IOException {
        try {
            this.mSource.readPage(index, dst);
            this.mCrypto.decryptPage(index, this.pageSize(), dst, 0);
        }
        catch (GeneralSecurityException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void readPage(long index, byte[] dst, int offset, int length) throws IOException {
        int pageSize = this.pageSize();
        if (offset == 0 && length == pageSize) {
            this.readPage(index, dst);
            return;
        }
        byte[] page = new byte[pageSize];
        this.readPage(index, page);
        System.arraycopy(page, 0, dst, offset, length);
    }

    @Override
    public void readPage(long index, long dstPtr) throws IOException {
        try {
            this.mSource.readPage(index, dstPtr);
            this.mCrypto.decryptPage(index, this.pageSize(), dstPtr, 0);
        }
        catch (GeneralSecurityException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readPage(long index, long dstPtr, int offset, int length) throws IOException {
        int pageSize = this.pageSize();
        if (offset == 0 && length == pageSize) {
            this.readPage(index, dstPtr);
            return;
        }
        long page = DirectPageOps.p_alloc(pageSize);
        try {
            this.readPage(index, page);
            DirectPageOps.p_copy(page, 0, dstPtr, offset, length);
        }
        finally {
            DirectPageOps.p_delete(page);
        }
    }

    @Override
    public void writePage(long index, byte[] src, int offset) throws IOException {
        try {
            int pageSize = this.pageSize();
            byte[] encrypted = new byte[pageSize];
            this.mCrypto.encryptPage(index, pageSize, src, offset, encrypted, 0);
            this.mSource.writePage(index, encrypted, 0);
        }
        catch (GeneralSecurityException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePage(long index, long srcPtr, int offset) throws IOException {
        try {
            int pageSize = this.pageSize();
            long encrypted = DirectPageOps.p_alloc(pageSize);
            try {
                this.mCrypto.encryptPage(index, pageSize, srcPtr, offset, encrypted, 0);
                this.mSource.writePage(index, encrypted, 0);
            }
            finally {
                DirectPageOps.p_delete(encrypted);
            }
        }
        catch (GeneralSecurityException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public byte[] evictPage(long index, byte[] buf) throws IOException {
        try {
            this.mCrypto.encryptPage(index, this.pageSize(), buf, 0);
            return this.mSource.evictPage(index, buf);
        }
        catch (GeneralSecurityException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public long evictPage(long index, long bufPtr) throws IOException {
        try {
            this.mCrypto.encryptPage(index, this.pageSize(), bufPtr, 0);
            return this.mSource.evictPage(index, bufPtr);
        }
        catch (GeneralSecurityException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void sync(boolean metadata) throws IOException {
        this.mSource.sync(metadata);
    }

    @Override
    public void close(Throwable cause) throws IOException {
        this.mSource.close(cause);
    }
}

