/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.cojen.tupl.DatabaseConfig;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.EventListener;
import org.cojen.tupl.EventType;
import org.cojen.tupl.LocalDatabase;
import org.cojen.tupl.ShutdownHook;
import org.cojen.tupl.Utils;

final class Checkpointer
implements Runnable {
    private static final int STATE_INIT = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_CLOSED = 2;
    private static int cThreadCounter;
    private final AtomicInteger mSuspendCount = new AtomicInteger();
    private final ReferenceQueue<LocalDatabase> mRefQueue;
    private final WeakReference<LocalDatabase> mDatabaseRef;
    private final long mRateNanos;
    private final long mSizeThreshold;
    private final long mDelayThresholdNanos;
    private volatile Thread mThread;
    private volatile int mState;
    private Thread mShutdownHook;
    private List<ShutdownHook> mToShutdown;

    Checkpointer(LocalDatabase db, DatabaseConfig config) {
        this.mRateNanos = config.mCheckpointRateNanos;
        this.mSizeThreshold = config.mCheckpointSizeThreshold;
        this.mDelayThresholdNanos = config.mCheckpointDelayThresholdNanos;
        if (this.mRateNanos < 0L) {
            this.mRefQueue = new ReferenceQueue();
            this.mDatabaseRef = new WeakReference<LocalDatabase>(db, this.mRefQueue);
        } else {
            this.mRefQueue = null;
            this.mDatabaseRef = new WeakReference<LocalDatabase>(db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(boolean initialCheckpoint) {
        Class<Checkpointer> clazz = Checkpointer.class;
        synchronized (Checkpointer.class) {
            int num = ++cThreadCounter;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (!initialCheckpoint) {
                this.mState = 1;
            }
            Thread t = new Thread(this);
            t.setDaemon(true);
            t.setName("Checkpointer-" + ((long)num & 0xFFFFFFFFL));
            t.start();
            this.mThread = t;
            return;
        }
    }

    @Override
    public void run() {
        try {
            if (this.mState == 0) {
                LocalDatabase db = (LocalDatabase)this.mDatabaseRef.get();
                if (db != null) {
                    db.checkpoint();
                }
                this.mState = 1;
            }
            if (this.mRefQueue != null) {
                this.mRefQueue.remove();
                this.close();
                return;
            }
            long lastDurationNanos = 0L;
            while (true) {
                LocalDatabase db;
                long delayMillis;
                if ((delayMillis = (this.mRateNanos - lastDurationNanos) / 1000000L) > 0L) {
                    Thread.sleep(delayMillis);
                }
                if ((db = (LocalDatabase)this.mDatabaseRef.get()) == null) {
                    this.close();
                    return;
                }
                if (this.mSuspendCount.get() != 0) {
                    lastDurationNanos = 0L;
                    continue;
                }
                try {
                    long startNanos = System.nanoTime();
                    db.checkpoint(false, this.mSizeThreshold, this.mDelayThresholdNanos);
                    long endNanos = System.nanoTime();
                    lastDurationNanos = endNanos - startNanos;
                }
                catch (DatabaseException e) {
                    EventListener listener = db.mEventListener;
                    if (listener != null) {
                        listener.notify(EventType.CHECKPOINT_FAILED, "Checkpoint failed: %1$s", e);
                    }
                    if (!e.isRecoverable()) {
                        throw e;
                    }
                    lastDurationNanos = 0L;
                }
            }
        }
        catch (Throwable e) {
            LocalDatabase db;
            if (this.mState != 2 && (db = (LocalDatabase)this.mDatabaseRef.get()) != null && !db.mClosed) {
                Utils.closeQuietly(null, db, e);
            }
            this.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean register(ShutdownHook obj) {
        block10: {
            if (obj == null) {
                return false;
            }
            if (this.mState != 2) {
                Checkpointer checkpointer = this;
                synchronized (checkpointer) {
                    if (this.mState == 2) {
                        break block10;
                    }
                    if (this.mShutdownHook == null) {
                        Thread hook = new Thread(() -> this.close());
                        try {
                            Runtime.getRuntime().addShutdownHook(hook);
                            this.mShutdownHook = hook;
                        }
                        catch (IllegalStateException e) {
                            break block10;
                        }
                    }
                    if (this.mToShutdown == null) {
                        this.mToShutdown = new ArrayList<ShutdownHook>(2);
                    }
                    this.mToShutdown.add(obj);
                    return true;
                }
            }
        }
        obj.shutdown();
        return false;
    }

    void suspend() {
        this.suspend(1);
    }

    void resume() {
        this.suspend(-1);
    }

    private void suspend(int amt) {
        int count;
        do {
            if ((count = this.mSuspendCount.get() + amt) >= 0) continue;
            throw new IllegalStateException();
        } while (!this.mSuspendCount.compareAndSet(count - amt, count));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Thread close() {
        ArrayList<ShutdownHook> toShutdown;
        this.mState = 2;
        this.mDatabaseRef.enqueue();
        this.mDatabaseRef.clear();
        Checkpointer checkpointer = this;
        synchronized (checkpointer) {
            if (this.mShutdownHook != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.mShutdownHook);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.mShutdownHook = null;
            }
            if (this.mToShutdown == null) {
                toShutdown = null;
            } else {
                toShutdown = new ArrayList<ShutdownHook>(this.mToShutdown);
                this.mToShutdown = null;
            }
        }
        if (toShutdown != null) {
            for (ShutdownHook obj : toShutdown) {
                obj.shutdown();
            }
        }
        return this.mThread;
    }
}

