/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.cojen.tupl.NoSuchValueException;
import org.cojen.tupl.Stream;

abstract class AbstractStream
implements Stream {
    Object mIoState;

    AbstractStream() {
    }

    @Override
    public final int read(long pos, byte[] buf, int off, int len) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException();
        }
        AbstractStream.boundsCheck(buf, off, len);
        return this.doRead(pos, buf, off, len);
    }

    @Override
    public final void write(long pos, byte[] buf, int off, int len) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException();
        }
        AbstractStream.boundsCheck(buf, off, len);
        this.doWrite(pos, buf, off, len);
    }

    @Override
    public final InputStream newInputStream(long pos) throws IOException {
        return this.newInputStream(pos, -1);
    }

    @Override
    public final InputStream newInputStream(long pos, int bufferSize) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException();
        }
        this.checkOpen();
        return new In(this.mIoState, pos, new byte[this.selectBufferSize(bufferSize)]);
    }

    @Override
    public final OutputStream newOutputStream(long pos) throws IOException {
        return this.newOutputStream(pos, -1);
    }

    @Override
    public final OutputStream newOutputStream(long pos, int bufferSize) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException();
        }
        this.checkOpen();
        return new Out(this.mIoState, pos, new byte[this.selectBufferSize(bufferSize)]);
    }

    @Override
    public final void close() throws IOException {
        this.mIoState = null;
        this.doClose();
    }

    abstract int doRead(long var1, byte[] var3, int var4, int var5) throws IOException;

    abstract void doWrite(long var1, byte[] var3, int var4, int var5) throws IOException;

    abstract int selectBufferSize(int var1);

    abstract void checkOpen();

    abstract void doClose() throws IOException;

    static void boundsCheck(byte[] buf, int off, int len) {
        if ((off | len | off + len | buf.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    final void ioClose(Object ioState) throws IOException {
        if (ioState == this.mIoState) {
            this.mIoState = null;
            this.doClose();
        }
    }

    final void ioCheckOpen(Object ioState) {
        if (ioState != this.mIoState) {
            throw new IllegalStateException("Stream closed");
        }
    }

    final class Out
    extends OutputStream {
        private final Object mIoState;
        private long mPos;
        private final byte[] mBuffer;
        private int mEnd;

        Out(Object ioState, long pos, byte[] buffer) {
            if (ioState == null) {
                AbstractStream.this.mIoState = ioState = this;
            }
            this.mIoState = ioState;
            this.mPos = pos;
            this.mBuffer = buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            AbstractStream.this.ioCheckOpen(this.mIoState);
            byte[] buf = this.mBuffer;
            int end = this.mEnd;
            if (end >= buf.length) {
                this.flush();
                end = 0;
            }
            buf[end++] = (byte)b;
            try {
                if (end >= buf.length) {
                    AbstractStream.this.doWrite(this.mPos, buf, 0, end);
                    this.mPos += (long)end;
                    end = 0;
                }
            }
            finally {
                this.mEnd = end;
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            AbstractStream.boundsCheck(b, off, len);
            AbstractStream.this.ioCheckOpen(this.mIoState);
            byte[] buf = this.mBuffer;
            int end = this.mEnd;
            int avail = buf.length - end;
            if (len < avail) {
                System.arraycopy(b, off, buf, end, len);
                this.mEnd = end + len;
                return;
            }
            if (end != 0) {
                System.arraycopy(b, off, buf, end, avail);
                off += avail;
                len -= avail;
                avail = buf.length;
                try {
                    AbstractStream.this.doWrite(this.mPos, buf, 0, avail);
                }
                catch (Throwable e) {
                    this.mEnd = avail;
                    throw e;
                }
                this.mPos += (long)avail;
                if (len < avail) {
                    System.arraycopy(b, off, buf, 0, len);
                    this.mEnd = len;
                    return;
                }
                this.mEnd = 0;
            }
            AbstractStream.this.doWrite(this.mPos, b, off, len);
            this.mPos += (long)len;
        }

        @Override
        public void flush() throws IOException {
            AbstractStream.this.ioCheckOpen(this.mIoState);
            this.doFlush();
        }

        @Override
        public void close() throws IOException {
            if (this.mIoState == AbstractStream.this.mIoState) {
                this.doFlush();
                AbstractStream.this.ioClose(this.mIoState);
            }
        }

        private void doFlush() throws IOException {
            int end = this.mEnd;
            if (end > 0) {
                AbstractStream.this.doWrite(this.mPos, this.mBuffer, 0, end);
                this.mPos += (long)end;
                this.mEnd = 0;
            }
        }
    }

    final class In
    extends InputStream {
        private final Object mIoState;
        private long mPos;
        private final byte[] mBuffer;
        private int mStart;
        private int mEnd;

        In(Object ioState, long pos, byte[] buffer) {
            if (ioState == null) {
                AbstractStream.this.mIoState = ioState = this;
            }
            this.mIoState = ioState;
            this.mPos = pos;
            this.mBuffer = buffer;
        }

        @Override
        public int read() throws IOException {
            AbstractStream.this.ioCheckOpen(this.mIoState);
            byte[] buf = this.mBuffer;
            int start = this.mStart;
            if (start < this.mEnd) {
                ++this.mPos;
                int b = buf[start] & 0xFF;
                this.mStart = start + 1;
                return b;
            }
            long pos = this.mPos;
            int amt = AbstractStream.this.doRead(pos, buf, 0, buf.length);
            if (amt <= 0) {
                if (amt < 0) {
                    throw new NoSuchValueException();
                }
                return -1;
            }
            this.mEnd = amt;
            this.mPos = pos + 1L;
            this.mStart = 1;
            return buf[0] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int initialOff;
            int amt;
            block7: {
                AbstractStream.boundsCheck(b, off, len);
                AbstractStream.this.ioCheckOpen(this.mIoState);
                byte[] buf = this.mBuffer;
                int start = this.mStart;
                amt = this.mEnd - start;
                if (amt >= len) {
                    System.arraycopy(buf, start, b, off, len);
                    this.mStart = start + len;
                    this.mPos += (long)len;
                    return len;
                }
                initialOff = off;
                if (amt > 0) {
                    System.arraycopy(buf, start, b, off, amt);
                    this.mEnd = start;
                    off += amt;
                    len -= amt;
                    this.mPos += (long)amt;
                }
                while (len >= buf.length) {
                    amt = AbstractStream.this.doRead(this.mPos, b, off, len);
                    if (amt <= 0) break block7;
                    off += amt;
                    this.mPos += (long)amt;
                    if ((len -= amt) > 0) continue;
                    break block7;
                }
                while ((amt = AbstractStream.this.doRead(this.mPos, buf, 0, buf.length)) > 0) {
                    if (amt >= len) {
                        System.arraycopy(buf, 0, b, off, len);
                        off += len;
                        this.mPos += (long)len;
                        this.mStart = len;
                        this.mEnd = amt;
                        break;
                    }
                    System.arraycopy(buf, 0, b, off, amt);
                    off += amt;
                    len -= amt;
                    this.mPos += (long)amt;
                }
            }
            amt = off - initialOff;
            if (amt <= 0) {
                if (amt < 0) {
                    throw new NoSuchValueException();
                }
                return -1;
            }
            return amt;
        }

        @Override
        public long skip(long n) throws IOException {
            AbstractStream.this.ioCheckOpen(this.mIoState);
            if (n <= 0L) {
                return 0L;
            }
            int start = this.mStart;
            int amt = this.mEnd - start;
            if (amt > 0) {
                if (n >= (long)amt) {
                    this.mEnd = start;
                } else {
                    amt = (int)n;
                    this.mStart = start + amt;
                }
                this.mPos += (long)amt;
                return amt;
            }
            long pos = this.mPos;
            long newPos = Math.min(pos + n, AbstractStream.this.length());
            if (newPos > pos) {
                this.mPos = newPos;
                return newPos - pos;
            }
            return 0L;
        }

        @Override
        public int available() {
            return this.mIoState == AbstractStream.this.mIoState ? this.mEnd - this.mStart : 0;
        }

        @Override
        public void close() throws IOException {
            AbstractStream.this.ioClose(this.mIoState);
        }
    }
}

