/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.server.handler;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.nanohttpd.protocols.http.IHTTPSession;
import org.nanohttpd.protocols.http.response.IStatus;
import org.nanohttpd.protocols.http.response.Response;
import org.nanohttpd.protocols.http.response.Status;
import org.nanohttpd.router.RouterNanoHTTPD;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.Locations;
import org.readium.r2.shared.Locator;
import org.readium.r2.shared.LocatorText;
import org.readium.r2.streamer.ClientAppContext;
import org.readium.r2.streamer.fetcher.Fetcher;
import org.readium.r2.streamer.server.handler.SearchQueryHandler;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J/\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u000bH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000bH\u0016J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010\u001e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000bH\u0003J \u0010 \u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000bH\u0003J&\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/readium/r2/streamer/server/handler/SearchQueryHandler;", "Lorg/nanohttpd/router/RouterNanoHTTPD$DefaultHandler;", "()V", "searchLocators", "", "Lorg/readium/r2/shared/Locator;", "webView", "Landroid/webkit/WebView;", "addLocators", "", "locatorsJsonString", "", "link", "Lorg/readium/r2/shared/Link;", "get", "Lorg/nanohttpd/protocols/http/response/Response;", "uriResource", "Lorg/nanohttpd/router/RouterNanoHTTPD$UriResource;", "urlParams", "", "session", "Lorg/nanohttpd/protocols/http/IHTTPSession;", "getMimeType", "getStatus", "Lorg/nanohttpd/protocols/http/response/IStatus;", "getText", "rangyFindSolution", "searchQuery", "fetcher", "Lorg/readium/r2/streamer/fetcher/Fetcher;", "runWebviewForRangyFind", "fileData", "runWebviewForWindowFind", "windowFindSolution", "Companion", "r2-streamer-kotlin_devFolioReaderRelease"})
public final class SearchQueryHandler
extends RouterNanoHTTPD.DefaultHandler {
    private final List<Locator> searchLocators;
    private WebView webView;
    @NotNull
    private static final String LOG_TAG;
    public static final Companion Companion;

    @NotNull
    public IStatus getStatus() {
        return (IStatus)Status.OK;
    }

    @NotNull
    public String getMimeType() {
        return "application/json";
    }

    @NotNull
    public String getText() {
        return "{\"success\":false}";
    }

    @NotNull
    public Response get(@NotNull RouterNanoHTTPD.UriResource uriResource, @Nullable Map<String, String> urlParams, @NotNull IHTTPSession session) {
        Response response;
        Intrinsics.checkParameterIsNotNull((Object)uriResource, (String)"uriResource");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Log.i((String)LOG_TAG, (String)("-> " + session.getMethod() + ' ' + session.getUri()));
        try {
            String searchQuery;
            int n;
            Fetcher fetcher = (Fetcher)uriResource.initParameter(Fetcher.class);
            Object object = (List)session.getParameters().get("spineIndex");
            if (object != null && (object = (String)object.get(0)) != null) {
                Object object2 = object;
                n = Integer.parseInt((String)object2);
            } else {
                n = -1;
            }
            int spineIndex = n;
            Link link = (Link)fetcher.getPublication().getReadingOrder().get(spineIndex);
            List list = (List)session.getParameters().get("query");
            String searchQueryEncoded = list != null ? (String)list.get(0) : null;
            String string = searchQuery = URLDecoder.decode(searchQueryEncoded, "UTF-8");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"searchQuery");
            Fetcher fetcher2 = fetcher;
            Intrinsics.checkExpressionValueIsNotNull((Object)fetcher2, (String)"fetcher");
            List<Locator> responseSearchLocators = this.windowFindSolution(link, string, fetcher2);
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            String searchLocatorsJson = objectMapper.writeValueAsString(responseSearchLocators);
            Response response2 = Response.newFixedLengthResponse((IStatus)((IStatus)Status.OK), (String)this.getMimeType(), (String)searchLocatorsJson);
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"Response.newFixedLengthR\u2026Type, searchLocatorsJson)");
            response = response2;
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"-> get -> ", (Throwable)e);
            Response response3 = Response.newFixedLengthResponse((IStatus)((IStatus)Status.INTERNAL_ERROR), (String)this.getMimeType(), (String)"{\"success\":false}");
            Intrinsics.checkExpressionValueIsNotNull((Object)response3, (String)"Response.newFixedLengthR\u2026eStatus.FAILURE_RESPONSE)");
            response = response3;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Locator> rangyFindSolution(Link link, String searchQuery, Fetcher fetcher) {
        Log.d((String)LOG_TAG, (String)("-> rangyFindSolution -> " + link.getHref()));
        if (Intrinsics.areEqual((Object)link.getTypeLink(), (Object)"application/xhtml+xml") ^ true) {
            return new ArrayList();
        }
        String string = link.getHref();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String string2 = string;
        int n = 1;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        String href = string4;
        byte[] byArray = fetcher.getContainer().data(href);
        String fileData = new String(byArray, Charsets.UTF_8);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postAtFrontOfQueue(new Runnable(this, link, searchQuery, fileData){
            final /* synthetic */ SearchQueryHandler this$0;
            final /* synthetic */ Link $link;
            final /* synthetic */ String $searchQuery;
            final /* synthetic */ String $fileData;

            public final void run() {
                SearchQueryHandler.access$runWebviewForRangyFind(this.this$0, this.$link, this.$searchQuery, this.$fileData);
            }
            {
                this.this$0 = searchQueryHandler;
                this.$link = link;
                this.$searchQuery = string;
                this.$fileData = string2;
            }
        });
        SearchQueryHandler searchQueryHandler = this;
        synchronized (searchQueryHandler) {
            SearchQueryHandler searchQueryHandler2 = this;
            if (searchQueryHandler2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Object");
            }
            ((Object)((Object)searchQueryHandler2)).wait(60000L);
            Unit unit = Unit.INSTANCE;
        }
        return this.searchLocators;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private final void runWebviewForRangyFind(Link link, String searchQuery, String fileData) {
        Log.v((String)LOG_TAG, (String)("-> runWebviewForRangyFind -> " + link.getHref()));
        Context context = ClientAppContext.get();
        WebView webView = this.webView = new WebView(context);
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        WebSettings webSettings = webView.getSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)webSettings, (String)"webView.settings");
        webSettings.setJavaScriptEnabled(true);
        String scriptTagTemplate = "<script type=\"text/javascript\" src=\"%s\"></script>\n";
        String assetsPath = "file:///android_asset/org/readium/r2/streamer/";
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Object[] objectArray = new Object[]{assetsPath + "js/search-bridge.js"};
        String string = String.format(scriptTagTemplate, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
        String jsInjection = string;
        stringCompanionObject = StringCompanionObject.INSTANCE;
        objectArray = new Object[]{assetsPath + "js/libs/rangy/rangy-core.js"};
        StringBuilder stringBuilder = new StringBuilder().append(jsInjection);
        String string2 = String.format(scriptTagTemplate, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String string3 = string2;
        jsInjection = stringBuilder.append(string3).toString();
        stringCompanionObject = StringCompanionObject.INSTANCE;
        objectArray = new Object[]{assetsPath + "js/libs/rangy/rangy-textrange.js"};
        stringBuilder = new StringBuilder().append(jsInjection);
        String string4 = String.format(scriptTagTemplate, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
        string3 = string4;
        jsInjection = stringBuilder.append(string3).toString();
        stringCompanionObject = StringCompanionObject.INSTANCE;
        objectArray = new Object[]{assetsPath + "js/libs/cfi/develop/readium-cfi.umd.js"};
        stringBuilder = new StringBuilder().append(jsInjection);
        String string5 = String.format(scriptTagTemplate, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(format, *args)");
        string3 = string5;
        jsInjection = stringBuilder.append(string3).toString();
        String modifiedFileData = StringsKt.replace$default((String)fileData, (String)"</head>", (String)(jsInjection + "</head>"), (boolean)false, (int)4, null);
        WebView webView2 = this.webView;
        if (webView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        webView2.setWebViewClient(new WebViewClient(this, link, searchQuery){
            final /* synthetic */ SearchQueryHandler this$0;
            final /* synthetic */ Link $link;
            final /* synthetic */ String $searchQuery;

            public void onPageFinished(@Nullable WebView view, @Nullable String url) {
                Log.v((String)SearchQueryHandler.Companion.getLOG_TAG(), (String)("-> onPageFinished -> " + this.$link.getHref()));
                String searchMethod = "javascript:getLocatorsUsingRangyFind(\"%s\")";
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Object[] objectArray = new Object[]{this.$searchQuery};
                String string = String.format(searchMethod, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
                searchMethod = string;
                SearchQueryHandler.access$getWebView$p(this.this$0).evaluateJavascript(searchMethod, (ValueCallback)new ValueCallback<String>(this){
                    final /* synthetic */ runWebviewForRangyFind.1 this$0;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void onReceiveValue(@Nullable String value) {
                        Log.v((String)SearchQueryHandler.Companion.getLOG_TAG(), (String)("-> getLocatorsUsingRangyFind returned -> " + this.this$0.$link.getHref()));
                        SearchQueryHandler.access$addLocators(this.this$0.this$0, value, this.this$0.$link);
                        SearchQueryHandler searchQueryHandler = this.this$0.this$0;
                        synchronized (searchQueryHandler) {
                            SearchQueryHandler searchQueryHandler2 = this.this$0.this$0;
                            if (searchQueryHandler2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.Object");
                            }
                            ((Object)((Object)searchQueryHandler2)).notify();
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = $outer;
                this.$link = $captured_local_variable$1;
                this.$searchQuery = $captured_local_variable$2;
            }
        });
        WebView webView3 = this.webView;
        if (webView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        webView3.loadDataWithBaseURL("", modifiedFileData, link.getTypeLink(), "UTF-8", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Locator> windowFindSolution(Link link, String searchQuery, Fetcher fetcher) {
        Log.d((String)LOG_TAG, (String)("-> windowFindSolution -> " + link.getHref()));
        if (Intrinsics.areEqual((Object)link.getTypeLink(), (Object)"application/xhtml+xml") ^ true) {
            return new ArrayList();
        }
        String string = link.getHref();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String string2 = string;
        int n = 1;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        String href = string4;
        byte[] byArray = fetcher.getContainer().data(href);
        String fileData = new String(byArray, Charsets.UTF_8);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postAtFrontOfQueue(new Runnable(this, link, searchQuery, fileData){
            final /* synthetic */ SearchQueryHandler this$0;
            final /* synthetic */ Link $link;
            final /* synthetic */ String $searchQuery;
            final /* synthetic */ String $fileData;

            public final void run() {
                SearchQueryHandler.access$runWebviewForWindowFind(this.this$0, this.$link, this.$searchQuery, this.$fileData);
            }
            {
                this.this$0 = searchQueryHandler;
                this.$link = link;
                this.$searchQuery = string;
                this.$fileData = string2;
            }
        });
        SearchQueryHandler searchQueryHandler = this;
        synchronized (searchQueryHandler) {
            SearchQueryHandler searchQueryHandler2 = this;
            if (searchQueryHandler2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Object");
            }
            ((Object)((Object)searchQueryHandler2)).wait(60000L);
            Unit unit = Unit.INSTANCE;
        }
        return this.searchLocators;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private final void runWebviewForWindowFind(Link link, String searchQuery, String fileData) {
        Log.v((String)LOG_TAG, (String)("-> runWebviewForWindowFind -> " + link.getHref()));
        Context context = ClientAppContext.get();
        WebView webView = this.webView = new WebView(context);
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        WebSettings webSettings = webView.getSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)webSettings, (String)"webView.settings");
        webSettings.setJavaScriptEnabled(true);
        String scriptTagTemplate = "<script type=\"text/javascript\" src=\"%s\"></script>\n";
        String assetsPath = "file:///android_asset/org/readium/r2/streamer/";
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Object[] objectArray = new Object[]{assetsPath + "js/search-bridge.js"};
        String string = String.format(scriptTagTemplate, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
        String jsInjection = string;
        stringCompanionObject = StringCompanionObject.INSTANCE;
        objectArray = new Object[]{assetsPath + "js/libs/cfi/develop/readium-cfi.umd.js"};
        StringBuilder stringBuilder = new StringBuilder().append(jsInjection);
        String string2 = String.format(scriptTagTemplate, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String string3 = string2;
        jsInjection = stringBuilder.append(string3).toString();
        String modifiedFileData = StringsKt.replace$default((String)fileData, (String)"</head>", (String)(jsInjection + "</head>"), (boolean)false, (int)4, null);
        WebView webView2 = this.webView;
        if (webView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        webView2.setWebViewClient(new WebViewClient(this, link, searchQuery){
            final /* synthetic */ SearchQueryHandler this$0;
            final /* synthetic */ Link $link;
            final /* synthetic */ String $searchQuery;

            public void onPageFinished(@Nullable WebView view, @Nullable String url) {
                Log.v((String)SearchQueryHandler.Companion.getLOG_TAG(), (String)("-> onPageFinished -> " + this.$link.getHref()));
                String searchMethod = "javascript:getLocatorsUsingWindowFind(\"%s\")";
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Object[] objectArray = new Object[]{this.$searchQuery};
                String string = String.format(searchMethod, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
                searchMethod = string;
                SearchQueryHandler.access$getWebView$p(this.this$0).evaluateJavascript(searchMethod, (ValueCallback)new ValueCallback<String>(this){
                    final /* synthetic */ runWebviewForWindowFind.1 this$0;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void onReceiveValue(@Nullable String value) {
                        Log.v((String)SearchQueryHandler.Companion.getLOG_TAG(), (String)("-> getLocatorsUsingWindowFind returned -> " + this.this$0.$link.getHref()));
                        SearchQueryHandler.access$addLocators(this.this$0.this$0, value, this.this$0.$link);
                        SearchQueryHandler searchQueryHandler = this.this$0.this$0;
                        synchronized (searchQueryHandler) {
                            SearchQueryHandler searchQueryHandler2 = this.this$0.this$0;
                            if (searchQueryHandler2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.Object");
                            }
                            ((Object)((Object)searchQueryHandler2)).notify();
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = $outer;
                this.$link = $captured_local_variable$1;
                this.$searchQuery = $captured_local_variable$2;
            }
        });
        WebView webView3 = this.webView;
        if (webView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        webView3.loadDataWithBaseURL("", modifiedFileData, link.getTypeLink(), "UTF-8", null);
    }

    /*
     * WARNING - void declaration
     */
    private final void addLocators(String locatorsJsonString, Link link) {
        try {
            JSONArray locatorsJson = new JSONArray(locatorsJsonString);
            int n = 0;
            int n2 = locatorsJson.length();
            while (n < n2) {
                void i;
                JSONObject locatorJson = locatorsJson.getJSONObject((int)i);
                JSONObject locationsJson = locatorJson.getJSONObject("locations");
                Locations locations = new Locations(null, null, null, null, null, null, 63, null);
                locations.setCfi(locationsJson.getString("cfi"));
                JSONObject textJson = locatorJson.getJSONObject("text");
                LocatorText text = new LocatorText(null, null, null, 7, null);
                text.setBefore(textJson.getString("before"));
                text.setHightlight(textJson.getString("highlight"));
                text.setAfter(textJson.getString("after"));
                String title = locatorJson.optString("title");
                String string = link.getHref();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                long l = new Date().getTime();
                String string2 = title;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"title");
                Locator locator = new Locator(string, l, string2, locations, text);
                this.searchLocators.add(locator);
                ++i;
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"->", (Throwable)e);
        }
    }

    public SearchQueryHandler() {
        List list;
        SearchQueryHandler searchQueryHandler = this;
        searchQueryHandler.searchLocators = list = (List)new ArrayList();
    }

    static {
        Companion = new Companion(null);
        String string = SearchQueryHandler.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"SearchQueryHandler::class.java.simpleName");
        LOG_TAG = string;
    }

    public static final /* synthetic */ void access$runWebviewForRangyFind(SearchQueryHandler $this, @NotNull Link link, @NotNull String searchQuery, @NotNull String fileData) {
        $this.runWebviewForRangyFind(link, searchQuery, fileData);
    }

    @NotNull
    public static final /* synthetic */ WebView access$getWebView$p(SearchQueryHandler $this) {
        WebView webView = $this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        return webView;
    }

    public static final /* synthetic */ void access$setWebView$p(SearchQueryHandler $this, @NotNull WebView webView) {
        $this.webView = webView;
    }

    public static final /* synthetic */ void access$addLocators(SearchQueryHandler $this, @Nullable String locatorsJsonString, @NotNull Link link) {
        $this.addLocators(locatorsJsonString, link);
    }

    public static final /* synthetic */ void access$runWebviewForWindowFind(SearchQueryHandler $this, @NotNull Link link, @NotNull String searchQuery, @NotNull String fileData) {
        $this.runWebviewForWindowFind(link, searchQuery, fileData);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/readium/r2/streamer/server/handler/SearchQueryHandler$Companion;", "", "()V", "LOG_TAG", "", "getLOG_TAG", "()Ljava/lang/String;", "r2-streamer-kotlin_devFolioReaderRelease"})
    public static final class Companion {
        @NotNull
        public final String getLOG_TAG() {
            return LOG_TAG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

