/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.fetcher;

import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.Publication;
import org.readium.r2.shared.PublicationKt;
import org.readium.r2.shared.ReadiumCSSName;
import org.readium.r2.shared.RenditionLayout;
import org.readium.r2.streamer.container.Container;
import org.readium.r2.streamer.fetcher.ContentFilters;
import org.readium.r2.streamer.fetcher.ContentFiltersEpub$WhenMappings;
import org.readium.r2.streamer.fetcher.DrmDecoder;
import org.readium.r2.streamer.fetcher.FontDecoder;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J(\u0010\u0011\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u001e\u0010\u001a\u001a\u00020\u001b2\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001dH\u0002J\u001c\u0010 \u001a\u00020\u00032\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\"H\u0002J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003H\u0002J\u0010\u0010%\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003H\u0002J\u0010\u0010&\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003H\u0002J*\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\"2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\"H\u0002J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u0012H\u0002J\u0018\u0010*\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/readium/r2/streamer/fetcher/ContentFiltersEpub;", "Lorg/readium/r2/streamer/fetcher/ContentFilters;", "userPropertiesPath", "", "(Ljava/lang/String;)V", "drmDecoder", "Lorg/readium/r2/streamer/fetcher/DrmDecoder;", "getDrmDecoder", "()Lorg/readium/r2/streamer/fetcher/DrmDecoder;", "setDrmDecoder", "(Lorg/readium/r2/streamer/fetcher/DrmDecoder;)V", "fontDecoder", "Lorg/readium/r2/streamer/fetcher/FontDecoder;", "getFontDecoder", "()Lorg/readium/r2/streamer/fetcher/FontDecoder;", "setFontDecoder", "(Lorg/readium/r2/streamer/fetcher/FontDecoder;)V", "apply", "Ljava/io/InputStream;", "input", "publication", "Lorg/readium/r2/shared/Publication;", "container", "Lorg/readium/r2/streamer/container/Container;", "path", "", "applyPreset", "Lorg/json/JSONObject;", "preset", "Lkotlin/Pair;", "Lorg/readium/r2/shared/ReadiumCSSName;", "", "buildStringProperties", "list", "", "getHtmlFont", "resourceName", "getHtmlLink", "getHtmlScript", "getProperties", "injectFixedLayoutHtml", "stream", "injectReflowableHtml", "r2-streamer-kotlin_devFolioReaderRelease"})
public final class ContentFiltersEpub
implements ContentFilters {
    @NotNull
    private FontDecoder fontDecoder;
    @NotNull
    private DrmDecoder drmDecoder;
    private final String userPropertiesPath;

    @Override
    @NotNull
    public FontDecoder getFontDecoder() {
        return this.fontDecoder;
    }

    @Override
    public void setFontDecoder(@NotNull FontDecoder fontDecoder) {
        Intrinsics.checkParameterIsNotNull((Object)fontDecoder, (String)"<set-?>");
        this.fontDecoder = fontDecoder;
    }

    @Override
    @NotNull
    public DrmDecoder getDrmDecoder() {
        return this.drmDecoder;
    }

    @Override
    public void setDrmDecoder(@NotNull DrmDecoder drmDecoder) {
        Intrinsics.checkParameterIsNotNull((Object)drmDecoder, (String)"<set-?>");
        this.drmDecoder = drmDecoder;
    }

    @Override
    @NotNull
    public InputStream apply(@NotNull InputStream input, @NotNull Publication publication, @NotNull Container container, @NotNull String path) {
        ContentFiltersEpub contentFiltersEpub;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Link link = publication.linkWithHref(path);
        if (link != null) {
            Link link2;
            Link resourceLink = link2 = link;
            InputStream decodedInputStream = this.getDrmDecoder().decoding(input, resourceLink, container.getDrm());
            decodedInputStream = this.getFontDecoder().decoding(decodedInputStream, publication, path);
            if (Intrinsics.areEqual((Object)resourceLink.getTypeLink(), (Object)"application/xhtml+xml") || Intrinsics.areEqual((Object)resourceLink.getTypeLink(), (Object)"text/html")) {
                decodedInputStream = publication.getMetadata().getRendition().getLayout() == RenditionLayout.Reflowable && resourceLink.getProperties().getLayout() == null || Intrinsics.areEqual((Object)resourceLink.getProperties().getLayout(), (Object)"reflowable") ? this.injectReflowableHtml(decodedInputStream, publication) : this.injectFixedLayoutHtml(decodedInputStream);
            }
            return decodedInputStream;
        }
        ContentFiltersEpub $receiver = contentFiltersEpub = this;
        return input;
    }

    @Override
    @NotNull
    public byte[] apply(@NotNull byte[] input, @NotNull Publication publication, @NotNull Container container, @NotNull String path) {
        ContentFiltersEpub contentFiltersEpub;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Link link = publication.linkWithHref(path);
        if (link != null) {
            URL baseUrl;
            Link link2;
            Link resourceLink = link2 = link;
            byte[] byArray = input;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(byArray);
            InputStream decodedInputStream = this.getDrmDecoder().decoding(inputStream, resourceLink, container.getDrm());
            decodedInputStream = this.getFontDecoder().decoding(decodedInputStream, publication, path);
            URL uRL = publication.baseUrl();
            URL uRL2 = baseUrl = uRL != null ? PublicationKt.removeLastComponent((URL)uRL) : null;
            if ((Intrinsics.areEqual((Object)resourceLink.getTypeLink(), (Object)"application/xhtml+xml") || Intrinsics.areEqual((Object)resourceLink.getTypeLink(), (Object)"text/html")) && baseUrl != null) {
                decodedInputStream = publication.getMetadata().getRendition().getLayout() == RenditionLayout.Reflowable && (resourceLink.getProperties().getLayout() == null || Intrinsics.areEqual((Object)resourceLink.getProperties().getLayout(), (Object)"reflowable")) ? this.injectReflowableHtml(decodedInputStream, publication) : this.injectFixedLayoutHtml(decodedInputStream);
            }
            return ByteStreamsKt.readBytes((InputStream)decodedInputStream);
        }
        ContentFiltersEpub $receiver = contentFiltersEpub = this;
        return input;
    }

    private final InputStream injectReflowableHtml(InputStream stream, Publication publication) {
        Object object;
        String string;
        byte[] data = ByteStreamsKt.readBytes((InputStream)stream);
        String resourceHtml = string = new String(data, Charsets.UTF_8);
        int beginHeadIndex = StringsKt.indexOf((CharSequence)resourceHtml, (String)"<head>", (int)0, (boolean)false) + 6;
        int endHeadIndex = StringsKt.indexOf((CharSequence)resourceHtml, (String)"</head>", (int)0, (boolean)false);
        if (endHeadIndex == -1) {
            return stream;
        }
        String cssStyle = publication.getCssStyle();
        List endIncludes = new ArrayList();
        List beginIncludes = new ArrayList();
        beginIncludes.add("<meta name=\"viewport\" content=\"width=device-width, height=device-height, initial-scale=1.0, maximum-scale=1.0, user-scalable=0\" />");
        beginIncludes.add(this.getHtmlLink("/styles/" + cssStyle + "-before.css"));
        beginIncludes.add(this.getHtmlLink("/styles/" + cssStyle + "-default.css"));
        endIncludes.add(this.getHtmlLink("/styles/" + cssStyle + "-after.css"));
        endIncludes.add(this.getHtmlScript("/scripts/touchHandling.js"));
        endIncludes.add(this.getHtmlScript("/scripts/utils.js"));
        for (String element : beginIncludes) {
            Intrinsics.checkExpressionValueIsNotNull((Object)new StringBuilder(resourceHtml).insert(beginHeadIndex, element).toString(), (String)"StringBuilder(resourceHt\u2026ndex, element).toString()");
            beginHeadIndex += element.length();
            endHeadIndex += element.length();
        }
        for (String element : endIncludes) {
            Intrinsics.checkExpressionValueIsNotNull((Object)new StringBuilder(resourceHtml).insert(endHeadIndex, element).toString(), (String)"StringBuilder(resourceHt\u2026ndex, element).toString()");
            endHeadIndex += element.length();
        }
        String string2 = new StringBuilder(resourceHtml).insert(endHeadIndex, this.getHtmlFont("/fonts/OpenDyslexic-Regular.otf")).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder(resourceHt\u2026Regular.otf\")).toString()");
        resourceHtml = string2;
        String string3 = new StringBuilder(resourceHtml).insert(endHeadIndex, "<style>@import url('https://fonts.googleapis.com/css?family=PT+Serif|Roboto|Source+Sans+Pro|Vollkorn');</style>\n").toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"StringBuilder(resourceHt\u2026);</style>\\n\").toString()");
        resourceHtml = string3;
        Map<String, String> map = this.getProperties(publication.getUserSettingsUIPreset());
        if (map != null) {
            MatchResult html;
            object = map;
            Map<String, String> propertyPair = object;
            MatchResult matchResult = html = new Regex("<html.*>").find((CharSequence)resourceHtml, 0);
            if (matchResult != null) {
                MatchResult matchResult2;
                MatchResult it = matchResult2 = matchResult;
                MatchResult match = new Regex("(style=(\"([^\"]*)\"[ >]))|(style='([^']*)'[ >])").find((CharSequence)html.getValue(), 0);
                if (match != null) {
                    String string4;
                    int beginStyle = match.getRange().getStart() + 7;
                    String newHtml = html.getValue();
                    String string5 = new StringBuilder(newHtml).insert(beginStyle, this.buildStringProperties(propertyPair) + ' ').toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"StringBuilder(newHtml).i\u2026pertyPair)} \").toString()");
                    newHtml = string5;
                    CharSequence charSequence = new StringBuilder(resourceHtml);
                    Regex regex = new Regex("<html.*>");
                    resourceHtml = string4 = regex.replace(charSequence, newHtml);
                } else {
                    int beginHtmlIndex = StringsKt.indexOf((CharSequence)resourceHtml, (String)"<html", (int)0, (boolean)false) + 5;
                    String string6 = new StringBuilder(resourceHtml).insert(beginHtmlIndex, " style=\"" + this.buildStringProperties(propertyPair) + '\"').toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"StringBuilder(resourceHt\u2026ertyPair)}\\\"\").toString()");
                    resourceHtml = string6;
                }
            } else {
                ContentFiltersEpub contentFiltersEpub;
                ContentFiltersEpub $receiver = contentFiltersEpub = this;
                int beginHtmlIndex = StringsKt.indexOf((CharSequence)resourceHtml, (String)"<html", (int)0, (boolean)false) + 5;
                String string7 = new StringBuilder(resourceHtml).insert(beginHtmlIndex, " style=\"" + $receiver.buildStringProperties(propertyPair) + '\"').toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"StringBuilder(resourceHt\u2026ertyPair)}\\\"\").toString()");
                resourceHtml = string7;
            }
        }
        object = resourceHtml;
        Charset charset = Charsets.UTF_8;
        Object object2 = object;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = ((String)object2).getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        object = byArray;
        return new ByteArrayInputStream((byte[])object);
    }

    private final InputStream injectFixedLayoutHtml(InputStream stream) {
        byte[] data = ByteStreamsKt.readBytes((InputStream)stream);
        String resourceHtml = new String(data, Charsets.UTF_8);
        int endHeadIndex = StringsKt.indexOf((CharSequence)resourceHtml, (String)"</head>", (int)0, (boolean)false);
        if (endHeadIndex == -1) {
            return stream;
        }
        List includes = new ArrayList();
        includes.add(this.getHtmlScript("/scripts/touchHandling.js"));
        includes.add(this.getHtmlScript("/scripts/utils.js"));
        for (String element : includes) {
            Intrinsics.checkExpressionValueIsNotNull((Object)new StringBuilder(resourceHtml).insert(endHeadIndex, element).toString(), (String)"StringBuilder(resourceHt\u2026ndex, element).toString()");
        }
        Object object = resourceHtml;
        Charset charset = Charsets.UTF_8;
        String string = object;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        object = byArray;
        return new ByteArrayInputStream((byte[])object);
    }

    private final String getHtmlFont(String resourceName) {
        String prefix = "<style type=\"text/css\"> @font-face{font-family: \"OpenDyslexic\"; src:url(\"";
        String suffix = "\") format('truetype');}</style>\n";
        return prefix + resourceName + suffix;
    }

    private final String getHtmlLink(String resourceName) {
        String prefix = "<link rel=\"stylesheet\" type=\"text/css\" href=\"";
        String suffix = "\"/>\n";
        return prefix + resourceName + suffix;
    }

    private final String getHtmlScript(String resourceName) {
        String prefix = "<script type=\"text/javascript\" src=\"";
        String suffix = "\"></script>\n";
        return prefix + resourceName + suffix;
    }

    private final Map<String, String> getProperties(Map<ReadiumCSSName, Boolean> preset) {
        Map map;
        String it;
        String string;
        String userPropertiesString = null;
        String string2 = this.userPropertiesPath;
        if (string2 != null) {
            it = string = string2;
            userPropertiesString = new String();
            File file = new File(it);
            if (file.isFile() && file.canRead()) {
                for (String i : FilesKt.readLines$default((File)file, null, (int)1, null)) {
                    userPropertiesString = Intrinsics.stringPlus((String)userPropertiesString, (Object)i);
                }
            }
        }
        String string3 = userPropertiesString;
        if (string3 != null) {
            Map map2;
            it = string = string3;
            try {
                JSONArray propertiesArray = new JSONArray(userPropertiesString);
                Map properties = new LinkedHashMap();
                int i = 0;
                int n = propertiesArray.length() - 1;
                if (i <= n) {
                    while (true) {
                        JSONObject value = new JSONObject(propertiesArray.getString(i));
                        boolean isInPreset = false;
                        Map<ReadiumCSSName, Boolean> map3 = preset;
                        for (Map.Entry<ReadiumCSSName, Boolean> property : map3.entrySet()) {
                            if (!Intrinsics.areEqual((Object)property.getKey().getRef(), (Object)value.getString("name"))) continue;
                            isInPreset = true;
                            Pair presetPair = new Pair((Object)property.getKey(), (Object)preset.get(property.getKey()));
                            JSONObject presetValue = this.applyPreset((Pair<? extends ReadiumCSSName, Boolean>)presetPair);
                            String string4 = presetValue.getString("name");
                            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"presetValue.getString(\"name\")");
                            String string5 = presetValue.getString("value");
                            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"presetValue.getString(\"value\")");
                            properties.put(string4, string5);
                        }
                        if (!isInPreset) {
                            String string6 = value.getString("name");
                            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"value.getString(\"name\")");
                            String string7 = value.getString("value");
                            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"value.getString(\"value\")");
                            properties.put(string6, string7);
                        }
                        if (i == n) break;
                        ++i;
                    }
                }
                map2 = properties;
            }
            catch (Exception e) {
                Log.e((String)"ContentFilter", (String)("Error parsing json : " + e));
                map2 = null;
            }
            map = map2;
        } else {
            map = null;
        }
        return map;
    }

    private final JSONObject applyPreset(Pair<? extends ReadiumCSSName, Boolean> preset) {
        JSONObject readiumCSSProperty = new JSONObject();
        readiumCSSProperty.put("name", (Object)((ReadiumCSSName)preset.getFirst()).getRef());
        switch (ContentFiltersEpub$WhenMappings.$EnumSwitchMapping$0[((ReadiumCSSName)preset.getFirst()).ordinal()]) {
            case 1: {
                readiumCSSProperty.put("value", (Object)"");
                break;
            }
            case 2: {
                readiumCSSProperty.put("value", (Object)"readium-font-off");
                break;
            }
            case 3: {
                readiumCSSProperty.put("value", (Object)"readium-default-on");
                break;
            }
            case 4: {
                readiumCSSProperty.put("value", (Object)"");
                break;
            }
            case 5: {
                readiumCSSProperty.put("value", (Object)"auto");
                break;
            }
            case 6: {
                readiumCSSProperty.put("value", (Object)"0.5");
                break;
            }
            case 7: {
                readiumCSSProperty.put("value", (Object)"1.0");
                break;
            }
            case 8: {
                readiumCSSProperty.put("value", (Object)"");
                break;
            }
            case 9: {
                readiumCSSProperty.put("value", (Object)"Original");
                break;
            }
            case 10: {
                readiumCSSProperty.put("value", (Object)"100%");
                break;
            }
            case 11: {
                readiumCSSProperty.put("value", (Object)"0.0rem");
                break;
            }
            case 12: {
                readiumCSSProperty.put("value", (Object)"0.0em");
                break;
            }
            case 13: {
                readiumCSSProperty.put("value", (Object)"justify");
                break;
            }
            case 14: {
                readiumCSSProperty.put("value", (Object)"");
                break;
            }
            case 15: {
                Object object = preset.getSecond();
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                if (((Boolean)object).booleanValue()) {
                    readiumCSSProperty.put("value", (Object)"readium-scroll-on");
                    break;
                }
                readiumCSSProperty.put("value", (Object)"readium-scroll-off");
            }
        }
        return readiumCSSProperty;
    }

    private final String buildStringProperties(Map<String, String> list) {
        String string = "";
        Map<String, String> map = list;
        for (Map.Entry<String, String> property : map.entrySet()) {
            string = string + " " + property.getKey() + ": " + property.getValue() + ";";
        }
        return string;
    }

    public ContentFiltersEpub(@Nullable String userPropertiesPath) {
        this.userPropertiesPath = userPropertiesPath;
        this.fontDecoder = new FontDecoder();
        this.drmDecoder = new DrmDecoder();
    }
}

