/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.container;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.streamer.container.Container;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/readium/r2/streamer/container/ZipArchiveContainer;", "Lorg/readium/r2/streamer/container/Container;", "zipFile", "Ljava/util/zip/ZipFile;", "getZipFile", "()Ljava/util/zip/ZipFile;", "setZipFile", "(Ljava/util/zip/ZipFile;)V", "data", "", "relativePath", "", "dataInputStream", "Ljava/io/InputStream;", "dataLength", "", "getEntry", "Ljava/util/zip/ZipEntry;", "r2-streamer-kotlin_devFolioReaderRelease"})
public interface ZipArchiveContainer
extends Container {
    @NotNull
    public ZipFile getZipFile();

    public void setZipFile(@NotNull ZipFile var1);

    @Override
    @NotNull
    public byte[] data(@NotNull String var1);

    @Override
    public long dataLength(@NotNull String var1);

    @Override
    @NotNull
    public InputStream dataInputStream(@NotNull String var1);

    @Nullable
    public ZipEntry getEntry(@NotNull String var1);

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static byte[] data(ZipArchiveContainer $this, @NotNull String relativePath) {
            Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
            ZipEntry zipEntry = $this.getEntry(relativePath);
            InputStream inputStream = $this.getZipFile().getInputStream(zipEntry);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            int readLength = 0;
            byte[] buffer = new byte[16384];
            while (true) {
                int n;
                int it;
                readLength = it = (n = inputStream.read(buffer));
                if (!(it != -1)) break;
                outputStream.write(buffer, 0, readLength);
            }
            inputStream.close();
            byte[] byArray = outputStream.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"outputStream.toByteArray()");
            return byArray;
        }

        public static long dataLength(ZipArchiveContainer $this, @NotNull String relativePath) {
            Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
            return $this.getZipFile().size();
        }

        @NotNull
        public static InputStream dataInputStream(ZipArchiveContainer $this, @NotNull String relativePath) {
            Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
            InputStream inputStream = $this.getZipFile().getInputStream($this.getEntry(relativePath));
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"zipFile.getInputStream(getEntry(relativePath))");
            return inputStream;
        }

        @Nullable
        public static ZipEntry getEntry(ZipArchiveContainer $this, @NotNull String relativePath) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
            try {
                String string2 = new URI(relativePath).getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"URI(relativePath).path");
                string = string2;
            }
            catch (Exception e) {
                string = relativePath;
            }
            String path = string;
            ZipEntry zipEntry = $this.getZipFile().getEntry(path);
            if (zipEntry != null) {
                return zipEntry;
            }
            Enumeration<? extends ZipEntry> zipEntries = $this.getZipFile().entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry2 = zipEntry = zipEntries.nextElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)zipEntry2, (String)"zipEntry");
                if (!StringsKt.equals((String)path, (String)zipEntry2.getName(), (boolean)true)) continue;
                return zipEntry;
            }
            return null;
        }
    }
}

