/*
 * Decompiled with CFR 0.152.
 */
package com.codekidlabs.storagechooser;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.support.v4.app.FragmentManager;
import com.codekidlabs.storagechooser.fragments.ChooserDialogFragment;
import com.codekidlabs.storagechooser.models.Config;

public class StorageChooserBuilder {
    public static Dialog dialog;
    public static String STORAGE_STATIC_PATH;
    public static Config sConfig;
    private Activity chooserActivity;

    public StorageChooserBuilder(Activity activity, Config config) {
        StorageChooserBuilder.setsConfig(config);
        this.setChooserActivity(activity);
    }

    public void init() {
        dialog = StorageChooserBuilder.getStorageChooserDialog(this.getChooserActivity());
        ChooserDialogFragment chooserDialogFragment = new ChooserDialogFragment();
        chooserDialogFragment.show(sConfig.getFragmentManager(), "storagechooser_dialog");
    }

    public static Config getsConfig() {
        return sConfig;
    }

    public static void setsConfig(Config sConfig) {
        StorageChooserBuilder.sConfig = sConfig;
    }

    private Activity getChooserActivity() {
        return this.chooserActivity;
    }

    private void setChooserActivity(Activity chooserActivity) {
        this.chooserActivity = chooserActivity;
    }

    private static Dialog getStorageChooserDialog(Activity activity) {
        return new Dialog((Context)activity);
    }

    public static class Builder {
        private Activity mActivity;
        private FragmentManager mFragmentManager;
        private int mMemorySize;
        private String mMemorySuffix;
        private boolean mActionSave;
        private String mPath;
        private SharedPreferences mSharedPreferences;
        private String mSharedPreferencesKey;
        private boolean mShowMemoryBar;

        public Builder withActivity(Activity activity) {
            this.mActivity = activity;
            return this;
        }

        public Builder withFragmentManager(FragmentManager fragmentManager) {
            this.mFragmentManager = fragmentManager;
            return this;
        }

        public Builder withMemoryBar(boolean memoryBarBoolean) {
            this.mShowMemoryBar = memoryBarBoolean;
            return this;
        }

        public Builder withPredefinedPath(String path) {
            this.mPath = path;
            return this;
        }

        public Builder withMemoryThreshold(int size, String suffix) {
            this.mMemorySize = size;
            this.mMemorySuffix = suffix;
            return this;
        }

        public Builder withPreference(SharedPreferences sharedPreferences) {
            this.mSharedPreferences = sharedPreferences;
            return this;
        }

        public Builder actionSave(boolean save) {
            this.mActionSave = save;
            return this;
        }

        public Builder build() {
            return this;
        }

        public void show() {
            Config devConfig = new Config();
            devConfig.setActionSave(this.mActionSave);
            devConfig.setPredefinedPath(this.mPath);
            devConfig.setFragmentManager(this.mFragmentManager);
            devConfig.setPreference(this.mSharedPreferences);
            devConfig.setShowMemoryBar(this.mShowMemoryBar);
            devConfig.setMemoryThreshold(this.mMemorySize);
            devConfig.setThresholdSuffix(this.mMemorySuffix);
            new StorageChooserBuilder(this.mActivity, devConfig).init();
        }
    }
}

