/*
 * Decompiled with CFR 0.152.
 */
package com.codekidlabs.storagechooser.adapters;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.codekidlabs.storagechooser.R;
import com.codekidlabs.storagechooser.models.Storages;
import java.util.List;

public class StorageChooserListAdapter
extends BaseAdapter {
    private List<Storages> storagesList;
    private Context mContext;
    private boolean shouldShowMemoryBar;

    public StorageChooserListAdapter(List<Storages> storagesList, Context mContext, boolean shouldShowMemoryBar) {
        this.storagesList = storagesList;
        this.mContext = mContext;
        this.shouldShowMemoryBar = shouldShowMemoryBar;
    }

    public int getCount() {
        return this.storagesList.size();
    }

    public Object getItem(int i) {
        return this.storagesList.get(i);
    }

    public long getItemId(int i) {
        return i;
    }

    public View getView(int i, View view, ViewGroup viewGroup) {
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        View rootView = inflater.inflate(R.layout.row_storage, viewGroup, false);
        TextView storageName = (TextView)rootView.findViewById(R.id.storage_name);
        TextView memoryStatus = (TextView)rootView.findViewById(R.id.memory_status);
        ProgressBar memoryBar = (ProgressBar)rootView.findViewById(R.id.memory_bar);
        Storages storages = this.storagesList.get(i);
        SpannableStringBuilder str = new SpannableStringBuilder((CharSequence)(storages.getStorageTitle() + " (" + storages.getMemoryTotalSize() + ")"));
        str.setSpan((Object)new StyleSpan(2), this.getSpannableIndex(str), str.length(), 33);
        String availableText = storages.getMemoryAvailableSize() + " free";
        storageName.setText((CharSequence)str);
        memoryStatus.setText((CharSequence)availableText);
        if (this.shouldShowMemoryBar) {
            memoryBar.setMax(100);
            memoryBar.setProgress(this.getPercentile(storages.getMemoryAvailableSize(), storages.getMemoryTotalSize()));
        } else {
            memoryBar.setVisibility(8);
        }
        return rootView;
    }

    private int getSpannableIndex(SpannableStringBuilder str) {
        return str.toString().indexOf("(") + 1;
    }

    private int getPercentile(String memoryAvailableSize, String memoryTotalSize) {
        int percent = this.getMemoryFromString(memoryAvailableSize) * 100 / this.getMemoryFromString(memoryTotalSize);
        Log.d((String)"TAG", (String)("percentage: " + percent));
        return 100 - percent;
    }

    private int getMemoryFromString(String size) {
        int mem = Integer.parseInt(size.replace(",", "").replace("GiB", ""));
        Log.d((String)"TAG", (String)("Memory:" + mem));
        return mem;
    }
}

