/*
 * Decompiled with CFR 0.152.
 */
package com.codekidlabs.storagechooser.utils;

import android.os.StatFs;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;

public class MemoryUtil {
    public static final String SELF_DIR_NAME = "self";
    public static final String EMULATED_DIR_NAME = "emulated";
    public static final String EMULATED_DIR_KNOX = "knox-emulated";
    public static final String SDCARD0_DIR_NAME = "sdcard0";
    public static final String CONTAINER = "container";
    private static final String ERROR = "error";

    public boolean isExternalStoragePresent() {
        return this.getStorageListSize() != 1;
    }

    public int getStorageListSize() {
        File storageDir = new File("/storage");
        ArrayList volumeList = new ArrayList();
        Collections.addAll(volumeList, storageDir.listFiles());
        for (int i = 0; i < volumeList.size(); ++i) {
            String storageName = ((File)volumeList.get(i)).getName();
            if (!storageName.equals(SELF_DIR_NAME) && !storageName.equals(EMULATED_DIR_KNOX) && !storageName.equals(EMULATED_DIR_KNOX) && !storageName.equals(SDCARD0_DIR_NAME) && !storageName.equals(CONTAINER)) continue;
            volumeList.remove(i);
        }
        return volumeList.size();
    }

    public long getAvailableMemorySize(String path) {
        File file = new File(path);
        StatFs stat = new StatFs(file.getPath());
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        return availableBlocks * blockSize;
    }

    public long getTotalMemorySize(String path) {
        File file = new File(path);
        StatFs stat = new StatFs(file.getPath());
        long blockSize = stat.getBlockSize();
        long totalBlocks = stat.getBlockCount();
        return totalBlocks * blockSize;
    }

    public String formatSize(long size) {
        String suffix = null;
        if (size >= 1024L) {
            suffix = "KiB";
            if ((size /= 1024L) >= 1024L) {
                suffix = "MiB";
                if ((size /= 1024L) >= 1024L) {
                    suffix = "GiB";
                    size /= 1024L;
                }
            }
        }
        StringBuilder resultBuffer = new StringBuilder(Long.toString(size));
        for (int commaOffset = resultBuffer.length() - 3; commaOffset > 0; commaOffset -= 3) {
            resultBuffer.insert(commaOffset, ',');
        }
        if (suffix != null) {
            resultBuffer.append(suffix);
        }
        return resultBuffer.toString();
    }

    public long suffixedSize(long size, String suffix) {
        switch (suffix) {
            case "KiB": {
                return size / 1024L;
            }
            case "MiB": {
                return (long)((double)size / Math.pow(1024.0, 2.0));
            }
            case "GiB": {
                return (long)((double)size / Math.pow(1024.0, 3.0));
            }
        }
        return 0L;
    }
}

