/*
 * Decompiled with CFR 0.152.
 */
package com.codekidlabs.storagechooser.filters;

import android.util.Log;
import com.codekidlabs.storagechooser.StorageChooser;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

public class UniversalFileFilter
implements FileFilter {
    protected static final String TAG = "UniversalFileFilter";
    private final boolean allowDirectories = true;
    private StorageChooser.FileType fileType;
    private boolean customEnumLock = false;
    private List<String> customEnum;

    public UniversalFileFilter(StorageChooser.FileType fileType) {
        this.fileType = fileType;
    }

    public UniversalFileFilter(boolean customLock, List<String> customEnum) {
        this.customEnumLock = customLock;
        this.customEnum = customEnum;
    }

    private String getFileExtension(File f) {
        return this.getFileExtension(f.getName());
    }

    private String getFileExtension(String fileName) {
        int i = fileName.lastIndexOf(46);
        if (i > 0) {
            return fileName.substring(i + 1);
        }
        return null;
    }

    @Override
    public boolean accept(File f) {
        if (f.isHidden() || !f.canRead()) {
            return false;
        }
        if (f.isDirectory()) {
            return this.findInDirectory(f);
        }
        return this.isFileExtension(f);
    }

    private boolean isFileExtension(File f) {
        String ext = this.getFileExtension(f);
        if (ext == null) {
            return false;
        }
        try {
            if (this.customEnumLock) {
                return this.customEnum.contains(ext);
            }
            if (this.getFormatExtention(ext) != null) {
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return false;
    }

    private Object getFormatExtention(String ext) {
        switch (this.fileType) {
            case VIDEO: {
                return VideoFormat.valueOf(ext.toUpperCase());
            }
            case AUDIO: {
                return AudioFormat.valueOf(ext.toUpperCase());
            }
            case IMAGES: {
                return ImageFormat.valueOf(ext.toUpperCase());
            }
            case DOCS: {
                return DocsFormat.valueOf(ext.toUpperCase());
            }
            case ARCHIVE: {
                return ArchiveFormat.valueOf(ext.toUpperCase());
            }
        }
        return null;
    }

    private boolean findInDirectory(File dir) {
        final ArrayList sub = new ArrayList();
        int indexInList = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isFile()) {
                    if (file.getName().equals(".nomedia")) {
                        return false;
                    }
                    return UniversalFileFilter.this.isFileExtension(file);
                }
                if (file.isDirectory()) {
                    sub.add(file);
                    return false;
                }
                return false;
            }
        }).length;
        if (indexInList > 0) {
            Log.i((String)TAG, (String)("findInDirectory => " + dir.getName() + " return true for => " + indexInList));
            return true;
        }
        for (File subDirectory : sub) {
            if (!this.findInDirectory(subDirectory)) continue;
            Log.i((String)TAG, (String)("findInDirectory => " + subDirectory.toString()));
            return true;
        }
        return false;
    }

    public static enum DocsFormat {
        PDF("pdf"),
        PPT("ppt"),
        DOC("doc"),
        DOCX("docx"),
        EXCEL("xls");

        private String filesuffix;

        private DocsFormat(String filesuffix) {
            this.filesuffix = filesuffix;
        }
    }

    public static enum AudioFormat {
        MP3("mp3"),
        OGG("ogg");

        private String filesuffix;

        private AudioFormat(String filesuffix) {
            this.filesuffix = filesuffix;
        }
    }

    public static enum VideoFormat {
        MP4("mp4"),
        TS("ts"),
        MKV("mkv"),
        AVI("avi"),
        FLV("flv");

        private String filesuffix;

        private VideoFormat(String filesuffix) {
            this.filesuffix = filesuffix;
        }
    }

    public static enum ImageFormat {
        JPG("jpg"),
        JPEG("jpeg"),
        PNG("png"),
        TIFF("tiff"),
        GIF("gif");

        private String filesuffix;

        private ImageFormat(String filesuffix) {
            this.filesuffix = filesuffix;
        }
    }

    public static enum ArchiveFormat {
        ZIP("zip"),
        RAR("rar");

        private String filesuffix;

        private ArchiveFormat(String filesuffix) {
            this.filesuffix = filesuffix;
        }
    }
}

