/*
 * Decompiled with CFR 0.152.
 */
package com.codekidlabs.storagechooser.utils;

import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import com.codekidlabs.storagechooser.fragments.SecondaryChooserFragment;
import com.codekidlabs.storagechooser.models.Config;

public class DiskUtil {
    public static final String IN_KB = "KiB";
    public static final String IN_MB = "MiB";
    public static final String IN_GB = "GiB";
    public static final String SC_PREFERENCE_KEY = "storage_chooser_path";
    public static String SC_CHOOSER_FLAG = "storage_chooser_type";

    public static int getSdkVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static void saveChooserPathPreference(SharedPreferences sharedPreferences, String path) {
        try {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(SC_PREFERENCE_KEY, path);
            editor.apply();
        }
        catch (NullPointerException e) {
            Log.e((String)"StorageChooser", (String)"No sharedPreference was supplied. Supply sharedPreferencesObject via withPreference() or disable saving with actionSave(false)");
        }
    }

    public static boolean isLollipopAndAbove() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static void showSecondaryChooser(String dirPath, Config config) {
        Bundle bundle = new Bundle();
        bundle.putString(SC_PREFERENCE_KEY, dirPath);
        switch (config.getSecondaryAction()) {
            case "none": {
                break;
            }
            case "dir": {
                bundle.putBoolean(SC_CHOOSER_FLAG, false);
                SecondaryChooserFragment c = new SecondaryChooserFragment();
                c.setArguments(bundle);
                c.show(config.getFragmentManager(), "custom_chooser");
                break;
            }
            case "file": {
                bundle.putBoolean(SC_CHOOSER_FLAG, true);
                SecondaryChooserFragment f = new SecondaryChooserFragment();
                f.setArguments(bundle);
                f.show(config.getFragmentManager(), "file_picker");
            }
        }
    }
}

