/*
 * Decompiled with CFR 0.152.
 */
package com.codekidlabs.storagechooser.adapters;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.codekidlabs.storagechooser.R;
import com.codekidlabs.storagechooser.utils.FileUtil;
import com.codekidlabs.storagechooser.utils.ResourceUtil;
import com.codekidlabs.storagechooser.utils.ThumbnailUtil;
import java.util.ArrayList;
import java.util.List;

public class SecondaryChooserAdapter
extends BaseAdapter {
    private List<String> storagesList;
    private Context mContext;
    private int[] scheme;
    public static boolean shouldEnable = true;
    public ArrayList<Integer> selectedPaths;
    public String prefixPath;
    private ThumbnailUtil thumbnailUtil;
    private ResourceUtil resourceUtil;

    public SecondaryChooserAdapter(List<String> storagesList, Context mContext, int[] scheme) {
        this.storagesList = storagesList;
        this.mContext = mContext;
        this.scheme = scheme;
        this.thumbnailUtil = new ThumbnailUtil(mContext);
        this.resourceUtil = new ResourceUtil(mContext);
        this.selectedPaths = new ArrayList();
    }

    public int getCount() {
        return this.storagesList.size();
    }

    public Object getItem(int i) {
        return this.storagesList.get(i);
    }

    public long getItemId(int i) {
        return i;
    }

    public View getView(int i, View view, ViewGroup viewGroup) {
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        View rootView = inflater.inflate(R.layout.row_custom_paths, viewGroup, false);
        ImageView pathFolderIcon = (ImageView)rootView.findViewById(R.id.path_folder_icon);
        if (FileUtil.isDir(this.prefixPath + "/" + this.storagesList.get(i))) {
            this.applyFolderTint(pathFolderIcon);
        }
        this.thumbnailUtil.init(pathFolderIcon, this.storagesList.get(i));
        TextView storageName = (TextView)rootView.findViewById(R.id.storage_name);
        storageName.setText((CharSequence)this.storagesList.get(i));
        storageName.setTextColor(this.scheme[8]);
        if (this.selectedPaths.contains(i)) {
            rootView.setBackgroundColor(this.resourceUtil.getPrimaryColorWithAlpha());
        }
        return rootView;
    }

    private int getSpannableIndex(SpannableStringBuilder str) {
        return str.toString().indexOf("(") + 1;
    }

    public void setPrefixPath(String path) {
        this.prefixPath = path;
    }

    public String getPrefixPath() {
        return this.prefixPath;
    }

    private void applyFolderTint(ImageView im) {
        im.setColorFilter(this.scheme[6]);
    }

    public boolean isEnabled(int position) {
        return shouldEnable;
    }
}

