/*
 * Decompiled with CFR 0.152.
 */
package com.codekidlabs.storagechooser.utils;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.widget.ImageView;
import com.codekidlabs.storagechooser.R;

public class ThumbnailUtil {
    private Context mContext;
    private static final String TEXT_FILE = "txt";
    private static final String CSV_FILE = "csv";
    private static final String PROP_FILE = "prop";
    private static final String VIDEO_FILE = "mp4";
    private static final String VIDEO_MOV_FILE = "mov";
    private static final String VIDEO_AVI_FILE = "avi";
    private static final String VIDEO_MKV_FILE = "mkv";
    private static final String AUDIO_FILE = "mp3";
    private static final String JPEG_FILE = "jpeg";
    private static final String JPG_FILE = "jpg";
    private static final String PNG_FILE = "png";
    private static final String GIF_FILE = "gif";
    private static final String APK_FILE = "apk";
    private static final String ZIP_FILE = "zip";
    private static final String RAR_FILE = "rar";
    private static final String TAR_GZ_FILE = "gz";
    private static final String TAR_FILE = "tar";
    private static final String DOC_FILE = "doc";
    private static final String PPT_FILE = "ppt";
    private static final String EXCEL_FILE = "xls";
    private static final String PDF_FILE = "pdf";
    private static final String TTF_FILE = "ttf";
    private static final String OTF_FILE = "otf";
    private static final String TORRENtT_FILE = "torrent";
    private static final String HTML_FILE = "html";
    private static final String PHP_FILE = "php";
    private static final String CSS_FILE = "css";
    private static final String CR_DL_FILE = "crdownload";

    public ThumbnailUtil(Context mContext) {
        this.mContext = mContext;
    }

    public void init(ImageView imageView, String filePath) {
        this.thumbnailPipe(imageView, filePath);
    }

    private void thumbnailPipe(ImageView imageView, String filePath) {
        String extension;
        switch (extension = this.getExtension(filePath)) {
            case "txt": 
            case "csv": 
            case "doc": 
            case "prop": {
                imageView.setImageDrawable(this.getDrawableFromRes(R.drawable.doc));
                break;
            }
            case "mp4": 
            case "avi": 
            case "mov": 
            case "mkv": {
                imageView.setImageDrawable(this.getDrawableFromRes(R.drawable.mov));
                break;
            }
            case "apk": {
                imageView.setImageDrawable(this.getDrawableFromRes(R.drawable.apk));
                break;
            }
            case "mp3": {
                imageView.setImageDrawable(this.getDrawableFromRes(R.drawable.music));
                break;
            }
            case "zip": 
            case "rar": 
            case "tar": 
            case "gz": {
                imageView.setImageDrawable(this.getDrawableFromRes(R.drawable.zip));
                break;
            }
            case "jpeg": 
            case "jpg": 
            case "png": 
            case "gif": {
                imageView.setImageDrawable(this.getDrawableFromRes(R.drawable.pic));
                break;
            }
            case "ttf": 
            case "otf": {
                imageView.setImageDrawable(this.getDrawableFromRes(R.drawable.font));
                break;
            }
            case "html": 
            case "php": 
            case "css": 
            case "crdownload": {
                imageView.setImageDrawable(this.getDrawableFromRes(R.drawable.web));
                break;
            }
            case "torrent": {
                imageView.setImageDrawable(this.getDrawableFromRes(R.drawable.torrent));
                break;
            }
            case "pdf": {
                imageView.setImageDrawable(this.getDrawableFromRes(R.drawable.pdf));
            }
        }
    }

    private Drawable getDrawableFromRes(int id2) {
        return ContextCompat.getDrawable((Context)this.mContext, (int)id2);
    }

    private String getExtension(String path) {
        return path.substring(path.lastIndexOf(".") + 1, path.length());
    }
}

