/*
 * Decompiled with CFR 0.152.
 */
package com.codekidlabs.storagechooser.fragments;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.codekidlabs.storagechooser.R;
import com.codekidlabs.storagechooser.StorageChooser;
import com.codekidlabs.storagechooser.StorageChooserView;
import com.codekidlabs.storagechooser.adapters.StorageChooserListAdapter;
import com.codekidlabs.storagechooser.fragments.CustomChooserFragment;
import com.codekidlabs.storagechooser.fragments.FilePickerFragment;
import com.codekidlabs.storagechooser.models.Config;
import com.codekidlabs.storagechooser.models.Storages;
import com.codekidlabs.storagechooser.utils.DiskUtil;
import com.codekidlabs.storagechooser.utils.FileUtil;
import com.codekidlabs.storagechooser.utils.MemoryUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ChooserDialogFragment
extends DialogFragment {
    private View mLayout;
    private ViewGroup mContainer;
    private TextView mPathChosen;
    private static final String INTERNAL_STORAGE_TITLE = "Internal Storage";
    private static final String EXTERNAL_STORAGE_TITLE = "External Storage";
    private static final String EXTERNAL_STORAGE_PATH_KITKAT = "/storage/extSdCard";
    private List<Storages> storagesList;
    private List<String> customStoragesList;
    private String TAG = "StorageChooser";
    private MemoryUtil memoryUtil = new MemoryUtil();
    private FileUtil fileUtil = new FileUtil();
    private Config mConfig;
    private int mChooserMode;

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mContainer = container;
        if (this.getShowsDialog()) {
            return super.onCreateView(inflater, container, savedInstanceState);
        }
        return this.getLayout(inflater, container);
    }

    private View getLayout(LayoutInflater inflater, ViewGroup container) {
        this.mConfig = StorageChooser.sConfig;
        this.mLayout = inflater.inflate(R.layout.storage_list, container, false);
        this.initListView(this.getContext(), this.mLayout, this.mConfig.isShowMemoryBar());
        if (StorageChooserView.CHOOSER_HEADING != null) {
            TextView dialogTitle = (TextView)this.mLayout.findViewById(R.id.dialog_title);
            dialogTitle.setText((CharSequence)StorageChooserView.CHOOSER_HEADING);
        }
        return this.mLayout;
    }

    private void initListView(Context context, View view, boolean shouldShowMemoryBar) {
        ListView listView = (ListView)view.findViewById(R.id.storage_list_view);
        this.populateList();
        if (this.mConfig.isSkipOverview()) {
            if (this.mConfig.getPrimaryPath() == null) {
                String dirPath = this.evaluatePath(0);
                this.showSecondaryChooser(dirPath);
            } else {
                this.showSecondaryChooser(this.mConfig.getPrimaryPath());
            }
        } else {
            listView.setAdapter((ListAdapter)new StorageChooserListAdapter(this.storagesList, context, shouldShowMemoryBar));
        }
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                if (ChooserDialogFragment.this.mConfig.isAllowCustomPath()) {
                    if (ChooserDialogFragment.this.mConfig.isApplyThreshold()) {
                        ChooserDialogFragment.this.startThresholdTest(i);
                    } else {
                        String dirPath = ChooserDialogFragment.this.evaluatePath(i);
                        ChooserDialogFragment.this.showSecondaryChooser(dirPath);
                    }
                } else {
                    String dirPath = ChooserDialogFragment.this.evaluatePath(i);
                    if (ChooserDialogFragment.this.mConfig.isActionSave()) {
                        String preDef = ChooserDialogFragment.this.mConfig.getPredefinedPath();
                        if (preDef != null) {
                            if (!preDef.startsWith("/")) {
                                preDef = "/" + preDef;
                            }
                            dirPath = dirPath + preDef;
                            DiskUtil.saveChooserPathPreference(ChooserDialogFragment.this.mConfig.getPreference(), dirPath);
                        } else {
                            Log.w((String)ChooserDialogFragment.this.TAG, (String)"Predefined path is null set it by .withPredefinedPath() to builder. Saving root directory");
                            DiskUtil.saveChooserPathPreference(ChooserDialogFragment.this.mConfig.getPreference(), dirPath);
                        }
                    } else if (ChooserDialogFragment.this.mConfig.isApplyThreshold()) {
                        ChooserDialogFragment.this.startThresholdTest(i);
                    } else if (StorageChooser.onSelectListener != null) {
                        StorageChooser.onSelectListener.onSelect(dirPath);
                    }
                }
                ChooserDialogFragment.this.dismiss();
            }
        });
    }

    private void startThresholdTest(int position) {
        String thresholdSuffix = this.mConfig.getThresholdSuffix();
        if (thresholdSuffix != null) {
            long availableMem = this.memoryUtil.getAvailableMemorySize(this.evaluatePath(position));
            if (this.doesPassThresholdTest(this.mConfig.getMemoryThreshold(), thresholdSuffix, availableMem)) {
                String dirPath = this.evaluatePath(position);
                this.showSecondaryChooser(dirPath);
            } else {
                String suffixedAvailableMem = String.valueOf(this.memoryUtil.suffixedSize(availableMem, thresholdSuffix)) + " " + thresholdSuffix;
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getString(R.string.toast_threshold_breached, new Object[]{suffixedAvailableMem}), (int)0).show();
            }
        } else {
            Log.e((String)this.TAG, (String)"add .withThreshold(int size, String suffix) to your StorageChooser.Builder instance");
        }
    }

    private void showSecondaryChooser(String dirPath) {
        Bundle bundle = new Bundle();
        bundle.putString("storage_chooser_path", dirPath);
        switch (this.mConfig.getSecondaryAction()) {
            case "none": {
                break;
            }
            case "dir": {
                CustomChooserFragment c = new CustomChooserFragment();
                c.setArguments(bundle);
                c.show(this.mConfig.getFragmentManager(), "custom_chooser");
                break;
            }
            case "file": {
                FilePickerFragment f = new FilePickerFragment();
                f.setArguments(bundle);
                f.show(this.mConfig.getFragmentManager(), "file_picker");
            }
        }
    }

    private String evaluatePath(int i) {
        if (i == 0) {
            return Environment.getExternalStorageDirectory().getAbsolutePath();
        }
        return "/storage/" + this.storagesList.get(i).getStorageTitle();
    }

    private boolean doesPassThresholdTest(long threshold, String memorySuffix, long availableSpace) {
        return this.memoryUtil.suffixedSize(availableSpace, memorySuffix) > threshold;
    }

    private void populateList() {
        this.storagesList = new ArrayList<Storages>();
        File storageDir = new File("/storage");
        String internalStoragePath = Environment.getExternalStorageDirectory().getAbsolutePath();
        File[] volumeList = storageDir.listFiles();
        Storages storages = new Storages();
        if (StorageChooserView.INTERNAL_STORAGE_TEXT != null) {
            storages.setStorageTitle(StorageChooserView.INTERNAL_STORAGE_TEXT);
        } else {
            storages.setStorageTitle(INTERNAL_STORAGE_TITLE);
        }
        storages.setStoragePath(internalStoragePath);
        storages.setMemoryTotalSize(this.memoryUtil.formatSize(this.memoryUtil.getTotalMemorySize(internalStoragePath)));
        storages.setMemoryAvailableSize(this.memoryUtil.formatSize(this.memoryUtil.getAvailableMemorySize(internalStoragePath)));
        this.storagesList.add(storages);
        for (File f : volumeList) {
            if (f.getName().equals("self") || f.getName().equals("knox-emulated") || f.getName().equals("emulated") || f.getName().equals("sdcard0")) continue;
            Storages sharedStorage = new Storages();
            String fPath = f.getAbsolutePath();
            sharedStorage.setStorageTitle(f.getName());
            sharedStorage.setMemoryTotalSize(this.memoryUtil.formatSize(this.memoryUtil.getTotalMemorySize(fPath)));
            sharedStorage.setMemoryAvailableSize(this.memoryUtil.formatSize(this.memoryUtil.getAvailableMemorySize(fPath)));
            sharedStorage.setStoragePath(fPath);
            this.storagesList.add(sharedStorage);
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog d = StorageChooser.dialog;
        d.setContentView(this.getLayout(LayoutInflater.from((Context)this.getContext()), this.mContainer));
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.copyFrom(d.getWindow().getAttributes());
        lp.width = -2;
        lp.height = -2;
        d.getWindow().setAttributes(lp);
        return d;
    }
}

