/*
 * Decompiled with CFR 0.152.
 */
package com.chauthai.swipereveallayout;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.support.v4.view.GestureDetectorCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.chauthai.swipereveallayout.R;

@SuppressLint(value={"RtlHardcoded"})
public class SwipeRevealLayout
extends ViewGroup {
    protected static final int STATE_CLOSE = 0;
    protected static final int STATE_CLOSING = 1;
    protected static final int STATE_OPEN = 2;
    protected static final int STATE_OPENING = 3;
    protected static final int STATE_DRAGGING = 4;
    private static final int DEFAULT_MIN_FLING_VELOCITY = 300;
    private static final int DEFAULT_MIN_DIST_REQUEST_DISALLOW_PARENT = 1;
    public static final int DRAG_EDGE_LEFT = 1;
    public static final int DRAG_EDGE_RIGHT = 2;
    public static final int DRAG_EDGE_TOP = 4;
    public static final int DRAG_EDGE_BOTTOM = 8;
    public static final int MODE_NORMAL = 0;
    public static final int MODE_SAME_LEVEL = 1;
    private View mMainView;
    private View mSecondaryView;
    private Rect mRectMainClose = new Rect();
    private Rect mRectMainOpen = new Rect();
    private Rect mRectSecClose = new Rect();
    private Rect mRectSecOpen = new Rect();
    private int mMinDistRequestDisallowParent = 0;
    private boolean mIsOpenBeforeInit = false;
    private volatile boolean mAborted = false;
    private volatile boolean mIsScrolling = false;
    private volatile boolean mLockDrag = false;
    private int mMinFlingVelocity = 300;
    private int mState = 0;
    private int mMode = 0;
    private int mLastMainLeft = 0;
    private int mLastMainTop = 0;
    private int mDragEdge = 1;
    private ViewDragHelper mDragHelper;
    private GestureDetectorCompat mGestureDetector;
    private DragStateChangeListener mDragStateChangeListener;
    private SwipeListener mSwipeListener;
    private int mOnLayoutCount = 0;
    private final GestureDetector.OnGestureListener mGestureListener = new GestureDetector.SimpleOnGestureListener(){
        boolean hasDisallowed = false;

        public boolean onDown(MotionEvent e) {
            SwipeRevealLayout.this.mIsScrolling = false;
            this.hasDisallowed = false;
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            SwipeRevealLayout.this.mIsScrolling = true;
            return false;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            SwipeRevealLayout.this.mIsScrolling = true;
            if (SwipeRevealLayout.this.getParent() != null) {
                boolean shouldDisallow;
                if (!this.hasDisallowed) {
                    boolean bl = shouldDisallow = SwipeRevealLayout.this.getDistToClosestEdge() >= SwipeRevealLayout.this.mMinDistRequestDisallowParent;
                    if (shouldDisallow) {
                        this.hasDisallowed = true;
                    }
                } else {
                    shouldDisallow = true;
                }
                SwipeRevealLayout.this.getParent().requestDisallowInterceptTouchEvent(shouldDisallow);
            }
            return false;
        }
    };
    private final ViewDragHelper.Callback mDragHelperCallback = new ViewDragHelper.Callback(){

        public boolean tryCaptureView(View child, int pointerId) {
            SwipeRevealLayout.this.mAborted = false;
            if (SwipeRevealLayout.this.mLockDrag) {
                return false;
            }
            SwipeRevealLayout.this.mDragHelper.captureChildView(SwipeRevealLayout.this.mMainView, pointerId);
            return false;
        }

        public int clampViewPositionVertical(View child, int top, int dy) {
            switch (SwipeRevealLayout.this.mDragEdge) {
                case 4: {
                    return Math.max(Math.min(top, ((SwipeRevealLayout)SwipeRevealLayout.this).mRectMainClose.top + SwipeRevealLayout.this.mSecondaryView.getHeight()), ((SwipeRevealLayout)SwipeRevealLayout.this).mRectMainClose.top);
                }
                case 8: {
                    return Math.max(Math.min(top, ((SwipeRevealLayout)SwipeRevealLayout.this).mRectMainClose.top), ((SwipeRevealLayout)SwipeRevealLayout.this).mRectMainClose.top - SwipeRevealLayout.this.mSecondaryView.getHeight());
                }
            }
            return child.getTop();
        }

        public int clampViewPositionHorizontal(View child, int left, int dx) {
            switch (SwipeRevealLayout.this.mDragEdge) {
                case 2: {
                    return Math.max(Math.min(left, ((SwipeRevealLayout)SwipeRevealLayout.this).mRectMainClose.left), ((SwipeRevealLayout)SwipeRevealLayout.this).mRectMainClose.left - SwipeRevealLayout.this.mSecondaryView.getWidth());
                }
                case 1: {
                    return Math.max(Math.min(left, ((SwipeRevealLayout)SwipeRevealLayout.this).mRectMainClose.left + SwipeRevealLayout.this.mSecondaryView.getWidth()), ((SwipeRevealLayout)SwipeRevealLayout.this).mRectMainClose.left);
                }
            }
            return child.getLeft();
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            boolean velRightExceeded = SwipeRevealLayout.this.pxToDp((int)xvel) >= SwipeRevealLayout.this.mMinFlingVelocity;
            boolean velLeftExceeded = SwipeRevealLayout.this.pxToDp((int)xvel) <= -SwipeRevealLayout.this.mMinFlingVelocity;
            boolean velUpExceeded = SwipeRevealLayout.this.pxToDp((int)yvel) <= -SwipeRevealLayout.this.mMinFlingVelocity;
            boolean velDownExceeded = SwipeRevealLayout.this.pxToDp((int)yvel) >= SwipeRevealLayout.this.mMinFlingVelocity;
            int pivotHorizontal = SwipeRevealLayout.this.getHalfwayPivotHorizontal();
            int pivotVertical = SwipeRevealLayout.this.getHalfwayPivotVertical();
            switch (SwipeRevealLayout.this.mDragEdge) {
                case 2: {
                    if (velRightExceeded) {
                        SwipeRevealLayout.this.close(true);
                        break;
                    }
                    if (velLeftExceeded) {
                        SwipeRevealLayout.this.open(true);
                        break;
                    }
                    if (SwipeRevealLayout.this.mMainView.getRight() < pivotHorizontal) {
                        SwipeRevealLayout.this.open(true);
                        break;
                    }
                    SwipeRevealLayout.this.close(true);
                    break;
                }
                case 1: {
                    if (velRightExceeded) {
                        SwipeRevealLayout.this.open(true);
                        break;
                    }
                    if (velLeftExceeded) {
                        SwipeRevealLayout.this.close(true);
                        break;
                    }
                    if (SwipeRevealLayout.this.mMainView.getLeft() < pivotHorizontal) {
                        SwipeRevealLayout.this.close(true);
                        break;
                    }
                    SwipeRevealLayout.this.open(true);
                    break;
                }
                case 4: {
                    if (velUpExceeded) {
                        SwipeRevealLayout.this.close(true);
                        break;
                    }
                    if (velDownExceeded) {
                        SwipeRevealLayout.this.open(true);
                        break;
                    }
                    if (SwipeRevealLayout.this.mMainView.getTop() < pivotVertical) {
                        SwipeRevealLayout.this.close(true);
                        break;
                    }
                    SwipeRevealLayout.this.open(true);
                    break;
                }
                case 8: {
                    if (velUpExceeded) {
                        SwipeRevealLayout.this.open(true);
                        break;
                    }
                    if (velDownExceeded) {
                        SwipeRevealLayout.this.close(true);
                        break;
                    }
                    if (SwipeRevealLayout.this.mMainView.getBottom() < pivotVertical) {
                        SwipeRevealLayout.this.open(true);
                        break;
                    }
                    SwipeRevealLayout.this.close(true);
                }
            }
        }

        public void onEdgeDragStarted(int edgeFlags, int pointerId) {
            boolean edgeStartBottom;
            super.onEdgeDragStarted(edgeFlags, pointerId);
            if (SwipeRevealLayout.this.mLockDrag) {
                return;
            }
            boolean edgeStartLeft = SwipeRevealLayout.this.mDragEdge == 2 && edgeFlags == 1;
            boolean edgeStartRight = SwipeRevealLayout.this.mDragEdge == 1 && edgeFlags == 2;
            boolean edgeStartTop = SwipeRevealLayout.this.mDragEdge == 8 && edgeFlags == 4;
            boolean bl = edgeStartBottom = SwipeRevealLayout.this.mDragEdge == 4 && edgeFlags == 8;
            if (edgeStartLeft || edgeStartRight || edgeStartTop || edgeStartBottom) {
                SwipeRevealLayout.this.mDragHelper.captureChildView(SwipeRevealLayout.this.mMainView, pointerId);
            }
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            boolean isMoved;
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            if (SwipeRevealLayout.this.mMode == 1) {
                if (SwipeRevealLayout.this.mDragEdge == 1 || SwipeRevealLayout.this.mDragEdge == 2) {
                    SwipeRevealLayout.this.mSecondaryView.offsetLeftAndRight(dx);
                } else {
                    SwipeRevealLayout.this.mSecondaryView.offsetTopAndBottom(dy);
                }
            }
            boolean bl = isMoved = SwipeRevealLayout.this.mMainView.getLeft() != SwipeRevealLayout.this.mLastMainLeft || SwipeRevealLayout.this.mMainView.getTop() != SwipeRevealLayout.this.mLastMainTop;
            if (SwipeRevealLayout.this.mSwipeListener != null && isMoved) {
                if (SwipeRevealLayout.this.mMainView.getLeft() == ((SwipeRevealLayout)SwipeRevealLayout.this).mRectMainClose.left && SwipeRevealLayout.this.mMainView.getTop() == ((SwipeRevealLayout)SwipeRevealLayout.this).mRectMainClose.top) {
                    SwipeRevealLayout.this.mSwipeListener.onClosed(SwipeRevealLayout.this);
                } else if (SwipeRevealLayout.this.mMainView.getLeft() == ((SwipeRevealLayout)SwipeRevealLayout.this).mRectMainOpen.left && SwipeRevealLayout.this.mMainView.getTop() == ((SwipeRevealLayout)SwipeRevealLayout.this).mRectMainOpen.top) {
                    SwipeRevealLayout.this.mSwipeListener.onOpened(SwipeRevealLayout.this);
                } else {
                    SwipeRevealLayout.this.mSwipeListener.onSlide(SwipeRevealLayout.this, this.getSlideOffset());
                }
            }
            SwipeRevealLayout.this.mLastMainLeft = SwipeRevealLayout.this.mMainView.getLeft();
            SwipeRevealLayout.this.mLastMainTop = SwipeRevealLayout.this.mMainView.getTop();
            ViewCompat.postInvalidateOnAnimation((View)SwipeRevealLayout.this);
        }

        private float getSlideOffset() {
            switch (SwipeRevealLayout.this.mDragEdge) {
                case 1: {
                    return (float)(SwipeRevealLayout.this.mMainView.getLeft() - ((SwipeRevealLayout)SwipeRevealLayout.this).mRectMainClose.left) / (float)SwipeRevealLayout.this.mSecondaryView.getWidth();
                }
                case 2: {
                    return (float)(((SwipeRevealLayout)SwipeRevealLayout.this).mRectMainClose.left - SwipeRevealLayout.this.mMainView.getLeft()) / (float)SwipeRevealLayout.this.mSecondaryView.getWidth();
                }
                case 4: {
                    return (float)(SwipeRevealLayout.this.mMainView.getTop() - ((SwipeRevealLayout)SwipeRevealLayout.this).mRectMainClose.top) / (float)SwipeRevealLayout.this.mSecondaryView.getHeight();
                }
                case 8: {
                    return (float)(((SwipeRevealLayout)SwipeRevealLayout.this).mRectMainClose.top - SwipeRevealLayout.this.mMainView.getTop()) / (float)SwipeRevealLayout.this.mSecondaryView.getHeight();
                }
            }
            return 0.0f;
        }

        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
            int prevState = SwipeRevealLayout.this.mState;
            switch (state) {
                case 1: {
                    SwipeRevealLayout.this.mState = 4;
                    break;
                }
                case 0: {
                    if (SwipeRevealLayout.this.mDragEdge == 1 || SwipeRevealLayout.this.mDragEdge == 2) {
                        if (SwipeRevealLayout.this.mMainView.getLeft() == ((SwipeRevealLayout)SwipeRevealLayout.this).mRectMainClose.left) {
                            SwipeRevealLayout.this.mState = 0;
                            break;
                        }
                        SwipeRevealLayout.this.mState = 2;
                        break;
                    }
                    if (SwipeRevealLayout.this.mMainView.getTop() == ((SwipeRevealLayout)SwipeRevealLayout.this).mRectMainClose.top) {
                        SwipeRevealLayout.this.mState = 0;
                        break;
                    }
                    SwipeRevealLayout.this.mState = 2;
                }
            }
            if (SwipeRevealLayout.this.mDragStateChangeListener != null && !SwipeRevealLayout.this.mAborted && prevState != SwipeRevealLayout.this.mState) {
                SwipeRevealLayout.this.mDragStateChangeListener.onDragStateChanged(SwipeRevealLayout.this.mState);
            }
        }
    };

    public SwipeRevealLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public SwipeRevealLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public SwipeRevealLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mGestureDetector.onTouchEvent(event);
        this.mDragHelper.processTouchEvent(event);
        return true;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.mDragHelper.processTouchEvent(ev);
        this.mGestureDetector.onTouchEvent(ev);
        boolean settling = this.mDragHelper.getViewDragState() == 2;
        boolean idleAfterScrolled = this.mDragHelper.getViewDragState() == 0 && this.mIsScrolling;
        return settling || idleAfterScrolled;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getChildCount() >= 2) {
            this.mSecondaryView = this.getChildAt(0);
            this.mMainView = this.getChildAt(1);
        } else if (this.getChildCount() == 1) {
            this.mMainView = this.getChildAt(0);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mAborted = false;
        for (int index = 0; index < this.getChildCount(); ++index) {
            View child = this.getChildAt(index);
            int bottom = 0;
            int top = 0;
            int right = 0;
            int left = 0;
            int minLeft = this.getPaddingLeft();
            int maxRight = Math.max(r - this.getPaddingRight() - l, 0);
            int minTop = this.getPaddingTop();
            int maxBottom = Math.max(b - this.getPaddingBottom() - t, 0);
            int measuredChildHeight = child.getMeasuredHeight();
            int measuredChildWidth = child.getMeasuredWidth();
            ViewGroup.LayoutParams childParams = child.getLayoutParams();
            boolean matchParentHeight = false;
            boolean matchParentWidth = false;
            if (childParams != null) {
                matchParentHeight = childParams.height == -1 || childParams.height == -1;
                boolean bl = matchParentWidth = childParams.width == -1 || childParams.width == -1;
            }
            if (matchParentHeight) {
                childParams.height = measuredChildHeight = maxBottom - minTop;
            }
            if (matchParentWidth) {
                childParams.width = measuredChildWidth = maxRight - minLeft;
            }
            switch (this.mDragEdge) {
                case 2: {
                    left = Math.max(r - measuredChildWidth - this.getPaddingRight() - l, minLeft);
                    top = Math.min(this.getPaddingTop(), maxBottom);
                    right = Math.max(r - this.getPaddingRight() - l, minLeft);
                    bottom = Math.min(measuredChildHeight + this.getPaddingTop(), maxBottom);
                    break;
                }
                case 1: {
                    left = Math.min(this.getPaddingLeft(), maxRight);
                    top = Math.min(this.getPaddingTop(), maxBottom);
                    right = Math.min(measuredChildWidth + this.getPaddingLeft(), maxRight);
                    bottom = Math.min(measuredChildHeight + this.getPaddingTop(), maxBottom);
                    break;
                }
                case 4: {
                    left = Math.min(this.getPaddingLeft(), maxRight);
                    top = Math.min(this.getPaddingTop(), maxBottom);
                    right = Math.min(measuredChildWidth + this.getPaddingLeft(), maxRight);
                    bottom = Math.min(measuredChildHeight + this.getPaddingTop(), maxBottom);
                    break;
                }
                case 8: {
                    left = Math.min(this.getPaddingLeft(), maxRight);
                    top = Math.max(b - measuredChildHeight - this.getPaddingBottom() - t, minTop);
                    right = Math.min(measuredChildWidth + this.getPaddingLeft(), maxRight);
                    bottom = Math.max(b - this.getPaddingBottom() - t, minTop);
                }
            }
            child.layout(left, top, right, bottom);
        }
        if (this.mMode == 1) {
            switch (this.mDragEdge) {
                case 1: {
                    this.mSecondaryView.offsetLeftAndRight(-this.mSecondaryView.getWidth());
                    break;
                }
                case 2: {
                    this.mSecondaryView.offsetLeftAndRight(this.mSecondaryView.getWidth());
                    break;
                }
                case 4: {
                    this.mSecondaryView.offsetTopAndBottom(-this.mSecondaryView.getHeight());
                    break;
                }
                case 8: {
                    this.mSecondaryView.offsetTopAndBottom(this.mSecondaryView.getHeight());
                }
            }
        }
        this.initRects();
        if (this.mIsOpenBeforeInit) {
            this.open(false);
        } else {
            this.close(false);
        }
        this.mLastMainLeft = this.mMainView.getLeft();
        this.mLastMainTop = this.mMainView.getTop();
        ++this.mOnLayoutCount;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.getChildCount() < 2) {
            throw new RuntimeException("Layout must have two children");
        }
        ViewGroup.LayoutParams params = this.getLayoutParams();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int measuredWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int measuredHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int desiredWidth = 0;
        int desiredHeight = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            ViewGroup.LayoutParams childParams = child.getLayoutParams();
            if (childParams != null) {
                if (childParams.height == -1) {
                    child.setMinimumHeight(measuredHeight);
                }
                if (childParams.width == -1) {
                    child.setMinimumWidth(measuredWidth);
                }
            }
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            desiredWidth = Math.max(child.getMeasuredWidth(), desiredWidth);
            desiredHeight = Math.max(child.getMeasuredHeight(), desiredHeight);
        }
        desiredWidth += this.getPaddingLeft() + this.getPaddingRight();
        desiredHeight += this.getPaddingTop() + this.getPaddingBottom();
        if (widthMode == 0x40000000) {
            desiredWidth = measuredWidth;
        } else {
            if (params.width == -1) {
                desiredWidth = measuredWidth;
            }
            if (widthMode == Integer.MIN_VALUE) {
                int n = desiredWidth = desiredWidth > measuredWidth ? measuredWidth : desiredWidth;
            }
        }
        if (heightMode == 0x40000000) {
            desiredHeight = measuredHeight;
        } else {
            if (params.height == -1) {
                desiredHeight = measuredHeight;
            }
            if (heightMode == Integer.MIN_VALUE) {
                desiredHeight = desiredHeight > measuredHeight ? measuredHeight : desiredHeight;
            }
        }
        this.setMeasuredDimension(desiredWidth, desiredHeight);
    }

    public void computeScroll() {
        if (this.mDragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void open(boolean animation) {
        this.mIsOpenBeforeInit = true;
        this.mAborted = false;
        if (animation) {
            this.mState = 3;
            this.mDragHelper.smoothSlideViewTo(this.mMainView, this.mRectMainOpen.left, this.mRectMainOpen.top);
            if (this.mDragStateChangeListener != null) {
                this.mDragStateChangeListener.onDragStateChanged(this.mState);
            }
        } else {
            this.mState = 2;
            this.mDragHelper.abort();
            this.mMainView.layout(this.mRectMainOpen.left, this.mRectMainOpen.top, this.mRectMainOpen.right, this.mRectMainOpen.bottom);
            this.mSecondaryView.layout(this.mRectSecOpen.left, this.mRectSecOpen.top, this.mRectSecOpen.right, this.mRectSecOpen.bottom);
        }
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    public void close(boolean animation) {
        this.mIsOpenBeforeInit = false;
        this.mAborted = false;
        if (animation) {
            this.mState = 1;
            this.mDragHelper.smoothSlideViewTo(this.mMainView, this.mRectMainClose.left, this.mRectMainClose.top);
            if (this.mDragStateChangeListener != null) {
                this.mDragStateChangeListener.onDragStateChanged(this.mState);
            }
        } else {
            this.mState = 0;
            this.mDragHelper.abort();
            this.mMainView.layout(this.mRectMainClose.left, this.mRectMainClose.top, this.mRectMainClose.right, this.mRectMainClose.bottom);
            this.mSecondaryView.layout(this.mRectSecClose.left, this.mRectSecClose.top, this.mRectSecClose.right, this.mRectSecClose.bottom);
        }
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    public void setMinFlingVelocity(int velocity) {
        this.mMinFlingVelocity = velocity;
    }

    public int getMinFlingVelocity() {
        return this.mMinFlingVelocity;
    }

    public void setDragEdge(int dragEdge) {
        this.mDragEdge = dragEdge;
    }

    public int getDragEdge() {
        return this.mDragEdge;
    }

    public void setSwipeListener(SwipeListener listener) {
        this.mSwipeListener = listener;
    }

    public void setLockDrag(boolean lock) {
        this.mLockDrag = lock;
    }

    public boolean isDragLocked() {
        return this.mLockDrag;
    }

    public boolean isOpened() {
        return this.mState == 2;
    }

    public boolean isClosed() {
        return this.mState == 0;
    }

    void setDragStateChangeListener(DragStateChangeListener listener) {
        this.mDragStateChangeListener = listener;
    }

    protected void abort() {
        this.mAborted = true;
        this.mDragHelper.abort();
    }

    protected boolean shouldRequestLayout() {
        return this.mOnLayoutCount < 2;
    }

    private int getMainOpenLeft() {
        switch (this.mDragEdge) {
            case 1: {
                return this.mRectMainClose.left + this.mSecondaryView.getWidth();
            }
            case 2: {
                return this.mRectMainClose.left - this.mSecondaryView.getWidth();
            }
            case 4: {
                return this.mRectMainClose.left;
            }
            case 8: {
                return this.mRectMainClose.left;
            }
        }
        return 0;
    }

    private int getMainOpenTop() {
        switch (this.mDragEdge) {
            case 1: {
                return this.mRectMainClose.top;
            }
            case 2: {
                return this.mRectMainClose.top;
            }
            case 4: {
                return this.mRectMainClose.top + this.mSecondaryView.getHeight();
            }
            case 8: {
                return this.mRectMainClose.top - this.mSecondaryView.getHeight();
            }
        }
        return 0;
    }

    private int getSecOpenLeft() {
        if (this.mMode == 0 || this.mDragEdge == 8 || this.mDragEdge == 4) {
            return this.mRectSecClose.left;
        }
        if (this.mDragEdge == 1) {
            return this.mRectSecClose.left + this.mSecondaryView.getWidth();
        }
        return this.mRectSecClose.left - this.mSecondaryView.getWidth();
    }

    private int getSecOpenTop() {
        if (this.mMode == 0 || this.mDragEdge == 1 || this.mDragEdge == 2) {
            return this.mRectSecClose.top;
        }
        if (this.mDragEdge == 4) {
            return this.mRectSecClose.top + this.mSecondaryView.getHeight();
        }
        return this.mRectSecClose.top - this.mSecondaryView.getHeight();
    }

    private void initRects() {
        this.mRectMainClose.set(this.mMainView.getLeft(), this.mMainView.getTop(), this.mMainView.getRight(), this.mMainView.getBottom());
        this.mRectSecClose.set(this.mSecondaryView.getLeft(), this.mSecondaryView.getTop(), this.mSecondaryView.getRight(), this.mSecondaryView.getBottom());
        this.mRectMainOpen.set(this.getMainOpenLeft(), this.getMainOpenTop(), this.getMainOpenLeft() + this.mMainView.getWidth(), this.getMainOpenTop() + this.mMainView.getHeight());
        this.mRectSecOpen.set(this.getSecOpenLeft(), this.getSecOpenTop(), this.getSecOpenLeft() + this.mSecondaryView.getWidth(), this.getSecOpenTop() + this.mSecondaryView.getHeight());
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null && context != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SwipeRevealLayout, 0, 0);
            this.mDragEdge = a.getInteger(R.styleable.SwipeRevealLayout_dragEdge, 1);
            this.mMinFlingVelocity = a.getInteger(R.styleable.SwipeRevealLayout_flingVelocity, 300);
            this.mMode = a.getInteger(R.styleable.SwipeRevealLayout_mode, 0);
            this.mMinDistRequestDisallowParent = a.getDimensionPixelSize(R.styleable.SwipeRevealLayout_minDistRequestDisallowParent, this.dpToPx(1));
        }
        this.mDragHelper = ViewDragHelper.create((ViewGroup)this, (float)1.0f, (ViewDragHelper.Callback)this.mDragHelperCallback);
        this.mDragHelper.setEdgeTrackingEnabled(15);
        this.mGestureDetector = new GestureDetectorCompat(context, this.mGestureListener);
    }

    private int getDistToClosestEdge() {
        switch (this.mDragEdge) {
            case 1: {
                int pivotRight = this.mRectMainClose.left + this.mSecondaryView.getWidth();
                return Math.min(this.mMainView.getLeft() - this.mRectMainClose.left, pivotRight - this.mMainView.getLeft());
            }
            case 2: {
                int pivotLeft = this.mRectMainClose.right - this.mSecondaryView.getWidth();
                return Math.min(this.mMainView.getRight() - pivotLeft, this.mRectMainClose.right - this.mMainView.getRight());
            }
            case 4: {
                int pivotBottom = this.mRectMainClose.top + this.mSecondaryView.getHeight();
                return Math.min(this.mMainView.getBottom() - pivotBottom, pivotBottom - this.mMainView.getTop());
            }
            case 8: {
                int pivotTop = this.mRectMainClose.bottom - this.mSecondaryView.getHeight();
                return Math.min(this.mRectMainClose.bottom - this.mMainView.getBottom(), this.mMainView.getBottom() - pivotTop);
            }
        }
        return 0;
    }

    private int getHalfwayPivotHorizontal() {
        if (this.mDragEdge == 1) {
            return this.mRectMainClose.left + this.mSecondaryView.getWidth() / 2;
        }
        return this.mRectMainClose.right - this.mSecondaryView.getWidth() / 2;
    }

    private int getHalfwayPivotVertical() {
        if (this.mDragEdge == 4) {
            return this.mRectMainClose.top + this.mSecondaryView.getHeight() / 2;
        }
        return this.mRectMainClose.bottom - this.mSecondaryView.getHeight() / 2;
    }

    public static String getStateString(int state) {
        switch (state) {
            case 0: {
                return "state_close";
            }
            case 1: {
                return "state_closing";
            }
            case 2: {
                return "state_open";
            }
            case 3: {
                return "state_opening";
            }
            case 4: {
                return "state_dragging";
            }
        }
        return "undefined";
    }

    private int pxToDp(int px) {
        Resources resources = this.getContext().getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        return (int)((float)px / ((float)metrics.densityDpi / 160.0f));
    }

    private int dpToPx(int dp) {
        Resources resources = this.getContext().getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        return (int)((float)dp * ((float)metrics.densityDpi / 160.0f));
    }

    public static class SimpleSwipeListener
    implements SwipeListener {
        @Override
        public void onClosed(SwipeRevealLayout view) {
        }

        @Override
        public void onOpened(SwipeRevealLayout view) {
        }

        @Override
        public void onSlide(SwipeRevealLayout view, float slideOffset) {
        }
    }

    public static interface SwipeListener {
        public void onClosed(SwipeRevealLayout var1);

        public void onOpened(SwipeRevealLayout var1);

        public void onSlide(SwipeRevealLayout var1, float var2);
    }

    static interface DragStateChangeListener {
        public void onDragStateChanged(int var1);
    }
}

