/*
 * Decompiled with CFR 0.152.
 */
package io.changock.driver.api.lock.guard.proxy;

import io.changock.driver.api.lock.LockManager;
import io.changock.driver.api.lock.guard.proxy.LockGuardProxy;
import io.changock.migration.api.annotations.NonLockGuarded;
import io.changock.utils.Utils;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LockGuardProxyFactory {
    private static final List<String> javaPackagePrefixes = Arrays.asList("java.", "com.sun.", "javax.", "jdk.internal.", "sun.");
    private final LockManager lockManager;
    private final Collection<String> notProxiedPackagePrefixes;

    public LockGuardProxyFactory(LockManager lockManager) {
        this(lockManager, Collections.emptyList());
    }

    public LockGuardProxyFactory(LockManager lockManager, String ... notProxiedPackagePrefixes) {
        this(lockManager, Arrays.asList(notProxiedPackagePrefixes));
    }

    public LockGuardProxyFactory(LockManager lockManager, Collection<String> notProxiedPackagePrefixes) {
        this.lockManager = lockManager;
        this.notProxiedPackagePrefixes = new ArrayList<String>(notProxiedPackagePrefixes);
        this.notProxiedPackagePrefixes.addAll(javaPackagePrefixes);
    }

    public <T> T getProxy(T targetObject, Class<? super T> interfaceType) {
        return (T)this.getRawProxy(targetObject, interfaceType);
    }

    public Object getRawProxy(Object targetObject, Class interfaceType) {
        return this.shouldBeLockGuardProxied(targetObject, interfaceType) ? this.createProxy(targetObject, interfaceType) : targetObject;
    }

    private boolean shouldBeLockGuardProxied(Object targetObject, Class interfaceType) {
        return targetObject != null && interfaceType.isInterface() && this.isPackageProxiable(interfaceType.getPackage().getName()) && !interfaceType.isAnnotationPresent(NonLockGuarded.class) && !targetObject.getClass().isAnnotationPresent(NonLockGuarded.class) && !Utils.isBasicTypeJDK(targetObject.getClass()) && !Utils.isBasicTypeJDK((Class)interfaceType);
    }

    private boolean isPackageProxiable(String packageName) {
        return this.notProxiedPackagePrefixes.stream().noneMatch(packageName::startsWith);
    }

    private Object createProxy(Object r, Class type) {
        return Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new LockGuardProxy<Object>(r, this.lockManager, this));
    }
}

