/*
 * Decompiled with CFR 0.152.
 */
package com.claudiodegio.msv.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.claudiodegio.msv.R;
import com.claudiodegio.msv.model.Filter;
import de.hdodenhof.circleimageview.CircleImageView;
import java.util.ArrayList;
import java.util.List;

public class FilterRvAdapter
extends RecyclerView.Adapter<BaseViewHolder> {
    private Context mCtx;
    private LayoutInflater mInflater;
    private List<Filter> mList;

    public FilterRvAdapter(Context context) {
        this.mCtx = context;
        this.mInflater = LayoutInflater.from((Context)context);
        this.mList = new ArrayList<Filter>();
        this.setHasStableIds(false);
    }

    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = null;
        BaseViewHolder holder = null;
        switch (viewType) {
            case 0: {
                view = this.mInflater.inflate(R.layout.msv_filter_iv, parent, false);
                holder = new IvViewHolder(view);
                break;
            }
            case 1: {
                view = this.mInflater.inflate(R.layout.msv_filter_civ, parent, false);
                holder = new CivViewHolder(view);
            }
        }
        return holder;
    }

    public void addFilter(Filter mFilter) {
        for (int i = 0; i < this.mList.size(); ++i) {
            Filter filter = this.mList.get(i);
            if (filter.getType() != mFilter.getType()) continue;
            this.mList.set(i, mFilter);
            this.notifyItemChanged(i);
            return;
        }
        this.mList.add(mFilter);
        this.notifyItemInserted(this.mList.size() - 1);
    }

    public void clear() {
        this.mList.clear();
        this.notifyDataSetChanged();
    }

    public Filter getItem(int position) {
        return this.mList.get(position);
    }

    public Filter removeFilter(int position) {
        Filter filter = this.mList.remove(position);
        this.notifyItemRemoved(position);
        return filter;
    }

    public void setFilters(List<Filter> list) {
        this.mList = list;
        this.notifyDataSetChanged();
    }

    public List<Filter> getFilters() {
        return this.mList;
    }

    public void onBindViewHolder(BaseViewHolder holder, int position) {
        holder.bind(this.mList.get(position));
    }

    public int getItemCount() {
        if (this.mList == null) {
            return 0;
        }
        return this.mList.size();
    }

    public int getItemViewType(int position) {
        Filter filter = this.mList.get(position);
        if (filter.getIconBgColor() == -1) {
            return 0;
        }
        return 1;
    }

    class CivViewHolder
    extends BaseViewHolder {
        CircleImageView mCIV;

        public CivViewHolder(View itemView) {
            super(itemView);
            this.mCIV = (CircleImageView)itemView.findViewById(R.id.civ_icon);
        }

        @Override
        public void bind(Filter filter) {
            super.bind(filter);
            this.mCIV.setImageResource(filter.getIconRefId());
            this.mCIV.setFillColor(filter.getIconBgColor());
        }
    }

    class IvViewHolder
    extends BaseViewHolder {
        ImageView mIv;

        public IvViewHolder(View itemView) {
            super(itemView);
            this.mIv = (ImageView)itemView.findViewById(R.id.iv_icon);
        }

        @Override
        public void bind(Filter filter) {
            super.bind(filter);
            this.mIv.setImageResource(filter.getIconRefId());
        }
    }

    class BaseViewHolder
    extends RecyclerView.ViewHolder {
        TextView mTextView;

        public BaseViewHolder(View itemView) {
            super(itemView);
            this.mTextView = (TextView)itemView.findViewById(16908308);
        }

        public void bind(Filter filter) {
            this.mTextView.setText((CharSequence)filter.getName());
        }
    }
}

