/*
 * Decompiled with CFR 0.152.
 */
package com.claudiodegio.msv;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.TargetApi;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewAnimationUtils;

public class AnimationUtil {
    public static int ANIMATION_DURATION_SHORT = 150;
    public static int ANIMATION_DURATION_MEDIUM = 400;
    public static int ANIMATION_DURATION_LONG = 800;

    public static void crossFadeViews(View showView, View hideView) {
        AnimationUtil.crossFadeViews(showView, hideView, ANIMATION_DURATION_SHORT);
    }

    public static void crossFadeViews(View showView, View hideView, int duration) {
        AnimationUtil.fadeInView(showView, duration);
        AnimationUtil.fadeOutView(hideView, duration);
    }

    public static void fadeInView(View view) {
        AnimationUtil.fadeInView(view, ANIMATION_DURATION_SHORT);
    }

    public static void fadeInView(View view, int duration) {
        AnimationUtil.fadeInView(view, duration, null);
    }

    public static void fadeInView(View view, int duration, final AnimationListener listener) {
        view.setVisibility(0);
        view.setAlpha(0.0f);
        ViewPropertyAnimatorListener vpListener = null;
        if (listener != null) {
            vpListener = new ViewPropertyAnimatorListener(){

                public void onAnimationStart(View view) {
                    if (!listener.onAnimationStart(view)) {
                        view.setDrawingCacheEnabled(true);
                    }
                }

                public void onAnimationEnd(View view) {
                    if (!listener.onAnimationEnd(view)) {
                        view.setDrawingCacheEnabled(false);
                    }
                }

                public void onAnimationCancel(View view) {
                }
            };
        }
        ViewCompat.animate((View)view).alpha(1.0f).setDuration((long)duration).setListener(vpListener);
    }

    @TargetApi(value=21)
    public static void reveal(final View view, final AnimationListener listener) {
        int cx = view.getWidth() - (int)TypedValue.applyDimension((int)1, (float)24.0f, (DisplayMetrics)view.getResources().getDisplayMetrics());
        int cy = view.getHeight() / 2;
        int finalRadius = Math.max(view.getWidth(), view.getHeight());
        Animator anim = ViewAnimationUtils.createCircularReveal((View)view, (int)cx, (int)cy, (float)0.0f, (float)finalRadius);
        view.setVisibility(0);
        anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                listener.onAnimationStart(view);
            }

            public void onAnimationEnd(Animator animation) {
                listener.onAnimationEnd(view);
            }

            public void onAnimationCancel(Animator animation) {
                listener.onAnimationCancel(view);
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        anim.start();
    }

    public static void fadeOutView(View view) {
        AnimationUtil.fadeOutView(view, ANIMATION_DURATION_SHORT);
    }

    public static void fadeOutView(View view, int duration) {
        AnimationUtil.fadeOutView(view, duration, null);
    }

    public static void fadeOutView(View view, int duration, final AnimationListener listener) {
        ViewCompat.animate((View)view).alpha(0.0f).setDuration((long)duration).setListener(new ViewPropertyAnimatorListener(){

            public void onAnimationStart(View view) {
                if (listener == null || !listener.onAnimationStart(view)) {
                    view.setDrawingCacheEnabled(true);
                }
            }

            public void onAnimationEnd(View view) {
                if (listener == null || !listener.onAnimationEnd(view)) {
                    view.setVisibility(8);
                    view.setDrawingCacheEnabled(false);
                }
            }

            public void onAnimationCancel(View view) {
            }
        });
    }

    public static interface AnimationListener {
        public boolean onAnimationStart(View var1);

        public boolean onAnimationEnd(View var1);

        public boolean onAnimationCancel(View var1);
    }
}

