/*
 * Decompiled with CFR 0.152.
 */
package com.github.clans.fab;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.view.animation.Animation;
import android.widget.TextView;
import com.github.clans.fab.FloatingActionButton;
import com.github.clans.fab.Util;

public class Label
extends TextView {
    private static final Xfermode PORTER_DUFF_CLEAR = new PorterDuffXfermode(PorterDuff.Mode.CLEAR);
    private int mShadowRadius;
    private int mShadowXOffset;
    private int mShadowYOffset;
    private int mShadowColor;
    private Drawable mBackgroundDrawable;
    private boolean mShowShadow = true;
    private int mRawWidth;
    private int mRawHeight;
    private int mColorNormal;
    private int mColorPressed;
    private int mColorRipple;
    private int mCornerRadius;
    private FloatingActionButton mFab;
    private Animation mShowAnimation;
    private Animation mHideAnimation;
    private boolean mUsingStyle;
    private boolean mHandleVisibilityChanges = true;
    GestureDetector mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

        public boolean onDown(MotionEvent e) {
            Label.this.onActionDown();
            if (Label.this.mFab != null) {
                Label.this.mFab.onActionDown();
            }
            return super.onDown(e);
        }

        public boolean onSingleTapUp(MotionEvent e) {
            Label.this.onActionUp();
            if (Label.this.mFab != null) {
                Label.this.mFab.onActionUp();
            }
            return super.onSingleTapUp(e);
        }
    });

    public Label(Context context) {
        super(context);
    }

    public Label(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public Label(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.calculateMeasuredWidth(), this.calculateMeasuredHeight());
    }

    private int calculateMeasuredWidth() {
        if (this.mRawWidth == 0) {
            this.mRawWidth = this.getMeasuredWidth();
        }
        return this.getMeasuredWidth() + this.calculateShadowWidth();
    }

    private int calculateMeasuredHeight() {
        if (this.mRawHeight == 0) {
            this.mRawHeight = this.getMeasuredHeight();
        }
        return this.getMeasuredHeight() + this.calculateShadowHeight();
    }

    int calculateShadowWidth() {
        return this.mShowShadow ? this.mShadowRadius + Math.abs(this.mShadowXOffset) : 0;
    }

    int calculateShadowHeight() {
        return this.mShowShadow ? this.mShadowRadius + Math.abs(this.mShadowYOffset) : 0;
    }

    void updateBackground() {
        LayerDrawable layerDrawable;
        if (this.mShowShadow) {
            layerDrawable = new LayerDrawable(new Drawable[]{new Shadow(), this.createFillDrawable()});
            int leftInset = this.mShadowRadius + Math.abs(this.mShadowXOffset);
            int topInset = this.mShadowRadius + Math.abs(this.mShadowYOffset);
            int rightInset = this.mShadowRadius + Math.abs(this.mShadowXOffset);
            int bottomInset = this.mShadowRadius + Math.abs(this.mShadowYOffset);
            layerDrawable.setLayerInset(1, leftInset, topInset, rightInset, bottomInset);
        } else {
            layerDrawable = new LayerDrawable(new Drawable[]{this.createFillDrawable()});
        }
        this.setBackgroundCompat((Drawable)layerDrawable);
    }

    @TargetApi(value=21)
    private Drawable createFillDrawable() {
        StateListDrawable drawable2 = new StateListDrawable();
        drawable2.addState(new int[]{16842919}, this.createRectDrawable(this.mColorPressed));
        drawable2.addState(new int[0], this.createRectDrawable(this.mColorNormal));
        if (Util.hasLollipop()) {
            RippleDrawable ripple = new RippleDrawable(new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{this.mColorRipple}), (Drawable)drawable2, null);
            this.setOutlineProvider(new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    outline.setOval(0, 0, view.getWidth(), view.getHeight());
                }
            });
            this.setClipToOutline(true);
            this.mBackgroundDrawable = ripple;
            return ripple;
        }
        this.mBackgroundDrawable = drawable2;
        return drawable2;
    }

    private Drawable createRectDrawable(int color) {
        RoundRectShape shape = new RoundRectShape(new float[]{this.mCornerRadius, this.mCornerRadius, this.mCornerRadius, this.mCornerRadius, this.mCornerRadius, this.mCornerRadius, this.mCornerRadius, this.mCornerRadius}, null, null);
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)shape);
        shapeDrawable.getPaint().setColor(color);
        return shapeDrawable;
    }

    private void setShadow(FloatingActionButton fab) {
        this.mShadowColor = fab.getShadowColor();
        this.mShadowRadius = fab.getShadowRadius();
        this.mShadowXOffset = fab.getShadowXOffset();
        this.mShadowYOffset = fab.getShadowYOffset();
        this.mShowShadow = fab.hasShadow();
    }

    @TargetApi(value=21)
    private void setBackgroundCompat(Drawable drawable2) {
        if (Util.hasJellyBean()) {
            this.setBackground(drawable2);
        } else {
            this.setBackgroundDrawable(drawable2);
        }
    }

    private void playShowAnimation() {
        if (this.mShowAnimation != null) {
            this.mHideAnimation.cancel();
            this.startAnimation(this.mShowAnimation);
        }
    }

    private void playHideAnimation() {
        if (this.mHideAnimation != null) {
            this.mShowAnimation.cancel();
            this.startAnimation(this.mHideAnimation);
        }
    }

    @TargetApi(value=21)
    void onActionDown() {
        if (this.mUsingStyle) {
            this.mBackgroundDrawable = this.getBackground();
        }
        if (this.mBackgroundDrawable instanceof StateListDrawable) {
            StateListDrawable drawable2 = (StateListDrawable)this.mBackgroundDrawable;
            drawable2.setState(new int[]{16842919});
        } else if (Util.hasLollipop() && this.mBackgroundDrawable instanceof RippleDrawable) {
            RippleDrawable ripple = (RippleDrawable)this.mBackgroundDrawable;
            ripple.setState(new int[]{16842910, 16842919});
            ripple.setHotspot((float)(this.getMeasuredWidth() / 2), (float)(this.getMeasuredHeight() / 2));
            ripple.setVisible(true, true);
        }
        this.setPressed(true);
    }

    @TargetApi(value=21)
    void onActionUp() {
        if (this.mUsingStyle) {
            this.mBackgroundDrawable = this.getBackground();
        }
        if (this.mBackgroundDrawable instanceof StateListDrawable) {
            StateListDrawable drawable2 = (StateListDrawable)this.mBackgroundDrawable;
            drawable2.setState(new int[0]);
        } else if (Util.hasLollipop() && this.mBackgroundDrawable instanceof RippleDrawable) {
            RippleDrawable ripple = (RippleDrawable)this.mBackgroundDrawable;
            ripple.setState(new int[0]);
            ripple.setHotspot((float)(this.getMeasuredWidth() / 2), (float)(this.getMeasuredHeight() / 2));
            ripple.setVisible(true, true);
        }
        this.setPressed(false);
    }

    void setFab(FloatingActionButton fab) {
        this.mFab = fab;
        this.setShadow(fab);
    }

    void setShowShadow(boolean show) {
        this.mShowShadow = show;
    }

    void setCornerRadius(int cornerRadius) {
        this.mCornerRadius = cornerRadius;
    }

    void setColors(int colorNormal, int colorPressed, int colorRipple) {
        this.mColorNormal = colorNormal;
        this.mColorPressed = colorPressed;
        this.mColorRipple = colorRipple;
    }

    void show(boolean animate) {
        if (animate) {
            this.playShowAnimation();
        }
        this.setVisibility(0);
    }

    void hide(boolean animate) {
        if (animate) {
            this.playHideAnimation();
        }
        this.setVisibility(4);
    }

    void setShowAnimation(Animation showAnimation) {
        this.mShowAnimation = showAnimation;
    }

    void setHideAnimation(Animation hideAnimation) {
        this.mHideAnimation = hideAnimation;
    }

    void setUsingStyle(boolean usingStyle) {
        this.mUsingStyle = usingStyle;
    }

    void setHandleVisibilityChanges(boolean handle) {
        this.mHandleVisibilityChanges = handle;
    }

    boolean isHandleVisibilityChanges() {
        return this.mHandleVisibilityChanges;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mFab == null || this.mFab.getOnClickListener() == null || !this.mFab.isEnabled()) {
            return super.onTouchEvent(event);
        }
        int action = event.getAction();
        switch (action) {
            case 1: {
                this.onActionUp();
                this.mFab.onActionUp();
                break;
            }
            case 3: {
                this.onActionUp();
                this.mFab.onActionUp();
            }
        }
        this.mGestureDetector.onTouchEvent(event);
        return super.onTouchEvent(event);
    }

    private class Shadow
    extends Drawable {
        private Paint mPaint = new Paint(1);
        private Paint mErase = new Paint(1);

        private Shadow() {
            this.init();
        }

        private void init() {
            Label.this.setLayerType(1, null);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setColor(Label.this.mColorNormal);
            this.mErase.setXfermode(PORTER_DUFF_CLEAR);
            if (!Label.this.isInEditMode()) {
                this.mPaint.setShadowLayer((float)Label.this.mShadowRadius, (float)Label.this.mShadowXOffset, (float)Label.this.mShadowYOffset, Label.this.mShadowColor);
            }
        }

        public void draw(Canvas canvas) {
            RectF shadowRect = new RectF((float)(Label.this.mShadowRadius + Math.abs(Label.this.mShadowXOffset)), (float)(Label.this.mShadowRadius + Math.abs(Label.this.mShadowYOffset)), (float)Label.this.mRawWidth, (float)Label.this.mRawHeight);
            canvas.drawRoundRect(shadowRect, (float)Label.this.mCornerRadius, (float)Label.this.mCornerRadius, this.mPaint);
            canvas.drawRoundRect(shadowRect, (float)Label.this.mCornerRadius, (float)Label.this.mCornerRadius, this.mErase);
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf) {
        }

        public int getOpacity() {
            return 0;
        }
    }
}

