/*
 * Decompiled with CFR 0.152.
 */
package com.github.clans.fab;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.ImageView;
import com.github.clans.fab.FloatingActionButton;
import com.github.clans.fab.Label;
import com.github.clans.fab.R;
import com.github.clans.fab.Util;

public class FloatingActionMenu
extends ViewGroup {
    private static final int ANIMATION_DURATION = 300;
    private static final float CLOSED_PLUS_ROTATION = 0.0f;
    private static final float OPENED_PLUS_ROTATION_LEFT = -135.0f;
    private static final float OPENED_PLUS_ROTATION_RIGHT = 135.0f;
    private static final int OPEN_UP = 0;
    private static final int OPEN_DOWN = 1;
    private static final int LABELS_POSITION_LEFT = 0;
    private static final int LABELS_POSITION_RIGHT = 1;
    private AnimatorSet mOpenAnimatorSet = new AnimatorSet();
    private AnimatorSet mCloseAnimatorSet = new AnimatorSet();
    private AnimatorSet mIconToggleSet;
    private int mButtonSpacing = Util.dpToPx(this.getContext(), 0.0f);
    private FloatingActionButton mMenuButton;
    private int mMaxButtonWidth;
    private int mLabelsMargin = Util.dpToPx(this.getContext(), 0.0f);
    private int mLabelsVerticalOffset = Util.dpToPx(this.getContext(), 0.0f);
    private int mButtonsCount;
    private boolean mMenuOpened;
    private Handler mUiHandler = new Handler();
    private int mLabelsShowAnimation;
    private int mLabelsHideAnimation;
    private int mLabelsPaddingTop = Util.dpToPx(this.getContext(), 4.0f);
    private int mLabelsPaddingRight = Util.dpToPx(this.getContext(), 8.0f);
    private int mLabelsPaddingBottom = Util.dpToPx(this.getContext(), 4.0f);
    private int mLabelsPaddingLeft = Util.dpToPx(this.getContext(), 8.0f);
    private int mLabelsTextColor;
    private float mLabelsTextSize;
    private int mLabelsCornerRadius = Util.dpToPx(this.getContext(), 3.0f);
    private boolean mLabelsShowShadow;
    private int mLabelsColorNormal;
    private int mLabelsColorPressed;
    private int mLabelsColorRipple;
    private boolean mMenuShowShadow;
    private int mMenuShadowColor;
    private float mMenuShadowRadius = 4.0f;
    private float mMenuShadowXOffset = 1.0f;
    private float mMenuShadowYOffset = 3.0f;
    private int mMenuColorNormal;
    private int mMenuColorPressed;
    private int mMenuColorRipple;
    private Drawable mIcon;
    private int mAnimationDelayPerItem;
    private Interpolator mOpenInterpolator;
    private Interpolator mCloseInterpolator;
    private boolean mIsAnimated = true;
    private boolean mLabelsSingleLine;
    private int mLabelsEllipsize;
    private int mLabelsMaxLines;
    private int mMenuFabSize;
    private int mLabelsStyle;
    private boolean mIconAnimated = true;
    private ImageView mImageToggle;
    private Animation mMenuButtonShowAnimation;
    private Animation mMenuButtonHideAnimation;
    private boolean mIsMenuButtonAnimationRunning;
    private boolean mIsSetClosedOnTouchOutside;
    private int mOpenDirection;
    private OnMenuToggleListener mToggleListener;
    private ValueAnimator mShowBackgroundAnimator;
    private ValueAnimator mHideBackgroundAnimator;
    private int mBackgroundColor;
    private int mLabelsPosition;
    private Context mLabelsContext;
    GestureDetector mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

        public boolean onDown(MotionEvent e) {
            return FloatingActionMenu.this.mIsSetClosedOnTouchOutside && FloatingActionMenu.this.isOpened();
        }

        public boolean onSingleTapUp(MotionEvent e) {
            FloatingActionMenu.this.close(FloatingActionMenu.this.mIsAnimated);
            return true;
        }
    });

    public FloatingActionMenu(Context context) {
        this(context, null);
    }

    public FloatingActionMenu(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FloatingActionMenu(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray attr2 = context.obtainStyledAttributes(attrs, R.styleable.FloatingActionMenu, 0, 0);
        this.mButtonSpacing = attr2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_buttonSpacing, this.mButtonSpacing);
        this.mLabelsMargin = attr2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_labels_margin, this.mLabelsMargin);
        this.mLabelsPosition = attr2.getInt(R.styleable.FloatingActionMenu_menu_labels_position, 0);
        this.mLabelsShowAnimation = attr2.getResourceId(R.styleable.FloatingActionMenu_menu_labels_showAnimation, this.mLabelsPosition == 0 ? R.anim.fab_slide_in_from_right : R.anim.fab_slide_in_from_left);
        this.mLabelsHideAnimation = attr2.getResourceId(R.styleable.FloatingActionMenu_menu_labels_hideAnimation, this.mLabelsPosition == 0 ? R.anim.fab_slide_out_to_right : R.anim.fab_slide_out_to_left);
        this.mLabelsPaddingTop = attr2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_labels_paddingTop, this.mLabelsPaddingTop);
        this.mLabelsPaddingRight = attr2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_labels_paddingRight, this.mLabelsPaddingRight);
        this.mLabelsPaddingBottom = attr2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_labels_paddingBottom, this.mLabelsPaddingBottom);
        this.mLabelsPaddingLeft = attr2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_labels_paddingLeft, this.mLabelsPaddingLeft);
        this.mLabelsTextColor = attr2.getColor(R.styleable.FloatingActionMenu_menu_labels_textColor, -1);
        this.mLabelsTextSize = attr2.getDimension(R.styleable.FloatingActionMenu_menu_labels_textSize, this.getResources().getDimension(R.dimen.labels_text_size));
        this.mLabelsCornerRadius = attr2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_labels_cornerRadius, this.mLabelsCornerRadius);
        this.mLabelsShowShadow = attr2.getBoolean(R.styleable.FloatingActionMenu_menu_labels_showShadow, true);
        this.mLabelsColorNormal = attr2.getColor(R.styleable.FloatingActionMenu_menu_labels_colorNormal, -13421773);
        this.mLabelsColorPressed = attr2.getColor(R.styleable.FloatingActionMenu_menu_labels_colorPressed, -12303292);
        this.mLabelsColorRipple = attr2.getColor(R.styleable.FloatingActionMenu_menu_labels_colorRipple, 0x66FFFFFF);
        this.mMenuShowShadow = attr2.getBoolean(R.styleable.FloatingActionMenu_menu_showShadow, true);
        this.mMenuShadowColor = attr2.getColor(R.styleable.FloatingActionMenu_menu_shadowColor, 0x66000000);
        this.mMenuShadowRadius = attr2.getDimension(R.styleable.FloatingActionMenu_menu_shadowRadius, this.mMenuShadowRadius);
        this.mMenuShadowXOffset = attr2.getDimension(R.styleable.FloatingActionMenu_menu_shadowXOffset, this.mMenuShadowXOffset);
        this.mMenuShadowYOffset = attr2.getDimension(R.styleable.FloatingActionMenu_menu_shadowYOffset, this.mMenuShadowYOffset);
        this.mMenuColorNormal = attr2.getColor(R.styleable.FloatingActionMenu_menu_colorNormal, -2473162);
        this.mMenuColorPressed = attr2.getColor(R.styleable.FloatingActionMenu_menu_colorPressed, -1617853);
        this.mMenuColorRipple = attr2.getColor(R.styleable.FloatingActionMenu_menu_colorRipple, -1711276033);
        this.mAnimationDelayPerItem = attr2.getInt(R.styleable.FloatingActionMenu_menu_animationDelayPerItem, 50);
        this.mIcon = attr2.getDrawable(R.styleable.FloatingActionMenu_menu_icon);
        if (this.mIcon == null) {
            this.mIcon = this.getResources().getDrawable(R.drawable.fab_add);
        }
        this.mLabelsSingleLine = attr2.getBoolean(R.styleable.FloatingActionMenu_menu_labels_singleLine, false);
        this.mLabelsEllipsize = attr2.getInt(R.styleable.FloatingActionMenu_menu_labels_ellipsize, 0);
        this.mLabelsMaxLines = attr2.getInt(R.styleable.FloatingActionMenu_menu_labels_maxLines, -1);
        this.mMenuFabSize = attr2.getInt(R.styleable.FloatingActionMenu_menu_fab_size, 0);
        this.mLabelsStyle = attr2.getResourceId(R.styleable.FloatingActionMenu_menu_labels_style, 0);
        this.mOpenDirection = attr2.getInt(R.styleable.FloatingActionMenu_menu_openDirection, 0);
        this.mBackgroundColor = attr2.getColor(R.styleable.FloatingActionMenu_menu_backgroundColor, 0);
        if (attr2.hasValue(R.styleable.FloatingActionMenu_menu_labels_padding)) {
            int padding = attr2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_labels_padding, 0);
            this.initPadding(padding);
        }
        attr2.recycle();
        this.mOpenInterpolator = new OvershootInterpolator();
        this.mCloseInterpolator = new AnticipateInterpolator();
        this.mLabelsContext = new ContextThemeWrapper(this.getContext(), this.mLabelsStyle);
        this.initMenuButtonAnimations();
        this.initBackgroundDimAnimation();
        this.createMenuButton();
    }

    private void initMenuButtonAnimations() {
        this.mMenuButtonShowAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.fab_scale_up);
        this.mMenuButtonHideAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.fab_scale_down);
    }

    private void initBackgroundDimAnimation() {
        int maxAlpha = Color.alpha((int)this.mBackgroundColor);
        final int red = Color.red((int)this.mBackgroundColor);
        final int green = Color.green((int)this.mBackgroundColor);
        final int blue = Color.blue((int)this.mBackgroundColor);
        this.mShowBackgroundAnimator = ValueAnimator.ofInt((int[])new int[]{0, maxAlpha});
        this.mShowBackgroundAnimator.setDuration(300L);
        this.mShowBackgroundAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Integer alpha = (Integer)animation.getAnimatedValue();
                FloatingActionMenu.this.setBackgroundColor(Color.argb((int)alpha, (int)red, (int)green, (int)blue));
            }
        });
        this.mHideBackgroundAnimator = ValueAnimator.ofInt((int[])new int[]{maxAlpha, 0});
        this.mHideBackgroundAnimator.setDuration(300L);
        this.mHideBackgroundAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Integer alpha = (Integer)animation.getAnimatedValue();
                FloatingActionMenu.this.setBackgroundColor(Color.argb((int)alpha, (int)red, (int)green, (int)blue));
            }
        });
    }

    private boolean isBackgroundEnabled() {
        return this.mBackgroundColor != 0;
    }

    private void initPadding(int padding) {
        this.mLabelsPaddingTop = padding;
        this.mLabelsPaddingRight = padding;
        this.mLabelsPaddingBottom = padding;
        this.mLabelsPaddingLeft = padding;
    }

    private void createMenuButton() {
        this.mMenuButton = new FloatingActionButton(this.getContext());
        this.mMenuButton.mShowShadow = this.mMenuShowShadow;
        if (this.mMenuShowShadow) {
            this.mMenuButton.mShadowRadius = Util.dpToPx(this.getContext(), this.mMenuShadowRadius);
            this.mMenuButton.mShadowXOffset = Util.dpToPx(this.getContext(), this.mMenuShadowXOffset);
            this.mMenuButton.mShadowYOffset = Util.dpToPx(this.getContext(), this.mMenuShadowYOffset);
        }
        this.mMenuButton.setColors(this.mMenuColorNormal, this.mMenuColorPressed, this.mMenuColorRipple);
        this.mMenuButton.mShadowColor = this.mMenuShadowColor;
        this.mMenuButton.mFabSize = this.mMenuFabSize;
        this.mMenuButton.updateBackground();
        this.mMenuButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FloatingActionMenu.this.toggle(FloatingActionMenu.this.mIsAnimated);
            }
        });
        this.mImageToggle = new ImageView(this.getContext());
        this.mImageToggle.setImageDrawable(this.mIcon);
        this.addView((View)this.mMenuButton, super.generateDefaultLayoutParams());
        this.addView((View)this.mImageToggle);
        this.createDefaultIconAnimation();
    }

    private void createDefaultIconAnimation() {
        float expandAngle;
        float collapseAngle;
        if (this.mOpenDirection == 0) {
            collapseAngle = this.mLabelsPosition == 0 ? -135.0f : 135.0f;
            expandAngle = this.mLabelsPosition == 0 ? -135.0f : 135.0f;
        } else {
            collapseAngle = this.mLabelsPosition == 0 ? 135.0f : -135.0f;
            expandAngle = this.mLabelsPosition == 0 ? 135.0f : -135.0f;
        }
        ObjectAnimator collapseAnimator = ObjectAnimator.ofFloat((Object)this.mImageToggle, (String)"rotation", (float[])new float[]{collapseAngle, 0.0f});
        ObjectAnimator expandAnimator = ObjectAnimator.ofFloat((Object)this.mImageToggle, (String)"rotation", (float[])new float[]{0.0f, expandAngle});
        this.mOpenAnimatorSet.play((Animator)expandAnimator);
        this.mCloseAnimatorSet.play((Animator)collapseAnimator);
        this.mOpenAnimatorSet.setInterpolator((TimeInterpolator)this.mOpenInterpolator);
        this.mCloseAnimatorSet.setInterpolator((TimeInterpolator)this.mCloseInterpolator);
        this.mOpenAnimatorSet.setDuration(300L);
        this.mCloseAnimatorSet.setDuration(300L);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int i;
        int width = 0;
        int height = 0;
        this.mMaxButtonWidth = 0;
        int maxLabelWidth = 0;
        this.measureChildWithMargins((View)this.mImageToggle, widthMeasureSpec, 0, heightMeasureSpec, 0);
        for (i = 0; i < this.mButtonsCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8 || child == this.mImageToggle) continue;
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
            this.mMaxButtonWidth = Math.max(this.mMaxButtonWidth, child.getMeasuredWidth());
        }
        for (i = 0; i < this.mButtonsCount; ++i) {
            int usedWidth = 0;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8 || child == this.mImageToggle) continue;
            usedWidth += child.getMeasuredWidth();
            height += child.getMeasuredHeight();
            Label label = (Label)((Object)child.getTag(R.id.fab_label));
            if (label == null) continue;
            int labelOffset = (this.mMaxButtonWidth - child.getMeasuredWidth()) / 2;
            int labelUsedWidth = child.getMeasuredWidth() + label.calculateShadowWidth() + this.mLabelsMargin + labelOffset;
            this.measureChildWithMargins((View)label, widthMeasureSpec, labelUsedWidth, heightMeasureSpec, 0);
            maxLabelWidth = Math.max(maxLabelWidth, (usedWidth += label.getMeasuredWidth()) + labelOffset);
        }
        width = Math.max(this.mMaxButtonWidth, maxLabelWidth + this.mLabelsMargin) + this.getPaddingLeft() + this.getPaddingRight();
        height += this.mButtonSpacing * (this.mButtonsCount - 1) + this.getPaddingTop() + this.getPaddingBottom();
        height = this.adjustForOvershoot(height);
        if (this.getLayoutParams().width == -1) {
            width = FloatingActionMenu.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        }
        if (this.getLayoutParams().height == -1) {
            height = FloatingActionMenu.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int buttonsHorizontalCenter = this.mLabelsPosition == 0 ? r - l - this.mMaxButtonWidth / 2 - this.getPaddingRight() : this.mMaxButtonWidth / 2 + this.getPaddingLeft();
        boolean openUp = this.mOpenDirection == 0;
        int menuButtonTop = openUp ? b - t - this.mMenuButton.getMeasuredHeight() - this.getPaddingBottom() : this.getPaddingTop();
        int menuButtonLeft = buttonsHorizontalCenter - this.mMenuButton.getMeasuredWidth() / 2;
        this.mMenuButton.layout(menuButtonLeft, menuButtonTop, menuButtonLeft + this.mMenuButton.getMeasuredWidth(), menuButtonTop + this.mMenuButton.getMeasuredHeight());
        int imageLeft = buttonsHorizontalCenter - this.mImageToggle.getMeasuredWidth() / 2;
        int imageTop = menuButtonTop + this.mMenuButton.getMeasuredHeight() / 2 - this.mImageToggle.getMeasuredHeight() / 2;
        this.mImageToggle.layout(imageLeft, imageTop, imageLeft + this.mImageToggle.getMeasuredWidth(), imageTop + this.mImageToggle.getMeasuredHeight());
        int nextY = openUp ? menuButtonTop - this.mButtonSpacing : menuButtonTop + this.mMenuButton.getMeasuredHeight() + this.mButtonSpacing;
        for (int i = this.mButtonsCount - 1; i >= 0; --i) {
            View label;
            FloatingActionButton fab;
            View child = this.getChildAt(i);
            if (child == this.mImageToggle || (fab = (FloatingActionButton)child) == this.mMenuButton || fab.getVisibility() == 8) continue;
            int childX = buttonsHorizontalCenter - fab.getMeasuredWidth() / 2;
            int childY = openUp ? nextY - fab.getMeasuredHeight() : nextY;
            fab.layout(childX, childY, childX + fab.getMeasuredWidth(), childY + fab.getMeasuredHeight());
            if (!this.mMenuOpened) {
                fab.hide(false);
            }
            if ((label = (View)fab.getTag(R.id.fab_label)) != null) {
                int labelsOffset = fab.getMeasuredWidth() / 2 + this.mLabelsMargin;
                int labelXNearButton = this.mLabelsPosition == 0 ? buttonsHorizontalCenter - labelsOffset : buttonsHorizontalCenter + labelsOffset;
                int labelXAwayFromButton = this.mLabelsPosition == 0 ? labelXNearButton - label.getMeasuredWidth() : labelXNearButton + label.getMeasuredWidth();
                int labelLeft = this.mLabelsPosition == 0 ? labelXAwayFromButton : labelXNearButton;
                int labelRight = this.mLabelsPosition == 0 ? labelXNearButton : labelXAwayFromButton;
                int labelTop = childY - this.mLabelsVerticalOffset + (fab.getMeasuredHeight() - label.getMeasuredHeight()) / 2;
                label.layout(labelLeft, labelTop, labelRight, labelTop + label.getMeasuredHeight());
                if (!this.mMenuOpened) {
                    label.setVisibility(4);
                }
            }
            nextY = openUp ? childY - this.mButtonSpacing : childY + child.getMeasuredHeight() + this.mButtonSpacing;
        }
    }

    private int adjustForOvershoot(int dimension) {
        return (int)((double)dimension * 0.03 + (double)dimension);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.bringChildToFront((View)this.mMenuButton);
        this.bringChildToFront((View)this.mImageToggle);
        this.mButtonsCount = this.getChildCount();
        this.createLabels();
    }

    private void createLabels() {
        for (int i = 0; i < this.mButtonsCount; ++i) {
            FloatingActionButton fab;
            if (this.getChildAt(i) == this.mImageToggle || (fab = (FloatingActionButton)this.getChildAt(i)) == this.mMenuButton || fab.getTag(R.id.fab_label) != null) continue;
            this.addLabel(fab);
        }
    }

    private void addLabel(FloatingActionButton fab) {
        String text = fab.getLabelText();
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        Label label = new Label(this.mLabelsContext);
        label.setFab(fab);
        label.setShowAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)this.mLabelsShowAnimation));
        label.setHideAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)this.mLabelsHideAnimation));
        if (this.mLabelsStyle > 0) {
            label.setTextAppearance(this.getContext(), this.mLabelsStyle);
            label.setShowShadow(false);
            label.setUsingStyle(true);
        } else {
            label.setColors(this.mLabelsColorNormal, this.mLabelsColorPressed, this.mLabelsColorRipple);
            label.setShowShadow(this.mLabelsShowShadow);
            label.setCornerRadius(this.mLabelsCornerRadius);
            if (this.mLabelsEllipsize > 0) {
                this.setLabelEllipsize(label);
            }
            label.setMaxLines(this.mLabelsMaxLines);
            label.updateBackground();
            label.setTextSize(0, this.mLabelsTextSize);
            label.setTextColor(this.mLabelsTextColor);
            int left = this.mLabelsPaddingLeft;
            int top = this.mLabelsPaddingTop;
            if (this.mLabelsShowShadow) {
                left += fab.getShadowRadius() + Math.abs(fab.getShadowXOffset());
                top += fab.getShadowRadius() + Math.abs(fab.getShadowYOffset());
            }
            label.setPadding(left, top, this.mLabelsPaddingLeft, this.mLabelsPaddingTop);
            if (this.mLabelsMaxLines < 0 || this.mLabelsSingleLine) {
                label.setSingleLine(this.mLabelsSingleLine);
            }
        }
        label.setText(text);
        this.addView((View)label);
        fab.setTag(R.id.fab_label, (Object)label);
    }

    private void setLabelEllipsize(Label label) {
        switch (this.mLabelsEllipsize) {
            case 1: {
                label.setEllipsize(TextUtils.TruncateAt.START);
                break;
            }
            case 2: {
                label.setEllipsize(TextUtils.TruncateAt.MIDDLE);
                break;
            }
            case 3: {
                label.setEllipsize(TextUtils.TruncateAt.END);
                break;
            }
            case 4: {
                label.setEllipsize(TextUtils.TruncateAt.MARQUEE);
            }
        }
    }

    public ViewGroup.MarginLayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.MarginLayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new ViewGroup.MarginLayoutParams(p);
    }

    protected ViewGroup.MarginLayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-2, -2);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof ViewGroup.MarginLayoutParams;
    }

    private void hideMenuButtonWithImage(boolean animate) {
        if (!this.isMenuButtonHidden()) {
            this.mMenuButton.hide(animate);
            if (animate) {
                this.mImageToggle.startAnimation(this.mMenuButtonHideAnimation);
            }
            this.mImageToggle.setVisibility(4);
            this.mIsMenuButtonAnimationRunning = false;
        }
    }

    private void showMenuButtonWithImage(boolean animate) {
        if (this.isMenuButtonHidden()) {
            this.mMenuButton.show(animate);
            if (animate) {
                this.mImageToggle.startAnimation(this.mMenuButtonShowAnimation);
            }
            this.mImageToggle.setVisibility(0);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mIsSetClosedOnTouchOutside) {
            return this.mGestureDetector.onTouchEvent(event);
        }
        return super.onTouchEvent(event);
    }

    public boolean isOpened() {
        return this.mMenuOpened;
    }

    public void toggle(boolean animate) {
        if (this.isOpened()) {
            this.close(animate);
        } else {
            this.open(animate);
        }
    }

    public void open(final boolean animate) {
        if (!this.isOpened()) {
            if (this.isBackgroundEnabled()) {
                this.mShowBackgroundAnimator.start();
            }
            if (this.mIconAnimated) {
                if (this.mIconToggleSet != null) {
                    this.mIconToggleSet.start();
                } else {
                    this.mCloseAnimatorSet.cancel();
                    this.mOpenAnimatorSet.start();
                }
            }
            int delay = 0;
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                View child = this.getChildAt(i);
                if (!(child instanceof FloatingActionButton) || child == this.mMenuButton || child.getVisibility() == 8) continue;
                final FloatingActionButton fab = (FloatingActionButton)child;
                final int count = i;
                this.mUiHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (FloatingActionMenu.this.isOpened()) {
                            return;
                        }
                        fab.show(animate);
                        Label label = (Label)((Object)fab.getTag(R.id.fab_label));
                        if (label != null) {
                            label.show(animate);
                        }
                        if (count == 0) {
                            FloatingActionMenu.this.mMenuOpened = true;
                        }
                    }
                }, (long)delay);
                delay += this.mAnimationDelayPerItem;
            }
            if (this.mToggleListener != null) {
                this.mToggleListener.onMenuToggle(true);
            }
        }
    }

    public void close(final boolean animate) {
        if (this.isOpened()) {
            if (this.isBackgroundEnabled()) {
                this.mHideBackgroundAnimator.start();
            }
            if (this.mIconAnimated) {
                if (this.mIconToggleSet != null) {
                    this.mIconToggleSet.start();
                } else {
                    this.mCloseAnimatorSet.start();
                    this.mOpenAnimatorSet.cancel();
                }
            }
            int delay = 0;
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                if (!(child instanceof FloatingActionButton) || child == this.mMenuButton || child.getVisibility() == 8) continue;
                final FloatingActionButton fab = (FloatingActionButton)child;
                final int count = i;
                this.mUiHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (!FloatingActionMenu.this.isOpened()) {
                            return;
                        }
                        fab.hide(animate);
                        Label label = (Label)((Object)fab.getTag(R.id.fab_label));
                        if (label != null) {
                            label.hide(animate);
                        }
                        if (count == FloatingActionMenu.this.mButtonsCount - 3) {
                            FloatingActionMenu.this.mMenuOpened = false;
                        }
                    }
                }, (long)delay);
                delay += this.mAnimationDelayPerItem;
            }
            if (this.mToggleListener != null) {
                this.mToggleListener.onMenuToggle(false);
            }
        }
    }

    public void setIconAnimationInterpolator(Interpolator interpolator) {
        this.mOpenAnimatorSet.setInterpolator((TimeInterpolator)interpolator);
        this.mCloseAnimatorSet.setInterpolator((TimeInterpolator)interpolator);
    }

    public void setIconAnimationOpenInterpolator(Interpolator openInterpolator) {
        this.mOpenAnimatorSet.setInterpolator((TimeInterpolator)openInterpolator);
    }

    public void setIconAnimationCloseInterpolator(Interpolator closeInterpolator) {
        this.mCloseAnimatorSet.setInterpolator((TimeInterpolator)closeInterpolator);
    }

    public void setAnimated(boolean animated) {
        this.mIsAnimated = animated;
        this.mOpenAnimatorSet.setDuration(animated ? 300L : 0L);
        this.mCloseAnimatorSet.setDuration(animated ? 300L : 0L);
    }

    public boolean isAnimated() {
        return this.mIsAnimated;
    }

    public void setAnimationDelayPerItem(int animationDelayPerItem) {
        this.mAnimationDelayPerItem = animationDelayPerItem;
    }

    public int getAnimationDelayPerItem() {
        return this.mAnimationDelayPerItem;
    }

    public void setOnMenuToggleListener(OnMenuToggleListener listener) {
        this.mToggleListener = listener;
    }

    public void setIconAnimated(boolean animated) {
        this.mIconAnimated = animated;
    }

    public boolean isIconAnimated() {
        return this.mIconAnimated;
    }

    public ImageView getMenuIconView() {
        return this.mImageToggle;
    }

    public void setIconToggleAnimatorSet(AnimatorSet toggleAnimatorSet) {
        this.mIconToggleSet = toggleAnimatorSet;
    }

    public AnimatorSet getIconToggleAnimatorSet() {
        return this.mIconToggleSet;
    }

    public void setMenuButtonShowAnimation(Animation showAnimation) {
        this.mMenuButtonShowAnimation = showAnimation;
        this.mMenuButton.setShowAnimation(showAnimation);
    }

    public void setMenuButtonHideAnimation(Animation hideAnimation) {
        this.mMenuButtonHideAnimation = hideAnimation;
        this.mMenuButton.setHideAnimation(hideAnimation);
    }

    public boolean isMenuButtonHidden() {
        return this.mMenuButton.isHidden();
    }

    public void showMenuButton(boolean animate) {
        if (this.isMenuButtonHidden()) {
            this.showMenuButtonWithImage(animate);
        }
    }

    public void hideMenuButton(final boolean animate) {
        if (!this.isMenuButtonHidden() && !this.mIsMenuButtonAnimationRunning) {
            this.mIsMenuButtonAnimationRunning = true;
            if (this.isOpened()) {
                this.close(animate);
                this.mUiHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        FloatingActionMenu.this.hideMenuButtonWithImage(animate);
                    }
                }, (long)(this.mAnimationDelayPerItem * this.mButtonsCount));
            } else {
                this.hideMenuButtonWithImage(animate);
            }
        }
    }

    public void toggleMenuButton(boolean animate) {
        if (this.isMenuButtonHidden()) {
            this.showMenuButton(animate);
        } else {
            this.hideMenuButton(animate);
        }
    }

    public void setClosedOnTouchOutside(boolean close) {
        this.mIsSetClosedOnTouchOutside = close;
    }

    public void setMenuButtonColorNormal(int color) {
        this.mMenuColorNormal = color;
        this.mMenuButton.setColorNormal(color);
    }

    public void setMenuButtonColorNormalResId(int colorResId) {
        this.mMenuColorNormal = this.getResources().getColor(colorResId);
        this.mMenuButton.setColorNormalResId(colorResId);
    }

    public int getMenuButtonColorNormal() {
        return this.mMenuColorNormal;
    }

    public void setMenuButtonColorPressed(int color) {
        this.mMenuColorPressed = color;
        this.mMenuButton.setColorPressed(color);
    }

    public void setMenuButtonColorPressedResId(int colorResId) {
        this.mMenuColorPressed = this.getResources().getColor(colorResId);
        this.mMenuButton.setColorPressedResId(colorResId);
    }

    public int getMenuButtonColorPressed() {
        return this.mMenuColorPressed;
    }

    public void setMenuButtonColorRipple(int color) {
        this.mMenuColorRipple = color;
        this.mMenuButton.setColorRipple(color);
    }

    public void setMenuButtonColorRippleResId(int colorResId) {
        this.mMenuColorRipple = this.getResources().getColor(colorResId);
        this.mMenuButton.setColorRippleResId(colorResId);
    }

    public int getMenuButtonColorRipple() {
        return this.mMenuColorRipple;
    }

    public void addMenuButton(FloatingActionButton fab) {
        this.addView((View)fab, this.mButtonsCount - 2);
        ++this.mButtonsCount;
        this.addLabel(fab);
    }

    public void removeMenuButton(FloatingActionButton fab) {
        this.removeView((View)fab.getLabelView());
        this.removeView((View)fab);
        --this.mButtonsCount;
    }

    public static interface OnMenuToggleListener {
        public void onMenuToggle(boolean var1);
    }
}

